/*******************************************************
FileName	  :  ws_station_view.sql 
Author		  :  Sree Rayankula  
Date		  :  05/16/2007 
Description	  :  creates lws_station_view
Assumption	  :  STORET Datawarehouse schemata and its 
			  	 objects are created on the database server. 
Comments	  :	 Modified on 06/01/2007 to move the grants
			  	 to ws_grants.sql  
*******************************************************/  

spool station_view.log

set serveroutput on;

PROMPT Creating View WS_STATION_VIEW
CREATE OR REPLACE FORCE VIEW WS_STATION_VIEW
 AS SELECT sd.PK_ISN,
	sd.ORGANIZATION_ID,
	org.ORGANIZATION_NAME,
	sd.STATION_ID,
	sd.STATION_NAME,
	st.PRIMARY_TYPE,
	case when (st.secondary_type is not null) and upper(trim(st.secondary_type)) <> 'NONE' then
	', ' || st.SECONDARY_TYPE else
	'' end as SECONDARY_TYPE,
	sd.DESCRIPTION_TEXT,
	sd.HYDROLOGIC_UNIT_CODE,
	ca.HYDROLOGIC_UNIT_NAME,
	sd.NRCS_WATERSHED_ID,
	sd.FRS_KEY_IDENTIFIER,
	ep.PRIMARY_ESTUARY,
	es.SECONDARY_ESTUARY,
	sd.OTHER_ESTUARY_NAME,
	sd.GREAT_LAKE_NAME,
	sd.OCEAN_NAME,
	sd.WELL_NUMBER,
	sd.PIPE_NUMBER,	
	sd.NATV_AMERICAN_LAND_NAME,	
	sd.STD_LATITUDE,
	sd.STD_LONGITUDE,
	sd.MAP_SCALE,	
	hm.GEOPOSITIONING_METHOD,
	hd.ID_CODE as Horizontal_Ref_Datum_Code,	
	hd.HORIZONTAL_DATUM,
	sd.ELEVATION as Vertical_Measure_Value,
	vd.ID_CODE as Vertical_Reference_Datum_Code,
	vm.ELEVATION_METHOD as Vertical_Collection_Method,		
	vd.ELEVATION_DATUM as Vertical_Reference_Datum,
	gs.COUNTRY_CODE,
	gs.COUNTRY_NAME,
	gs.STATE_POSTAL_CODE,
	gs.STATE_NAME,
	null as COUNTY_CODE,
	gc.COUNTY_NAME,	
	sd.POINT_SEQUENCE_NUMBER,
	sd.RF1_SEGMENT_CODE,
	sd.RF1_SEGMENT_NAME,
	sd.RF1_MILEAGE,
	sd.SGO_INDICATOR,
	sd.ON_REACH_IND,
	sd.LOCATION_POINT_TYPE	
FROM FA_STATION sd,
	DI_ORG org,
	DI_STATN_TYPES st,
	LU_MAD_HDATUM hd,
	LU_MAD_HMETHOD hm,
	LU_MAD_VDATUM vd,
	LU_MAD_VMETHOD vm,
	DI_GEO_STATE gs,
	DI_GEO_COUNTY gc,
	DI_DB_CAT ca,
	LU_ESTRY_PRIMARY ep,
	LU_ESTRY_SECONDARY es 
WHERE 
	sd.FK_ORG = org.PK_ISN (+) AND
	FK_STATN_TYPES = st.PK_ISN (+)AND 
	FK_MAD_HDATUM = hd.PK_ISN (+) AND 
	FK_MAD_HMETHOD = hm.PK_ISN (+) AND
	sd.FK_MAD_VDATUM = vd.PK_ISN (+) AND
	sd.FK_MAD_VMETHOD = vm.PK_ISN (+) AND
	sd.FK_GEO_STATE = gs.PK_ISN (+) AND
	sd.FK_GEO_COUNTY = gc.PK_ISN(+) AND
	sd.FK_DB_CAT = ca.PK_ISN (+) AND
	sd.FK_ESTRY_PRIMARY = ep.PK_ISN (+) AND
   	sd.FK_ESTRY_SECONDARY = es.PK_ISN (+) AND
	sd.LOCATION_POINT_TYPE = '*POINT OF RECORD' AND
	sd.STATION_VISITED = 'YES';

begin

begin  
--indexes on std_latitude, std_longitude, location_point_type are already created 
--create indexes on fa_station 
execute immediate 'drop index IWS_BITMAP_FA_STATION_VISITED';
exception when others then null;
end;

begin
execute immediate 'create bitmap index IWS_BITMAP_FA_STATION_VISITED on FA_STATION (STATION_VISITED) ' ||
				  'tablespace storetindx ' ||
				  'storage (initial 2M next 2M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX SD_FN_ORG_ID ON FA_STATION (lower(trim(ORGANIZATION_ID))) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then null;
end;

begin
execute immediate 'CREATE INDEX SD_FN_STATION_ID ON FA_STATION (trim(STATION_ID)) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then null;
end;

end;
/

spool off;

