spool ws_storet_result.log


DROP TABLE WS_STORET_RESULT CASCADE CONSTRAINTS
/

--
-- WS_STORET_RESULT  (Table) 
--
CREATE TABLE WS_STORET_RESULT 
( RESULT_TYPE VARCHAR2(10 BYTE), 
PK_ISN NUMBER, 
ORGANIZATIONIDENTIFIER VARCHAR2(256 BYTE), 
ORGANIZATIONFORMALNAME VARCHAR2(256 BYTE), 
STATIONIDENTIFIER CHAR(15 CHAR), 
ACTIVITYIDENTIFIER VARCHAR2(256 CHAR), 
ACTIVITYTYPECODE VARCHAR2(256 CHAR), 
ACTIVITYCATEGORYCODE VARCHAR2(256 CHAR), 
ACTIVITYMEDIANAME VARCHAR2(20 CHAR), 
ACTIVITYSTARTDATE DATE, 
PROJECTIDENTIFIER VARCHAR2(256 CHAR), 
RESULTDETECTIONCONDITIONTEXT VARCHAR2(256 CHAR), 
FK_CHAR NUMBER(12), 
CHARACTERISTICNAME VARCHAR2(256 CHAR), 
RESULTSAMPLEFRACTIONTEXT VARCHAR2(256 CHAR), 
RESULTMEASUREVALUE NUMBER, 
RESULTMEASUREUNITCODE VARCHAR2(240 CHAR), 
RESULTSTATUSIDENTIFIER CHAR(1 CHAR), 
RESULTVALUETYPENAME VARCHAR2(256 CHAR), 
RESULTWEIGHTBASISTEXT VARCHAR2(256 CHAR), 
RESULTTIMEBASISTEXT VARCHAR2(256 CHAR), 
RESULTTEMPERATUREBASISTEXT VARCHAR2(256 CHAR), 
RESULTPARTICLESIZEBASISTEXT VARCHAR2(40 CHAR), 
PRECISIONVALUE VARCHAR2(256 CHAR), 
BIASVALUE VARCHAR2(256 CHAR), 
CONFIDENCEINTERVALVALUE VARCHAR2(256 CHAR), 
RESULTCOMMENTTEXT VARCHAR2(4000 CHAR), 
METHODIDENTIFIER VARCHAR2(256 CHAR), 
METHODIDENTIFIERCONTEXT VARCHAR2(256 CHAR), 
LABORATORYNAME VARCHAR2(60 CHAR), 
ANALYSISSTARTDATE VARCHAR2(10 BYTE), 
ANALYSISTIME VARCHAR2(8 BYTE), 
ANALYSISTIMEZONECODE VARCHAR2(256 CHAR), 
RESULTLABORATORYCOMMENTCODE VARCHAR2(256 CHAR), 
QUANTITATIONLIMITTYPENAME VARCHAR2(256 CHAR), 
MEASUREVALUE VARCHAR2(25 CHAR), 
MEASUREUNITCODE VARCHAR2(25 CHAR), 
BIOINTENTNAME VARCHAR2(20 CHAR), 
BIOINDIVIDUALIDENTIFIER NUMBER, 
SUBJECTTAXONOMICNAME VARCHAR2(69 CHAR), 
SAMPLETISSUEANATOMYNAME VARCHAR2(30 CHAR), 
CELLFORMNAME VARCHAR2(11 CHAR),
CELLSHAPENAME VARCHAR2(18 CHAR), 
HABITNAME VARCHAR2(40 CHAR), 
VOLTINISMNAME VARCHAR2(40 CHAR), 
TAXONPOLLUTIONTOLERANCE VARCHAR2(4 CHAR), 
TROPHICLEVELNAME VARCHAR2(4 CHAR), 
FUNCTIONALFEEDINGGROUPNAME VARCHAR2(6 CHAR), 
FREQCLASSDESCRIPTORCODE VARCHAR2(12 CHAR), 
FREQCLASSDESCRIPTORUNITCODE VARCHAR2(10 CHAR), 
LOWERCLASSBOUNDVALUE NUMBER, 
UPPERCLASSBOUNDVALUE NUMBER ) 
TABLESPACE STORETDATA 
STORAGE (INITIAL 100M NEXT 100M)
NOLOGGING NOCOMPRESS NOCACHE 
/


--grant select on WS_STORET_RESULT  to storetweb;

create or replace procedure sp_ws_storet_result (p_status_out out varchar2)as

cursor c_reg_res is 
select 'REGULAR' as Result_Type,
fr.pk_isn as pk_isn,
fr.ORGANIZATION_ID as OrganizationIdentifier,
do.ORGANIZATION_NAME as OrganizationFormalName,
fr.STATION_ID as StationIdentifier,
fr.ACTIVITY_ID as ActivityIdentifier,
fr.ACTIVITY_TYPE as ActivityTypeCode,
fr.ACTIVITY_MEDIUM as ActivityMediaName,
fr.ACTIVITY_START_DATE_TIME as ActivityStartDate,
dp.PROJECT_CD as ProjectIdentifier,
case when (fr.RESULT_VALUE_TEXT like '*%'
	and fr.result_unit is null
	and ((fr.result_value is null) or (fr.result_value=0))) then
fr.RESULT_VALUE_TEXT 
else null end as ResultDetectionConditionText,
fr.fk_char as fk_char,
fr.CHARACTERISTIC_NAME as CharacteristicName,
fr.SAMPLE_FRACTION_TYPE as ResultSampleFractionText,
fr.STD_VALUE as ResultMeasureValue,
fr.STD_UNIT as ResultMeasureUnitCode,
fr.RESULT_VALUE_STATUS as ResultStatusIdentifier,
fr.RESULT_VALUE_TYPE as ResultValueTypeName,
fr.WEIGHT_BASIS_TYPE as ResultWeightBasisText,
fr.DURATION_BASIS as ResultTimeBasisText,
fr.TEMPERATURE_BASIS_LEVEL as ResultTemperatureBasisText,
fr.PARTICLE_SIZE as ResultParticleSizeBasisText,
fr.PRECISION as PrecisionValue,
fr.BIAS as BiasValue,
fr.CONFIDENCE_LEVEL as ConfidenceIntervalValue,
fr.RESULT_COMMENT as ResultCommentText,
fr.ANALYTICAL_PROCEDURE_ID as MethodIdentifier,
fr.ANALYTICAL_PROCEDURE_SOURCE as MethodIdentifierContext,
fr.LAB_NAME as LaboratoryName,
to_char(fr.ANALYSIS_DATE_TIME, 'YYYY-MM-DD') as AnalysisStartDate,
to_char(fr.ANALYSIS_DATE_TIME, 'HH24:MI:SS') as AnalysisTime,
fr.ANALYSIS_TIME_ZONE as AnalysisTimeZoneCode,
trim(fr.LAB_REMARK) as ResultLaboratoryCommentCode,
fr.DETECTION_LIMIT_DESCRIPTION as QuantitationLimitTypeName,
case when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, '-')>0) then
	 substr(fr.DETECTION_LIMIT, 1, instr(fr.DETECTION_LIMIT, '-')-1)
when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, ' ')>0) then
	 substr(fr.DETECTION_LIMIT, 1, instr(fr.DETECTION_LIMIT, ' ')-1)
when length(trim(fr.DETECTION_LIMIT))=1 then null
else fr.DETECTION_LIMIT end as MeasureValue,
case when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, '-')>0) then
	 substr(fr.DETECTION_LIMIT, instr(fr.DETECTION_LIMIT, '-')+1)
when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, ' ')>0) then
	 substr(fr.DETECTION_LIMIT, instr(fr.DETECTION_LIMIT, ' ')+1)
else 'None' end as MeasureUnitCode,
null as BioIntentName,
null as BioIndividualIdentifier,
null as SubjectTaxonomicName,
null as SampleTissueAnatomyName,
null as CellFormName,
null as CellShapeName,
null as HabitName,
null as VoltinismName,
null as TaxonPollutionTolerance,
null as TrophicLevelName,
null as FunctionalFeedingGroupName,
null as FreqClassDescriptorCode,
null as FreqClassDescriptorUnitCode,
null as LowerClassBoundValue,
null as UpperClassBoundValue,
activity_category as ACTIVITYCATEGORYCODE
from FA_REGULAR_RESULT fr inner join DI_ORG do
on fr.FK_ORG = do.PK_ISN 
left outer join REGULAR_RESULT_PROJECT rrp
on fr.PK_ISN = rrp.FK_RESULT
left join DI_PROJECT dp
on rrp.FK_PROJECT = dp.PK_ISN;


cursor c_bio_res is
select 'BIOLOGICAL' as Result_Type,
fb.pk_isn as pk_isn,
fb.ORGANIZATION_ID as OrganizationIdentifier,
do.ORGANIZATION_NAME as OrganizationFormalName,
fb.STATION_ID as StationIdentifier,
fb.ACTIVITY_ID as ActivityIdentifier,
fb.ACTIVITY_TYPE as ActivityTypeCode,
fb.ACTIVITY_MEDIUM as ActivityMediaName,
fb.ACTIVITY_START_DATE_TIME as ActivityStartDate,
dp.PROJECT_CD as ProjectIdentifier,
case when (fb.RESULT_VALUE_TEXT like '*%'
	and fb.result_unit is null
	and ((fb.result_value is null) or (fb.result_value=0))) then
fb.RESULT_VALUE_TEXT 
else null end as ResultDetectionConditionText,
fb.fk_char as fk_char,
fb.CHARACTERISTIC_NAME as CharacteristicName,
fb.SAMPLE_FRACTION_TYPE as ResultSampleFractionText,
fb.STD_VALUE as ResultMeasureValue,
fb.STD_UNIT as ResultMeasureUnitCode,
fb.RESULT_VALUE_STATUS as ResultStatusIdentifier,
fb.RESULT_VALUE_TYPE as ResultValueTypeName,
fb.WEIGHT_BASIS_TYPE as ResultWeightBasisText,
fb.DURATION_BASIS as ResultTimeBasisText,
fb.TEMPERATURE_BASIS_LEVEL as ResultTemperatureBasisText,
fb.PARTICLE_SIZE as ResultParticleSizeBasisText,
fb.PRECISION as PrecisionValue,
fb.BIAS as BiasValue,
fb.CONFIDENCE_LEVEL as ConfidenceIntervalValue,
fb.RESULT_COMMENT as ResultCommentText,
fb.ANALYTICAL_PROCEDURE_ID as MethodIdentifier,
fb.ANALYTICAL_PROCEDURE_SOURCE as MethodIdentifierContext,
fb.LAB_NAME as LaboratoryName,
to_char(fb.ANALYSIS_DATE_TIME, 'YYYY-MM-DD') as AnalysisStartDate,
to_char(fb.ANALYSIS_DATE_TIME, 'HH24:MI:SS') as AnalysisTime,
fb.ANALYSIS_TIME_ZONE as AnalysisTimeZoneCode,
trim(fb.LAB_REMARK) as ResultLaboratoryCommentCode,
fb.DETECTION_LIMIT_DESCRIPTION as QuantitationLimitTypeName,
case when (length(trim(fb.DETECTION_LIMIT))>1 and instr(fb.DETECTION_LIMIT, '-')>0) then
	 substr(fb.DETECTION_LIMIT, 1, instr(fb.DETECTION_LIMIT, '-')-1)
when length(trim(fb.DETECTION_LIMIT))=1 then null
else fb.DETECTION_LIMIT end as MeasureValue,
case when (length(trim(fb.DETECTION_LIMIT))>1 and instr(fb.DETECTION_LIMIT, '-')>0) then
	 substr(fb.DETECTION_LIMIT, instr(fb.DETECTION_LIMIT, '-')+1)
else 'None' end as MeasureUnitCode,
fb.activity_intent as BioIntentName,
fb.individual_number as BioIndividualIdentifier,
fb.activity_subject_taxon as SubjectTaxonomicName,
fb.biopart_name as SampleTissueAnatomyName,
fb.cell_form as CellFormName,
fb.cell_shape as CellShapeName,
fb.habit as HabitName,
fb.voltinism as VoltinismName,
fb.pollution_tolerance as TaxonPollutionTolerance,
fb.trophic_level as TrophicLevelName,
fb.feeding_group as FunctionalFeedingGroupName,
fb.primary_class_desc as FreqClassDescriptorCode,
fb.bio_rci_units as FreqClassDescriptorUnitCode,
fb.lower_bound_amount as LowerClassBoundValue,
fb.upper_bound_amount as UpperClassBoundValue,
activity_category as ACTIVITYCATEGORYCODE
from FA_BIOLOGICAL_RESULT fb inner join DI_ORG do
on fb.FK_ORG = do.PK_ISN 
left outer join BIOLOGICAL_RESULT_PROJECT brp
on fb.PK_ISN = brp.FK_RESULT
left join DI_PROJECT dp
on brp.FK_PROJECT = dp.PK_ISN;

cursor c_hab_res is 
select 'HABITAT' as Result_Type,
fh.pk_isn as pk_isn,
fh.ORGANIZATION_ID as OrganizationIdentifier,
do.ORGANIZATION_NAME as OrganizationFormalName,
fh.STATION_ID as StationIdentifier,
fh.ACTIVITY_ID as ActivityIdentifier,
fh.ACTIVITY_TYPE as ActivityTypeCode,
null as ActivityMediaName,
fh.ACTIVITY_START_DATE_TIME as ActivityStartDate,
dp.PROJECT_CD as ProjectIdentifier,
case when (fh.RESULT_VALUE_TEXT like '*%'
	and fh.result_unit is null
	and ((fh.result_value is null) or (fh.result_value=0))) then
fh.RESULT_VALUE_TEXT 
else null end as ResultDetectionConditionText,
fh.fk_char as fk_char,
fh.CHARACTERISTIC_NAME as CharacteristicName,
fh.SAMPLE_FRACTION_TYPE as ResultSampleFractionText,
fh.STD_VALUE as ResultMeasureValue,
fh.STD_UNIT as ResultMeasureUnitCode,
fh.RESULT_VALUE_STATUS as ResultStatusIdentifier,
fh.RESULT_VALUE_TYPE as ResultValueTypeName,
fh.WEIGHT_BASIS_TYPE as ResultWeightBasisText,
fh.DURATION_BASIS as ResultTimeBasisText,
fh.TEMPERATURE_BASIS_LEVEL as ResultTemperatureBasisText,
null as ResultParticleSizeBasisText,
fh.PRECISION as PrecisionValue,
fh.BIAS as BiasValue,
fh.CONFIDENCE_LEVEL as ConfidenceIntervalValue,
fh.RESULT_COMMENT as ResultCommentText,
fh.ANALYTICAL_PROCEDURE_ID as MethodIdentifier,
fh.ANALYTICAL_PROCEDURE_SOURCE as MethodIdentifierContext,
fh.LAB_NAME as LaboratoryName,
to_char(fh.ANALYSIS_DATE_TIME, 'YYYY-MM-DD') as AnalysisStartDate,
to_char(fh.ANALYSIS_DATE_TIME, 'HH24:MI:SS') as AnalysisTime,
fh.ANALYSIS_TIME_ZONE as AnalysisTimeZoneCode,
trim(fh.LAB_REMARK) as ResultLaboratoryCommentCode,
fh.DETECTION_LIMIT_DESCRIPTION as QuantitationLimitTypeName,
case when (length(trim(fh.DETECTION_LIMIT))>1 and instr(fh.DETECTION_LIMIT, '-')>0) then
	 substr(fh.DETECTION_LIMIT, 1, instr(fh.DETECTION_LIMIT, '-')-1)
when (length(trim(fh.DETECTION_LIMIT))>1 and instr(fh.DETECTION_LIMIT, ' ')>0) then
	 substr(fh.DETECTION_LIMIT, 1, instr(fh.DETECTION_LIMIT, ' ')-1)
when length(trim(fh.DETECTION_LIMIT))=1 then null
else fh.DETECTION_LIMIT end as MeasureValue,
case when (length(trim(fh.DETECTION_LIMIT))>1 and instr(fh.DETECTION_LIMIT, '-')>0) then
	 substr(fh.DETECTION_LIMIT, instr(fh.DETECTION_LIMIT, '-')+1)
when (length(trim(fh.DETECTION_LIMIT))>1 and instr(fh.DETECTION_LIMIT, ' ')>0) then
	 substr(fh.DETECTION_LIMIT, instr(fh.DETECTION_LIMIT, ' ')+1)
else 'None' end as MeasureUnitCode,
null as BioIntentName,
null as BioIndividualIdentifier,
null as SubjectTaxonomicName,
null as SampleTissueAnatomyName,
null as CellFormName,
null as CellShapeName,
null as HabitName,
null as VoltinismName,
null as TaxonPollutionTolerance,
null as TrophicLevelName,
null as FunctionalFeedingGroupName,
null as FreqClassDescriptorCode,
null as FreqClassDescriptorUnitCode,
null as LowerClassBoundValue,
null as UpperClassBoundValue,
activity_category as ACTIVITYCATEGORYCODE
from FA_HABITAT_RESULT fh inner join DI_ORG do
on fh.FK_ORG = do.PK_ISN 
left join HABITAT_RESULT_PROJECT hrp
on fh.PK_ISN = hrp.FK_RESULT
left join DI_PROJECT dp
on hrp.FK_PROJECT = dp.PK_ISN;

lv_commit_counter number:=0;
lv_commit_interval number:=20000;

begin

p_status_out:='SUCCESS';


-- indexes on fact tables
begin
execute immediate 'create index IRR_FK_CHAR on fa_regular_result(FK_CHAR) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating irr_fk_char '|| sqlerrm);
end;

begin
execute immediate 'create index IBR_FK_CHAR on fa_biological_result(FK_CHAR) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IBR_FK_CHAR '|| sqlerrm);
end;


begin
execute immediate 'create index IHR_FK_CHAR on fa_habitat_result(FK_CHAR) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IHR_FK_CHAR '|| sqlerrm);
end;

begin
execute immediate 'create index IWS_RR_CHAR_NAME on fa_regular_result(lower(CHARACTERISTIC_NAME)) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IWS_RR_CHAR_NAME '|| sqlerrm);
end;

begin
execute immediate 'create index IWS_BR_CHAR_NAME on fa_biological_result(lower(CHARACTERISTIC_NAME)) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IWS_BR_CHAR_NAME '|| sqlerrm);
end;

begin
execute immediate 'create index IWS_RR_CHAR_NAME on fa_habitat_result(lower(CHARACTERISTIC_NAME)) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IWS_RR_CHAR_NAME '|| sqlerrm);
end;

begin
execute immediate 'create index IWS_DI_CHAR_SEARCH_NAME on di_characteristic(lower(SEARCH_NAME)) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IWS_DI_CHAR_SEARCH_NAME '|| sqlerrm);
end;

begin
execute immediate 'create index IWS_DI_CHAR_DISPALY_NAME on di_characteristic(lower(DISPLAY_NAME)) tablespace storetindx storage (INITIAL 5M NEXT 5M)';
exception when others then
dbms_output.put_line('error creating IWS_DI_CHAR_DISPALY_NAME '|| sqlerrm);
end;

-- drop indexes
--
-- IWSR_FK_ORG_ID  (Index) 
--
begin
execute immediate 'drop INDEX IWSR_FK_ORG_ID';
exception when others then
dbms_output.put_line('error dropping IWSR_FK_ORG_ID '|| sqlerrm);
end;

--
-- IWSR_FK_ACTIVITY_ID  (Index) 
--
begin
execute immediate 'drop INDEX IWSR_FK_ACTIVITY_ID';
exception when others then
dbms_output.put_line('error dropping IWSR_FK_ACTIVITY_ID '|| sqlerrm);
end;


--
-- IWSR_FK_CHAR  (Index) 
--
begin
execute immediate 'drop INDEX IWSR_FK_CHAR';
exception when others then
dbms_output.put_line('error dropping IWSR_FK_CHAR '|| sqlerrm);
end;


--
-- IWSR_CHAR_NAME  (Index) 
--
begin
execute immediate 'drop INDEX IWSR_CHAR_NAME';
exception when others then
dbms_output.put_line('error dropping IWSR_CHAR_NAME '|| sqlerrm);
end;

--
-- IWSR_CHAR_NAME  (Index) 
--
begin
execute immediate 'drop INDEX IWSR_FK_LT_ORG_ID';
exception when others then
dbms_output.put_line('error dropping IWSR_FK_LT_ORG_ID '|| sqlerrm);
end;

-- truncate table 

begin
execute immediate 'truncate table WS_STORET_RESULT';


-- populate data.

commit;
/*
--SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
BEGIN
commit;
DBMS_TRANSACTION.USE_ROLLBACK_SEGMENT('RBSBIG');
EXCEPTION WHEN OTHERS THEN 
NULL;
END;
*/
-- process regular results
for cv in c_reg_res loop
insert into WS_STORET_RESULT
(Result_Type,
pk_isn,
OrganizationIdentifier,
OrganizationFormalName,
StationIdentifier,
ActivityIdentifier,
ActivityTypeCode,
ActivityMediaName,
ActivityStartDate,
ProjectIdentifier,
ResultDetectionConditionText,
fk_char,
CharacteristicName,
ResultSampleFractionText,
ResultMeasureValue,
ResultMeasureUnitCode,
ResultStatusIdentifier,
ResultValueTypeName,
ResultWeightBasisText,
ResultTimeBasisText,
ResultTemperatureBasisText,
ResultParticleSizeBasisText,
PrecisionValue,
BiasValue,
ConfidenceIntervalValue,
ResultCommentText,
MethodIdentifier,
MethodIdentifierContext,
LaboratoryName,
AnalysisStartDate,
AnalysisTime,
AnalysisTimeZoneCode,
ResultLaboratoryCommentCode,
QuantitationLimitTypeName,
MeasureValue,
MeasureUnitCode, 
BioIntentName,
BioIndividualIdentifier,
SubjectTaxonomicName,
SampleTissueAnatomyName,
CellFormName,
CellShapeName,
HabitName,
VoltinismName,
TaxonPollutionTolerance,
TrophicLevelName,
FunctionalFeedingGroupName,
FreqClassDescriptorCode,
FreqClassDescriptorUnitCode,
LowerClassBoundValue,
UpperClassBoundValue,
ACTIVITYCATEGORYCODE)  
values(cv.Result_Type,
cv.pk_isn,
cv.OrganizationIdentifier,
cv.OrganizationFormalName,
cv.StationIdentifier,
cv.ActivityIdentifier,
cv.ActivityTypeCode,
cv.ActivityMediaName,
cv.ActivityStartDate,
cv.ProjectIdentifier,
cv.ResultDetectionConditionText,
cv.fk_char,
cv.CharacteristicName,
cv.ResultSampleFractionText,
cv.ResultMeasureValue,
cv.ResultMeasureUnitCode,
cv.ResultStatusIdentifier,
cv.ResultValueTypeName,
cv.ResultWeightBasisText,
cv.ResultTimeBasisText,
cv.ResultTemperatureBasisText,
cv.ResultParticleSizeBasisText,
cv.PrecisionValue,
cv.BiasValue,
cv.ConfidenceIntervalValue,
cv.ResultCommentText,
cv.MethodIdentifier,
cv.MethodIdentifierContext,
cv.LaboratoryName,
cv.AnalysisStartDate,
cv.AnalysisTime,
cv.AnalysisTimeZoneCode,
cv.ResultLaboratoryCommentCode,
cv.QuantitationLimitTypeName,
cv.MeasureValue,
cv.MeasureUnitCode, 
cv.BioIntentName,
cv.BioIndividualIdentifier,
cv.SubjectTaxonomicName,
cv.SampleTissueAnatomyName,
cv.CellFormName,
cv.CellShapeName,
cv.HabitName,
cv.VoltinismName,
cv.TaxonPollutionTolerance,
cv.TrophicLevelName,
cv.FunctionalFeedingGroupName,
cv.FreqClassDescriptorCode,
cv.FreqClassDescriptorUnitCode,
cv.LowerClassBoundValue,
cv.UpperClassBoundValue,
cv.ACTIVITYCATEGORYCODE);

lv_commit_counter:=lv_commit_counter+1;
if lv_commit_counter > lv_commit_interval then
commit;
lv_commit_counter:=0;
end if;
end loop;
commit;

--process biological results
lv_commit_counter:=0;
for cv in c_bio_res loop
insert into WS_STORET_RESULT
(Result_Type,
pk_isn,
OrganizationIdentifier,
OrganizationFormalName,
StationIdentifier,
ActivityIdentifier,
ActivityTypeCode,
ActivityMediaName,
ActivityStartDate,
ProjectIdentifier,
ResultDetectionConditionText,
fk_char,
CharacteristicName,
ResultSampleFractionText,
ResultMeasureValue,
ResultMeasureUnitCode,
ResultStatusIdentifier,
ResultValueTypeName,
ResultWeightBasisText,
ResultTimeBasisText,
ResultTemperatureBasisText,
ResultParticleSizeBasisText,
PrecisionValue,
BiasValue,
ConfidenceIntervalValue,
ResultCommentText,
MethodIdentifier,
MethodIdentifierContext,
LaboratoryName,
AnalysisStartDate,
AnalysisTime,
AnalysisTimeZoneCode,
ResultLaboratoryCommentCode,
QuantitationLimitTypeName,
MeasureValue,
MeasureUnitCode, 
BioIntentName,
BioIndividualIdentifier,
SubjectTaxonomicName,
SampleTissueAnatomyName,
CellFormName,
CellShapeName,
HabitName,
VoltinismName,
TaxonPollutionTolerance,
TrophicLevelName,
FunctionalFeedingGroupName,
FreqClassDescriptorCode,
FreqClassDescriptorUnitCode,
LowerClassBoundValue,
UpperClassBoundValue,
ACTIVITYCATEGORYCODE)
values(cv.Result_Type,
cv.pk_isn,
cv.OrganizationIdentifier,
cv.OrganizationFormalName,
cv.StationIdentifier,
cv.ActivityIdentifier,
cv.ActivityTypeCode,
cv.ActivityMediaName,
cv.ActivityStartDate,
cv.ProjectIdentifier,
cv.ResultDetectionConditionText,
cv.fk_char,
cv.CharacteristicName,
cv.ResultSampleFractionText,
cv.ResultMeasureValue,
cv.ResultMeasureUnitCode,
cv.ResultStatusIdentifier,
cv.ResultValueTypeName,
cv.ResultWeightBasisText,
cv.ResultTimeBasisText,
cv.ResultTemperatureBasisText,
cv.ResultParticleSizeBasisText,
cv.PrecisionValue,
cv.BiasValue,
cv.ConfidenceIntervalValue,
cv.ResultCommentText,
cv.MethodIdentifier,
cv.MethodIdentifierContext,
cv.LaboratoryName,
cv.AnalysisStartDate,
cv.AnalysisTime,
cv.AnalysisTimeZoneCode,
cv.ResultLaboratoryCommentCode,
cv.QuantitationLimitTypeName,
cv.MeasureValue,
cv.MeasureUnitCode, 
cv.BioIntentName,
cv.BioIndividualIdentifier,
cv.SubjectTaxonomicName,
cv.SampleTissueAnatomyName,
cv.CellFormName,
cv.CellShapeName,
cv.HabitName,
cv.VoltinismName,
cv.TaxonPollutionTolerance,
cv.TrophicLevelName,
cv.FunctionalFeedingGroupName,
cv.FreqClassDescriptorCode,
cv.FreqClassDescriptorUnitCode,
cv.LowerClassBoundValue,
cv.UpperClassBoundValue,
cv.ACTIVITYCATEGORYCODE);

lv_commit_counter:=lv_commit_counter+1;
if lv_commit_counter > lv_commit_interval then
commit;
lv_commit_counter:=0;
end if;
end loop;
commit;

--process habitat results

lv_commit_counter:=0;
for cv in c_hab_res loop
insert into WS_STORET_RESULT
(Result_Type,
pk_isn,
OrganizationIdentifier,
OrganizationFormalName,
StationIdentifier,
ActivityIdentifier,
ActivityTypeCode,
ActivityMediaName,
ActivityStartDate,
ProjectIdentifier,
ResultDetectionConditionText,
fk_char,
CharacteristicName,
ResultSampleFractionText,
ResultMeasureValue,
ResultMeasureUnitCode,
ResultStatusIdentifier,
ResultValueTypeName,
ResultWeightBasisText,
ResultTimeBasisText,
ResultTemperatureBasisText,
ResultParticleSizeBasisText,
PrecisionValue,
BiasValue,
ConfidenceIntervalValue,
ResultCommentText,
MethodIdentifier,
MethodIdentifierContext,
LaboratoryName,
AnalysisStartDate,
AnalysisTime,
AnalysisTimeZoneCode,
ResultLaboratoryCommentCode,
QuantitationLimitTypeName,
MeasureValue,
MeasureUnitCode, 
BioIntentName,
BioIndividualIdentifier,
SubjectTaxonomicName,
SampleTissueAnatomyName,
CellFormName,
CellShapeName,
HabitName,
VoltinismName,
TaxonPollutionTolerance,
TrophicLevelName,
FunctionalFeedingGroupName,
FreqClassDescriptorCode,
FreqClassDescriptorUnitCode,
LowerClassBoundValue,
UpperClassBoundValue,
ACTIVITYCATEGORYCODE)
values(cv.Result_Type,
cv.pk_isn,
cv.OrganizationIdentifier,
cv.OrganizationFormalName,
cv.StationIdentifier,
cv.ActivityIdentifier,
cv.ActivityTypeCode,
cv.ActivityMediaName,
cv.ActivityStartDate,
cv.ProjectIdentifier,
cv.ResultDetectionConditionText,
cv.fk_char,
cv.CharacteristicName,
cv.ResultSampleFractionText,
cv.ResultMeasureValue,
cv.ResultMeasureUnitCode,
cv.ResultStatusIdentifier,
cv.ResultValueTypeName,
cv.ResultWeightBasisText,
cv.ResultTimeBasisText,
cv.ResultTemperatureBasisText,
cv.ResultParticleSizeBasisText,
cv.PrecisionValue,
cv.BiasValue,
cv.ConfidenceIntervalValue,
cv.ResultCommentText,
cv.MethodIdentifier,
cv.MethodIdentifierContext,
cv.LaboratoryName,
cv.AnalysisStartDate,
cv.AnalysisTime,
cv.AnalysisTimeZoneCode,
cv.ResultLaboratoryCommentCode,
cv.QuantitationLimitTypeName,
cv.MeasureValue,
cv.MeasureUnitCode, 
cv.BioIntentName,
cv.BioIndividualIdentifier,
cv.SubjectTaxonomicName,
cv.SampleTissueAnatomyName,
cv.CellFormName,
cv.CellShapeName,
cv.HabitName,
cv.VoltinismName,
cv.TaxonPollutionTolerance,
cv.TrophicLevelName,
cv.FunctionalFeedingGroupName,
cv.FreqClassDescriptorCode,
cv.FreqClassDescriptorUnitCode,
cv.LowerClassBoundValue,
cv.UpperClassBoundValue,
cv.ACTIVITYCATEGORYCODE);

lv_commit_counter:=lv_commit_counter+1;
if lv_commit_counter > lv_commit_interval then
commit;
lv_commit_counter:=0;
end if;
end loop;
commit;



exception when others then
dbms_output.put_line('error truncating table WS_STORET_RESULT '|| sqlerrm);
dbms_output.put_line('NO Data is loaded into WS_STORET_RESULT');
p_status_out:='FAILED';
end;
--
-- IWSR_FK_ORG_ID  (Index) 
--
begin
execute immediate 'CREATE INDEX IWSR_FK_ORG_ID ON WS_STORET_RESULT (ORGANIZATIONIDENTIFIER) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then
dbms_output.put_line('error creating IWSR_FK_ORG_ID '|| sqlerrm);
end;

--
-- IWSR_FK_ACTIVITY_ID  (Index) 
--
begin
execute immediate 'CREATE INDEX IWSR_FK_ACTIVITY_ID ON WS_STORET_RESULT (ACTIVITYIDENTIFIER) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then
dbms_output.put_line('error creating IWSR_FK_ACTIVITY_ID '|| sqlerrm);
end;


--
-- IWSR_FK_CHAR  (Index) 
--
begin
execute immediate 'CREATE INDEX IWSR_FK_CHAR ON WS_STORET_RESULT (FK_CHAR) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then
dbms_output.put_line('error creating IWSR_FK_CHAR '|| sqlerrm);
end;


--
-- IWSR_CHAR_NAME  (Index) 
--
begin
execute immediate 'CREATE INDEX IWSR_CHAR_NAME ON WS_STORET_RESULT (LOWER("CHARACTERISTICNAME")) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then
dbms_output.put_line('error creating IWSR_CHAR_NAME '|| sqlerrm);
end;


--
-- IWSR_FK_LT_ORG_ID (Index)  
--
begin
execute immediate 'CREATE INDEX IWSR_FK_LT_ORG_ID ON WS_STORET_RESULT (lower(trim(ORGANIZATIONIDENTIFIER))) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M)';
exception when others then
dbms_output.put_line('error creating IWSR_FK_LT_ORG_ID '|| sqlerrm);
end;


begin
execute immediate 'analyze table WS_STORET_RESULT compute statistics FOR TABLE FOR ALL INDEXES';
exception when others then
dbms_output.put_line('error analyzing table ws_storet_result '|| sqlerrm);
end;


exception when others then
  dbms_output.put_line(sqlerrm);
p_status_out:='FAILED';
end;
/
show errors;

set serveroutput on
declare
LV_STATUS_OUT VARCHAR2(10);
BEGIN
 sp_ws_storet_result(LV_STATUS_OUT);
DBMS_OUTPUT.PUT_LINE('WS_STORET_RESULT table refresh status: '||lv_status_out);
end;
/

spool off;

