spool ws_storet_result_view.log

rename ws_storet_result to ws_storet_result_table;

drop table ws_storet_result;

drop view ws_storet_result;

CREATE OR REPLACE VIEW WS_STORET_RESULT
(RESULT_TYPE, PK_ISN, ORGANIZATIONIDENTIFIER, STATIONIDENTIFIER, ACTIVITYIDENTIFIER, 
 ACTIVITYTYPECODE, ACTIVITYMEDIANAME, ACTIVITYSTARTDATE, RESULTDETECTIONCONDITIONTEXT, FK_CHAR, 
 CHARACTERISTICNAME, RESULTSAMPLEFRACTIONTEXT, RESULTMEASUREVALUE, RESULTMEASUREUNITCODE, RESULTSTATUSIDENTIFIER, 
 RESULTVALUETYPENAME, RESULTWEIGHTBASISTEXT, RESULTTIMEBASISTEXT, RESULTTEMPERATUREBASISTEXT, RESULTPARTICLESIZEBASISTEXT, 
 PRECISIONVALUE, BIASVALUE, CONFIDENCEINTERVALVALUE, RESULTCOMMENTTEXT, METHODIDENTIFIER, 
 METHODIDENTIFIERCONTEXT, LABORATORYNAME, ANALYSISSTARTDATE, ANALYSISTIME, ANALYSISTIMEZONECODE, 
 RESULTLABORATORYCOMMENTCODE, QUANTITATIONLIMITTYPENAME, MEASUREVALUE, MEASUREUNITCODE, BIOINTENTNAME, 
 BIOINDIVIDUALIDENTIFIER, SUBJECTTAXONOMICNAME, SAMPLETISSUEANATOMYNAME, CELLFORMNAME, CELLSHAPENAME, 
 HABITNAME, VOLTINISMNAME, TAXONPOLLUTIONTOLERANCE, TROPHICLEVELNAME, FUNCTIONALFEEDINGGROUPNAME, 
 FREQCLASSDESCRIPTORCODE, FREQCLASSDESCRIPTORUNITCODE, LOWERCLASSBOUNDVALUE, UPPERCLASSBOUNDVALUE, ACTIVITYCATEGORYCODE)
AS 
select 'REGULAR' as Result_Type,
fr.pk_isn as pk_isn,
fr.ORGANIZATION_ID as OrganizationIdentifier,
fr.STATION_ID as StationIdentifier,
fr.ACTIVITY_ID as ActivityIdentifier,
fr.ACTIVITY_TYPE as ActivityTypeCode,
fr.ACTIVITY_MEDIUM as ActivityMediaName,
fr.ACTIVITY_START_DATE_TIME as ActivityStartDate,
--dp.PROJECT_CD as ProjectIdentifier,
case when (fr.RESULT_VALUE_TEXT like '*%'
 and fr.result_unit is null
 and ((fr.result_value is null) or (fr.result_value=0))) then
fr.RESULT_VALUE_TEXT 
else null end as ResultDetectionConditionText,
fr.fk_char as fk_char,
fr.CHARACTERISTIC_NAME as CharacteristicName,
fr.SAMPLE_FRACTION_TYPE as ResultSampleFractionText,
fr.STD_VALUE as ResultMeasureValue,
fr.STD_UNIT as ResultMeasureUnitCode,
fr.RESULT_VALUE_STATUS as ResultStatusIdentifier,
fr.RESULT_VALUE_TYPE as ResultValueTypeName,
fr.WEIGHT_BASIS_TYPE as ResultWeightBasisText,
fr.DURATION_BASIS as ResultTimeBasisText,
fr.TEMPERATURE_BASIS_LEVEL as ResultTemperatureBasisText,
fr.PARTICLE_SIZE as ResultParticleSizeBasisText,
fr.PRECISION as PrecisionValue,
fr.BIAS as BiasValue,
fr.CONFIDENCE_LEVEL as ConfidenceIntervalValue,
fr.RESULT_COMMENT as ResultCommentText,
fr.ANALYTICAL_PROCEDURE_ID as MethodIdentifier,
fr.ANALYTICAL_PROCEDURE_SOURCE as MethodIdentifierContext,
fr.LAB_NAME as LaboratoryName,
to_char(fr.ANALYSIS_DATE_TIME, 'YYYY-MM-DD') as AnalysisStartDate,
to_char(fr.ANALYSIS_DATE_TIME, 'HH24:MI:SS') as AnalysisTime,
fr.ANALYSIS_TIME_ZONE as AnalysisTimeZoneCode,
trim(fr.LAB_REMARK) as ResultLaboratoryCommentCode,
fr.DETECTION_LIMIT_DESCRIPTION as QuantitationLimitTypeName,
case when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, '-')>0) then
  substr(fr.DETECTION_LIMIT, 1, instr(fr.DETECTION_LIMIT, '-')-1)
when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, ' ')>0) then
  substr(fr.DETECTION_LIMIT, 1, instr(fr.DETECTION_LIMIT, ' ')-1)
when length(trim(fr.DETECTION_LIMIT))=1 then null
else fr.DETECTION_LIMIT end as MeasureValue,
case when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, '-')>0) then
  substr(fr.DETECTION_LIMIT, instr(fr.DETECTION_LIMIT, '-')+1)
when (length(trim(fr.DETECTION_LIMIT))>1 and instr(fr.DETECTION_LIMIT, ' ')>0) then
  substr(fr.DETECTION_LIMIT, instr(fr.DETECTION_LIMIT, ' ')+1)
else 'None' end as MeasureUnitCode,
null as BioIntentName,
null as BioIndividualIdentifier,
null as SubjectTaxonomicName,
null as SampleTissueAnatomyName,
null as CellFormName,
null as CellShapeName,
null as HabitName,
null as VoltinismName,
null as TaxonPollutionTolerance,
null as TrophicLevelName,
null as FunctionalFeedingGroupName,
null as FreqClassDescriptorCode,
null as FreqClassDescriptorUnitCode,
null as LowerClassBoundValue,
null as UpperClassBoundValue,
activity_category as ACTIVITYCATEGORYCODE
from FA_REGULAR_RESULT fr;

--
-- IFAR_ACTIVITY_ID  (Index) 
--
CREATE INDEX IFAR_ACTIVITY_ID ON FA_REGULAR_RESULT (ACTIVITY_ID) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M);

--
-- IFAR_LT_ORG_ID (Index)  
--
CREATE INDEX IFAR_LT_ORG_ID ON FA_REGULAR_RESULT (lower(trim(ORGANIZATION_ID))) 
NOLOGGING TABLESPACE STORETINDX STORAGE (INITIAL 10M NEXT 10M);

grant select on ws_storet_result to storetweb;
spool off;
