CREATE OR REPLACE PROCEDURE Sp_Create_Index_on_fa_stn_Geom AS

lv_message_success VARCHAR2(4000):= 'SUCCESSFULLY CREATED INDEX ON FA_STATION GEOM COLUMN';
lv_message_failure VARCHAR2(4000):= 'CREATED INDEX ON FA_STATION GEOM COLUMN FAILED';
lv_from_email_address VARCHAR2(100):='storet@epa.gov';
lv_to_email_address VARCHAR2(100):='storet@epa.gov';

lv_update_stmt_status VARCHAR2(4000):= 'NONE';
BEGIN


	BEGIN
	    SELECT PARAMETER_VALUE into lv_to_email_address 
	    FROM MT_WH_CONFIG
	    WHERE TRIM(PARAMETER_NAME) LIKE '%GV_STORET_EMAIL%';
 	EXCEPTION
            WHEN OTHERS THEN NULL;
        END;

	lv_to_email_address:=lv_from_email_address;

	BEGIN
		UPDATE FA_STATION
		SET LATITUDE=0
		WHERE ( LATITUDE IS NULL );
		 EXCEPTION
			 WHEN OTHERS THEN 
 			 lv_update_stmt_status:= 'UPDATE FA_STATION.LATITUDE COLUMN : ' || SQLERRM;
	END;


	BEGIN
		UPDATE FA_STATION
		SET LONGITUDE=0
		WHERE ( LONGITUDE IS NULL );
		 EXCEPTION
			 WHEN OTHERS THEN 
			 lv_update_stmt_status:= 'UPDATE FA_STATION.LOGITUDE COLUMN : ' || SQLERRM;

	END;


	BEGIN
		EXECUTE IMMEDIATE 'UPDATE FA_STATION	SET geom = mdsys.sdo_geometry (2001,NULL,mdsys.sdo_point_type(LONGITUDE,LATITUDE,NULL),NULL,NULL)';
		 EXCEPTION
			 WHEN OTHERS THEN 
			 lv_update_stmt_status:= 'UPDATE GEOM COLUMN : ' || SQLERRM;
	END;


	EXECUTE IMMEDIATE 'CREATE INDEX FA_STN_LOC_IX ON fa_station (GEOM) INDEXTYPE IS MDSYS.SPATIAL_INDEX	PARAMETERS (''TABLESPACE=storetindx LAYER_GTYPE=POINT'') ';

	Dw_Mail_Pkg.send (p_sender_email =>Dw_Glob_Var.gv_storet_email, 
	p_from => lv_from_email_address, p_to =>Dw_Mail_Pkg.ARRAY(lv_to_email_address), 
	p_subject => lv_message_success, p_body =>lv_message_success || CHR(10) || 'ADDITION INFORMATION:' || CHR(10) || lv_update_stmt_status); 


EXCEPTION

	WHEN OTHERS THEN
		ROLLBACK;
		Dw_Mail_Pkg.send (p_sender_email =>Dw_Glob_Var.gv_storet_email, 
		p_from => lv_from_email_address, p_to =>Dw_Mail_Pkg.ARRAY(lv_to_email_address), 
		p_subject => lv_message_failure, p_body =>lv_message_failure || CHR(10) || ' SQL ERROR : ' || SQLERRM );

END;
/

