CREATE OR REPLACE PROCEDURE Sp_Drop_Geom_Domain_Index AS

lv_message_success VARCHAR2(4000):= 'SUCCESSFULLY DROPPED INDEX ON FA_STATION GEOM COLUMN';
lv_message_failure VARCHAR2(4000):= 'DROP INDEX ON FA_STATION GEOM COLUMN FAILED';
lv_from_email_address VARCHAR2(100):='srinivasu.uppuluri@lmco.com';
lv_to_email_address VARCHAR2(100):='srinivasu.uppuluri@lmco.com';

BEGIN
	BEGIN
	    SELECT PARAMETER_VALUE INTO lv_to_email_address 
	    FROM MT_WH_CONFIG
	    WHERE TRIM(PARAMETER_NAME) LIKE '%GV_STORET_EMAIL%';
 	EXCEPTION
            WHEN OTHERS THEN NULL;
        END;

	EXECUTE IMMEDIATE 'DROP INDEX FA_STN_LOC_IX FORCE';

	Dw_Mail_Pkg.send (p_sender_email =>Dw_Glob_Var.gv_storet_email, 
	p_from => lv_from_email_address, p_to =>Dw_Mail_Pkg.ARRAY(lv_to_email_address), 
	p_subject => lv_message_success, p_body =>lv_message_success); 


EXCEPTION

	WHEN OTHERS THEN
		ROLLBACK;
		Dw_Mail_Pkg.send (p_sender_email =>Dw_Glob_Var.gv_storet_email, 
		p_from => lv_from_email_address, p_to =>Dw_Mail_Pkg.ARRAY(lv_to_email_address), 
		p_subject => lv_message_failure, p_body =>lv_message_failure);

END;
/

