spool sp_pre_post_wqx_etl.log

-- pre WQX ETL 
CREATE OR REPLACE PROCEDURE Sp_Pre_Processing_For_Wqx_Etl(in_DUMMY_VAL IN NUMBER, out_PROC_STATUS OUT NUMBER)
AS
BEGIN
 out_PROC_STATUS:=0;

 -- Call Proc for Dropping FA_STATION GEOM Domain Index.
    BEGIN
       Sp_Drop_Geom_Domain_Index;
    EXCEPTION 
       WHEN OTHERS THEN NULL;
    END;

EXCEPTION
WHEN OTHERS THEN
  out_PROC_STATUS:=9999;
  NULL;
END;
/

grant execute on Sp_Pre_Processing_For_Wqx_Etl to storetw_etl_role;
grant execute on Sp_Pre_Processing_For_Wqx_Etl to storetw_etl;


-- Post ETL
create or replace PROCEDURE Sp_Post_Processing_For_Wqx_Etl(in_DUMMY_VAL IN NUMBER, out_PROC_STATUS OUT NUMBER)
AS
 jn binary_integer;
BEGIN

 -- Call Proc for CREATING FA_STATION GEOM Domain Index.
    BEGIN

	Sp_Create_Index_On_Fa_Stn_Geom;
    EXCEPTION 
       WHEN OTHERS THEN NULL;
    END;

  begin
   execute immediate 'alter procedure STORETW.SP_RUN_WATERSHED_TAB_REFRESH compile';
  exception when others then
  dbms_output.put_line('compile sp_run_watershed_tab_refrsh '||sqlerrm);
  null;
  end;

  begin
  sys.dbms_job.SUBMIT(jn,'storetw.sp_run_watershed_tab_refresh;');
  dbms_output.put_line('job id = '||to_char(jn));
  commit;
  exception when others then
  dbms_output.put_line('failure kicking off watershed refresh procedure in post_processing_for_wqx_etl '||sqlerrm);
  null;
  end;

out_PROC_STATUS:=0;

EXCEPTION
WHEN OTHERS THEN
dbms_output.put_line('failure running post_processing_for_wqx_etl '||sqlerrm);
out_proc_status:=1;
NULL;
END;
/

grant execute on Sp_Post_Processing_For_Wqx_Etl to storetw_etl_role;
grant execute on Sp_Post_Processing_For_Wqx_Etl to storetw_etl;


spool off;