
spool sp_sequence_synch.log
select name from v$database;

DROP TABLE STORETW.SEQ_GEN CASCADE CONSTRAINTS
/

--
-- SEQ_GEN  (Table) 
--
CREATE TABLE STORETW.SEQ_GEN 
( SEQUENCE_NAME VARCHAR2(128 BYTE), 
TABLE_NAME VARCHAR2(50 CHAR), 
MAX_NUMBER NUMBER, 
SEQ_CR_STMT VARCHAR2(2000 CHAR), 
SEQ_GEN_FLAG CHAR(1 CHAR), 
COLUMN_NAME VARCHAR2(100 CHAR), 
SEQ_CUR_VALUE NUMBER, 
SEQ_NEW_VALUE NUMBER ) 
TABLESPACE STORETDATA
/

--inserting data
INSERT INTO storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_ACTIVITY_INTENT', 'DI_ACTIVITY_INTENT', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_ACTIVITY_MATRIX', 'DI_ACTIVITY_MATRIX', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_BIOPART', 'DI_BIOPART', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_COMMUNITY_SAMPLED', 'DI_COMMUNITY_SAMPLED', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_DB_CAT', 'DI_DB_CAT', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_DI_DATE', 'DI_DATE', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_DI_PROJECT', 'DI_PROJECT', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_DW_DATA_REQUEST_ID', 'DW_DATA_REQUESTS', NULL, NULL, 'Y', 'REQUEST_ID', NULL
, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_ESTRY_PRIMARY', 'LU_ESTRY_PRIMARY', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_ESTRY_SECONDARY', 'LU_ESTRY_SECONDARY', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_FA_BIOLOGICAL_RESULT', 'FA_BIOLOGICAL_RESULT', NULL, NULL, 'Y', 'PK_ISN', NULL
, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_FA_HABITAT_RESULT', 'FA_HABITAT_RESULT', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_FA_REGULAR_RESULT', 'FA_REGULAR_RESULT', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_FA_STATION', 'FA_STATION', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_GEO_COUNTY', 'DI_GEO_COUNTY', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_GEO_STATE', 'DI_GEO_STATE', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_GROUP_TYPE', 'DI_GROUP_TYPE', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_LU_CHAR_ALIAS_TYPE', 'LU_CHAR_ALIAS_TYPE', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_LU_EXTERNAL_REF_SCHEME', 'LU_EXTERNAL_REF_SCHEME', NULL, NULL, 'Y', 'PK_ISN'
, NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_LU_STATION_ALIAS', 'LU_STATION_ALIAS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MAD_HDATUM', 'LU_MAD_HDATUM', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MAD_HMETHOD', 'LU_MAD_HMETHOD', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MAD_VDATUM', 'LU_MAD_VDATUM', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MAD_VMETHOD', 'LU_MAD_VMETHOD', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_ANALYTICAL_PROC', 'MD_ANALYTICAL_PROC', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_CITATION', 'MD_CITATION', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_COOP', 'MD_COOP', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_COOP_ADDRESS', 'MD_COOP_ADDRESS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_COOP_EADDRESS', 'MD_COOP_EADDRESS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_LAB', 'MD_LAB', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_LAB_ADDR', 'MD_LAB_ADDRESS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_LAB_EADDR', 'MD_LAB_EADDRESS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_LAB_SPP', 'MD_LAB_SAMPLE_PREP_PROCEDURE', NULL, NULL, 'Y', 'PK_ISN', NULL
, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_ORG_ADDRESS', 'MD_ORG_ADDRESS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_ORG_EADDRESS', 'MD_ORG_EADDRESS', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_PROGRAM', 'MD_PROGRAM', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_SAMPLE_GEAR', 'MD_SAMPLE_GEAR', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_SAMPLE_PRESRV', 'MD_SAMPLE_PRESRV', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_MD_SAMPLE_PROC', 'MD_SAMPLE_PROC', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_ORG', 'DI_ORG', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_STATN_TYPES', 'DI_STATN_TYPES', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
INSERT INTO  storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_SUBJECT_TAXON', 'DI_SUBJECT_TAXON', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
commit;


INSERT INTO storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_ACTIVITY_MEDIUM', 'DI_ACTIVITY_MEDIUM', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL);


INSERT INTO storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_LU_UNIT_CONVERSION', 'LU_UNIT_CONVERSION', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 

INSERT INTO storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_DI_CHARACTERISTIC', 'DI_CHARACTERISTIC', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 

--SEQ_FA_BLOB

INSERT INTO storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_FA_BLOB', 'FA_BLOB', NULL, NULL, 'Y', 'TSMBLOB_IS_NUMBER', NULL, NULL); 


/*--SEQ_WS_WEB_METHOD_INPUT_PARAM
INSERT INTO storetw.SEQ_GEN ( SEQUENCE_NAME, TABLE_NAME, MAX_NUMBER, SEQ_CR_STMT, SEQ_GEN_FLAG, COLUMN_NAME,
SEQ_CUR_VALUE, SEQ_NEW_VALUE ) VALUES ( 
'SEQ_WS_WEB_METHOD_INPUT_PARAM', 'WS_WEB_METHOD_INPUT_PARAM', NULL, NULL, 'Y', 'PK_ISN', NULL, NULL); 
*/

COMMIT;
 

 
-- check and syncronize the sequences
set serveroutput on;
CREATE OR REPLACE procedure sp_sequence_synch as

LV_SQL_STMT VARCHAR2(1000);

CURSOR C1 IS SELECT * FROM storetw.SEQ_GEN
WHERE SEQ_GEN_FLAG='Y';

lv_count number;
LV_SEQ_VALUE NUMBER;
LV_COUNT_NEW NUMBER;
LV_SEQ_EXIST NUMBER;

BEGIN

lv_count:= null;
lv_sql_stmt:=null;
LV_SEQ_VALUE :=NULL;

FOR C1_VAR IN C1 LOOP


lv_count:= null;
lv_seq_value:= null;

LV_SQL_STMT:= 'SELECT MAX('||C1_VAR.column_name||') FROM storetw.'||C1_VAR.TABLE_NAME;


EXECUTE IMMEDIATE LV_SQL_STMT into lv_count;

if lv_count is null then
lv_count:=0;
end if;


--DBMS_OUTPUT.PUT_LINE (C1_VAR.TABLE_NAME||' '||TO_CHAR(LV_COUNT));

UPDATE storetw.SEQ_GEN
SET MAX_NUMBER=LV_COUNT
WHERE TABLE_NAME=C1_VAR.TABLE_NAME
AND SEQUENCE_NAME=C1_VAR.SEQUENCE_NAME;

LV_SEQ_EXIST:= 0;

select count(*) INTO LV_SEQ_EXIST from user_objects
where object_type='SEQUENCE'
AND OBJECT_NAME=UPPER(C1_VAR.SEQUENCE_NAME);

IF LV_SEQ_EXIST = 0 THEN
    lv_seq_value:= -1;
ELSIF LV_SEQ_EXIST >= 1 THEN
 BEGIN
    EXECUTE IMMEDIATE 'SELECT storetw.'||C1_VAR.SEQUENCE_NAME||'.NEXTVAL FROM DUAL' INTO LV_SEQ_VALUE;
 exception when others then
  lv_seq_value:=-1;
 end;
END IF;

UPDATE storetw.SEQ_GEN
SET SEQ_CUR_VALUE = LV_SEQ_VALUE
WHERE TABLE_NAME=C1_VAR.TABLE_NAME
AND SEQUENCE_NAME=C1_VAR.SEQUENCE_NAME;

COMMIT;

IF LV_SEQ_VALUE <  LV_COUNT THEN
LV_COUNT_NEW:=LV_COUNT+1;
begin
  EXECUTE IMMEDIATE 'DROP SEQUENCE STORETW.'||C1_VAR.SEQUENCE_NAME;
  NULL;
exception when others then
 dbms_output.put_line('error droping sequence '||c1_var.sequence_name);
end;

BEGIN
EXECUTE IMMEDIATE 'CREATE SEQUENCE STORETW.'||C1_VAR.SEQUENCE_NAME||' START WITH '||LV_COUNT_NEW;
exception when others then
 dbms_output.put_line('error CREATING sequence '||c1_var.sequence_name||' create MANUALLY');
end;

DBMS_OUTPUT.PUT_LINE(C1_VAR.SEQUENCE_NAME||' OUT OF SYNC');

END IF;

begin
EXECUTE IMMEDIATE 'SELECT STORETW.'||C1_VAR.SEQUENCE_NAME||'.NEXTVAL FROM DUAL' INTO LV_SEQ_VALUE;
EXECUTE IMMEDIATE 'SELECT STORETW.'||C1_VAR.SEQUENCE_NAME||'.NEXTVAL FROM DUAL' INTO LV_SEQ_VALUE;
exception when others then
null;
end;


UPDATE STORETW.SEQ_GEN
SET SEQ_NEW_VALUE = LV_SEQ_VALUE
WHERE TABLE_NAME=C1_VAR.TABLE_NAME
AND SEQUENCE_NAME=C1_VAR.SEQUENCE_NAME;


END LOOP;
COMMIT;


END;
/
SHOW ERRORS

select sysdate from dual;

set serveroutput on size 10000;

exec storetw.sp_sequence_synch;

spool off;
