-- file: wh_new_obj.sql
-- 02/19/2007 --EDITED SP_compute_std_lat_long -gt
spool wh_new_obj.log
set echo on
--sequences
--procedures
--functions
-- tables

--ADDED for WQX final version

create sequence seq_fa_blob
start with 1000000;

create sequence seq_di_characteristic
start with 1000010;

-- added new for version 2
-- create seq_activity_medium
DECLARE
l_max_act_medium_pkisn number;
BEGIN
select max(pk_isn)+1 into l_max_act_medium_pkisn from di_activity_medium;
  begin
  execute immediate 'drop sequence seq_activity_medium';
  exception when others then
    null;
  end;
EXECUTE IMMEDIATE 'create sequence SEQ_ACTIVITY_MEDIUM
start with '||l_max_act_medium_pkisn ||' increment by 1 nomaxvalue nocycle cache 10';
end;
/
show errors;


create sequence SEQ_lu_unit_conversion
start with 1000000;


--Procedures

-- activityproject procedure

CREATE OR REPLACE PROCEDURE Insertintoactivityproject (
in_Table_Name   IN VARCHAR2,
in_Activity_UID IN NUMBER,
in_Project_UID  IN NUMBER,
in_Org_UID      IN NUMBER,
out_PROC_RESULT OUT NUMBER ) -- 0 : Means Unprocessed, 1: Means Success, 9999 : Error

AS

prj_pk_isn	   NUMBER;
rslt_pk_isn    NUMBER;
row_counter NUMBER := 0;

CURSOR regular_results_cursor IS
SELECT RSLT.PK_ISN
FROM FA_REGULAR_RESULT  rslt
WHERE rslt.SOURCE_SYSTEM = 'WQX' AND
rslt.SOURCE_UID = in_Activity_UID;


CURSOR biological_results_cursor IS
SELECT RSLT.PK_ISN
FROM FA_BIOLOGICAL_RESULT  rslt
WHERE rslt.SOURCE_SYSTEM = 'WQX' AND
rslt.SOURCE_UID = in_Activity_UID;

BEGIN
   	 out_PROC_RESULT := 0;

	SELECT PRJ.PK_ISN INTO prj_pk_isn
	FROM DI_PROJECT PRJ
	WHERE PRJ.SOURCE_SYSTEM = 'WQX' AND
	PRJ.SOURCE_UID = in_Project_UID  ;

	 IF UPPER(TRIM(in_Table_Name)) = 'REGULAR_RESULT_PROJECT' THEN
		
		
--	    FETCH retrieve_results_cursor INTO rslt_pk_isn;
--	    WHILE retrieve_results_cursor%ISOPEN AND retrieve_results_cursor%FOUND LOOP
		FOR results_rec IN regular_results_cursor LOOP 
		    BEGIN
		    INSERT INTO REGULAR_RESULT_PROJECT(FK_RESULT, FK_PROJECT) VALUES (results_rec.pk_isn ,prj_pk_isn) ;
			
			row_counter := row_counter + 1;
			IF row_counter = 5000 THEN
			    COMMIT;
				row_counter := 0;
			END IF;
		EXCEPTION
		WHEN OTHERS THEN
		  DBMS_OUTPUT.PUT_LINE ( 'Error Inserting into Activity Project:' || SQLERRM );
		  out_PROC_RESULT := 9999;

	    END;

		END LOOP;
     ELSE

		FOR results_rec IN biological_results_cursor LOOP 
		    BEGIN

		    INSERT INTO BIOLOGICAL_RESULT_PROJECT(FK_RESULT, FK_PROJECT) VALUES (results_rec.pk_isn ,prj_pk_isn) ;
			
			IF row_counter = 5000 THEN
			    COMMIT;
				row_counter := 0;
			END IF;

			EXCEPTION
			WHEN OTHERS THEN
			  DBMS_OUTPUT.PUT_LINE ( 'Error Inserting into Activity Project:' || SQLERRM );
			  out_PROC_RESULT := 9999;
		    END;

		END LOOP;
	END IF;

   COMMIT;
   IF out_PROC_RESULT != 9999 THEN
      out_PROC_RESULT := 1;
	  RETURN;
   END IF;

	EXCEPTION
	WHEN OTHERS THEN
	  DBMS_OUTPUT.PUT_LINE ( 'Activity Project Procedure Other Error:' || SQLERRM );
	  out_PROC_RESULT := 8888;

END;
/
show errors

-- sequence generator
create or replace PROCEDURE My_Seq_Generator (
in_seq_name IN VARCHAR2 ,
out_nextval OUT NUMBER )

IS

select_string VARCHAR2(100);
TYPE refcur  IS REF CURSOR;
Cursor_seq refcur;

BEGIN

select_string := 'select '||in_seq_name||'.NEXTVAL from dual';
OPEN Cursor_seq FOR TO_CHAR(select_string);
FETCH Cursor_seq INTO out_nextval;

END;
/
show errors;

-- Station type sort order
CREATE OR REPLACE PROCEDURE Getstatntypesortordervalue(
in_PK_ISN           IN NUMBER,
in_Primary_Type   IN VARCHAR2,
out_sort_order      OUT NUMBER )
AS
BEGIN
-- IF PRIMARY_TYPE exists then retrieve the Sort_Order value corresponding to this
-- Primary_type and use the same value
-- IF PRIMARY_TYPE does not exist, i.e = NULL then generate a new Sort_Order value.
--IF ( in_Primary_Type IS NULL ) THEN
IF ( in_PK_ISN IS NULL ) THEN
  BEGIN
  SELECT MAX(SORT_ORDER) + 1 INTO out_sort_order
  FROM DI_STATN_TYPES;
--  WHERE UPPER(TRIM(PRIMARY_TYPE)) = UPPER(TRIM(in_Primary_Type))
--  AND ROWNUM < 2;
  EXCEPTION WHEN NO_DATA_FOUND THEN
    out_sort_order:=99999;
  END;
END IF;

EXCEPTION
 WHEN OTHERS THEN
  DBMS_OUTPUT.PUT_LINE('Error in Retrieving the SORT ORDER');
    out_sort_order := 99;
END;
/
show errors;

-- delete from storetw
create or replace PROCEDURE Deletefromstoretw
(
in_TargetTableName IN VARCHAR,
in_TargetColName IN VARCHAR,
in_TargetColType IN VARCHAR,
in_SourceSystem IN VARCHAR,
in_UID	   IN NUMBER,
out_return_val OUT VARCHAR
)
AS

delete_stmt	  VARCHAR(4000);


BEGIN

	IF UPPER(in_TargetColType) = 'VARCHAR' THEN
	   delete_stmt := 'Delete from ' || in_TargetTableName ||
	                  ' Where ' || 'UPPER(TRIM(SOURCE_SYSTEM)) = ''' || UPPER(TRIM(in_SourceSystem )) || ''' AND ' ||
					  in_TargetColName || ' LIKE ' || '''' || in_UID || '''';
	ELSIF UPPER(in_TargetColType) = 'NUMBER' THEN
	   delete_stmt := 'Delete from ' || in_TargetTableName ||
	                  ' Where ' || 'UPPER(TRIM(SOURCE_SYSTEM)) = ''' || UPPER(TRIM(in_SourceSystem )) || ''' AND ' ||
					  in_TargetColName || ' = ' || in_UID;
					 
	END IF;

    DBMS_OUTPUT.PUT_LINE(delete_stmt);
	   
	EXECUTE IMMEDIATE delete_stmt;

	out_return_val:='SUCCESS';

	COMMIT;
EXCEPTION
    WHEN OTHERS THEN
	BEGIN
       DBMS_OUTPUT.PUT_LINE(SQLERRM);
       out_return_val:='FAILURE';
	END;
	   
END;
/
show errors;

--02/19/2007 
-- standard lat /long calculation
create or replace PROCEDURE SP_COMPUTE_STD_LAT_LONG
  (in_latitude 			IN  NUMBER,
   in_longitude 		IN  NUMBER,
   in_hdatum_code		IN  varchar2,
   in_country_code	        IN varchar2,
   in_state_code                IN VARCHAR2,
   out_std_latitude 		OUT NUMBER,
   out_std_longitude 		OUT NUMBER,
   out_std_hdatum_code 		OUT varchar2,
   out_sp_status 		OUT VARCHAR2)
IS

-- geometry objects ORACLE SPATIAL
  geom1 mdsys.sdo_geometry;
  geom2 mdsys.sdo_geometry;

  lv_nad83 		number;
  lv_state_postal_code 	char(2);
  lv_country_code 	char(2);
  lv_cntr 		number:=0;
  lv_convert 		number(1) := 0;
  lv_srid 		number(6,0);

  -- new local variables
  l_id_code			varchar2(12);  --lu_mad_hdatum.id_code%type;

  -- Oracle srid for datum that need to be converted.
  --WGS72    		8306
  --WGS84    		8307
  --NAD27    		8260
  --NAD27 US - Alaska  	8254
  --NAD27 cANADA  	8256
  --NAD27 MEXICO  	8263
  --Puerto Rico ???

  --SRID codes for different datums.  copied from etl_glob_var package.
  srid_WGS72 constant number(6,0):=8306 ;
  srid_WGS84 constant  number(6,0):=8307;
  srid_NAD27_Alaska  constant number(6,0):=8254;
  srid_NAD27_CANADA  constant number(6,0):=8256;
  srid_NAD27_MEXICO  constant number(6,0):=8263;
  srid_NAD27  constant number(6,0):=8260;
  srid_NAD83  constant number(6,0):=8265;


BEGIN

--changed 02/19/2007
  lv_state_postal_code 	:=substr(upper(trim(in_state_code)),1,2);
  lv_country_code 	:=substr(upper(trim(in_country_code)),1,2);

    -- fk of nad83
    select pk_isn into lv_nad83 from lu_mad_hdatum where id_code='NAD83';

--changed 02/19/2007
     l_id_code:=substr(upper(trim(in_hdatum_code)),1,12);

      -- initialize variables
      lv_convert:=0;
      lv_srid:=null;

      -- Determine if conversion is needed. If so, identify the source SRID.

     if in_latitude is null then
       lv_convert:= -1;
     elsif l_id_code  = 'WGS72' then
       lv_srid := srid_wgs72;
       lv_convert := 1;
      elsif l_id_code  = 'WGS84' then
       lv_srid := srid_wgs84;
       lv_convert := 1;
      elsif l_id_code  = 'NAD27' then

        if lv_country_code='CN' then
          lv_srid :=srid_NAD27_CANADA;
          lv_convert := 1;
        elsif lv_country_code='MX' then
          lv_srid:=srid_NAD27_MEXICO;
          lv_convert := 1;
        elsif lv_country_code='US' and lv_state_postal_code='AK' then
          lv_srid := srid_NAD27_Alaska;
          lv_convert := 1;
        elsif lv_country_code= 'US' then
          -- If not Alaska then it is considered continental US.
          lv_srid:=srid_NAD27;
          lv_convert := 1;
        else
          lv_convert := 0;
        end if;
      else
       lv_convert:=0;
      end if;


      if lv_convert = 1 then
       -- initialize/reset variables.
       geom1	:=	null;
       geom2	:=	null;

       --out_std_hdatum_code := lv_nad83;
       out_std_hdatum_code := 'NAD83';

       geom1:= mdsys.sdo_geometry(2001,lv_srid,
                mdsys.sdo_point_type(in_longitude,in_latitude,null),null,null);
       geom2:=mdsys.sdo_cs.transform(geom1, to_srid=>srid_NAD83); --convert to nad 83
       --pull the x/y back out

         -- return values

       out_std_longitude	:= geom2.sdo_point.x;
       out_std_latitude		:= geom2.sdo_point.y;
       out_sp_status 		:= 'SUCCESS' ;


      elsif lv_convert = 0 then

       out_std_longitude	:= in_longitude;
       out_std_latitude		:= in_latitude;
       out_std_hdatum_code  := in_hdatum_code;
       out_sp_status 		:= 'SUCCESS' ;

      elsif lv_convert = -1 then
        null;
       out_sp_status 		:= 'FAILURE' ;
      end if;


 EXCEPTION
     WHEN NO_DATA_FOUND THEN
       NULL;
       out_sp_status := 'FAILURE' ;
     WHEN OTHERS THEN
       -- Consider logging the error and then re-raise
       out_sp_status := 'FAILURE' ;
       RAISE;
END SP_COMPUTE_STD_LAT_LONG;
/
show errors;


-- REFERENTIAL INTEGRITY CONSTRAINTS REDFINE
ALTER TABLE STATION_CHAR DROP CONSTRAINT FK_STATION_CHAR01; 
ALTER TABLE STATION_CHAR ADD (
  CONSTRAINT FK_STATION_CHAR01 FOREIGN KEY (FK_FA_STATN) 
    REFERENCES FA_STATION (PK_ISN)
    ON DELETE CASCADE);

ALTER TABLE STATION_CHAR DROP CONSTRAINT FK_STATION_CHAR02;
ALTER TABLE STATION_CHAR ADD (
  CONSTRAINT FK_STATION_CHAR02 FOREIGN KEY (FK_CHAR) 
    REFERENCES DI_CHARACTERISTIC (PK_ISN)
    ON DELETE CASCADE);


ALTER TABLE REGULAR_RESULT_PROJECT DROP CONSTRAINT RE_PROJ_FK_RESULT;
ALTER TABLE REGULAR_RESULT_PROJECT ADD (
  CONSTRAINT RE_PROJ_FK_RESULT FOREIGN KEY (FK_RESULT) 
    REFERENCES FA_REGULAR_RESULT (PK_ISN)
    ON DELETE CASCADE);

ALTER TABLE REGULAR_RESULT_PROJECT DROP CONSTRAINT RE_PROJ_FK_PROJECT;
ALTER TABLE REGULAR_RESULT_PROJECT ADD (
  CONSTRAINT RE_PROJ_FK_PROJECT FOREIGN KEY (FK_PROJECT) 
    REFERENCES DI_PROJECT (PK_ISN) 
        ON DELETE CASCADE);

ALTER TABLE BIOLOGICAL_RESULT_PROJECT DROP CONSTRAINT BI_PROJ_FK_PROJECT;
ALTER TABLE BIOLOGICAL_RESULT_PROJECT ADD (
  CONSTRAINT BI_PROJ_FK_PROJECT FOREIGN KEY (FK_PROJECT) 
    REFERENCES DI_PROJECT (PK_ISN)
    ON DELETE CASCADE);

ALTER TABLE BIOLOGICAL_RESULT_PROJECT DROP CONSTRAINT BI_PROJ_FK_RESULT;
ALTER TABLE BIOLOGICAL_RESULT_PROJECT ADD (
  CONSTRAINT BI_PROJ_FK_RESULT FOREIGN KEY (FK_RESULT) 
    REFERENCES FA_BIOLOGICAL_RESULT (PK_ISN)
    ON DELETE CASCADE);

ALTER TABLE FA_REGULAR_RESULT drop CONSTRAINT RE_FK_STATION;
ALTER TABLE FA_REGULAR_RESULT ADD (
  CONSTRAINT RE_FK_STATION FOREIGN KEY (FK_STATION) 
    REFERENCES FA_STATION (PK_ISN)
    ON DELETE CASCADE);

ALTER TABLE FA_BIOLOGICAL_RESULT drop CONSTRAINT BR_FK_STATION;
ALTER TABLE FA_BIOLOGICAL_RESULT ADD (
  CONSTRAINT BR_FK_STATION FOREIGN KEY (FK_STATION) 
    REFERENCES FA_STATION (PK_ISN)
    ON DELETE CASCADE);


ALTER TABLE STATION_PROJECT DROP CONSTRAINT RE_STN_PROJ_FK_STATION;
ALTER TABLE STATION_PROJECT ADD (
  CONSTRAINT RE_STN_PROJ_FK_STATION FOREIGN KEY (FK_STATION) 
    REFERENCES FA_STATION (PK_ISN)
    ON DELETE CASCADE);

ALTER TABLE STATION_PROJECT DROP CONSTRAINT RE_STN_PROJ_FK_PROJ;
ALTER TABLE STATION_PROJECT ADD (
  CONSTRAINT RE_STN_PROJ_FK_PROJ FOREIGN KEY (FK_PROJECT) 
    REFERENCES DI_PROJECT (PK_ISN)
    ON DELETE CASCADE);

-- new objects for version2
create bitmap index fa_reg_res_source_system on fa_regular_result(source_system)
tablespace storetindx 
storage (initial 2M next 2M);

create bitmap index fa_bio_res_source_system on fa_biological_result(source_system)
tablespace storetindx 
storage (initial 2M next 2M);

drop index fa_reg_res_source_uid;
create index fa_reg_res_source_uid on fa_regular_result(source_system,source_uid)
tablespace storetindx 
storage (initial 2M next 2M);

drop index fa_bio_res_source_uid;
create index fa_bio_res_source_uid on fa_biological_result(source_system,source_uid)
tablespace storetindx 
storage (initial 2M next 2M);

--new objects 09/29/2007
--mt_wh_config table and its procedure are moved to mt_wh_config_procs.sql script.
/*
create table mt_wh_config
(parameter_name varchar2(256),
 Parameter_value varchar2(256),
 Application varchar2(256),
 Description varchar2(4000))
Tablespace storetdata
Storage(initial 256K next 256 k);

alter table mt_wh_config
add constraint pk_mt_wh_config primary Key (parameter_name)
using index 
tablespace storetindx
storage (initial 96K next 96k);

Insert into mt_wh_config (parameter_name,parameter_value,application,description)
values ('RUN_WATERSHED_REFRESH' , 'YES' , 'STORETW', 'Warehouse Summary refresh processing Flag.');

Insert into mt_wh_config (parameter_name,parameter_value,application,description)
values ('ETL_FULL_LOAD' , 'NO' , 'WQX_ETL', 'WQX ETL Full or Incremental Load Flag');
commit;

CREATE OR REPLACE PROCEDURE Sp_Fetch_Config_Value(in_param IN VARCHAR2, out_param_value OUT VARCHAR2)
-- out_PROC_STATUS OUT NUMBER)
AS
LV_OUT_PARAM_VALUE VARCHAR2(256);
BEGIN
out_param_value := NULL;
SELECT parameter_value INTO LV_out_param_value FROM MT_WH_CONFIG
WHERE UPPER(TRIM(parameter_name))= UPPER(trim(in_param));

OUT_PARAM_VALUE:=LV_OUT_PARAM_VALUE;

-- out_PROC_STATUS:=0;

EXCEPTION
WHEN OTHERS THEN
out_PARAM_VALUE:='ERROR';

END;
show errors;
*/

CREATE OR REPLACE PROCEDURE Sp_Post_Processing_For_Wqx_Etl(in_DUMMY_VAL IN NUMBER, out_PROC_STATUS OUT NUMBER)
AS
BEGIN
 out_PROC_STATUS:=0;
EXCEPTION
WHEN OTHERS THEN NULL;
END;
/
show errors;

CREATE OR REPLACE PROCEDURE Sp_Pre_Processing_For_Wqx_Etl(in_DUMMY_VAL IN NUMBER, out_PROC_STATUS OUT NUMBER)
AS
BEGIN
 out_PROC_STATUS:=0;

EXCEPTION
WHEN OTHERS THEN
  out_PROC_STATUS:=9999;
  NULL;
END;
/
show errors;

spool off;