/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodWrapper;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackGenerator;
import net.sf.cglib.proxy.CallbackUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class EnhancerEmitter
extends ClassEmitter {
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type FACTORY = TypeUtils.parseType("net.sf.cglib.proxy.Factory");
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = TypeUtils.parseSignature("void CGLIB$SET_THREAD_CALLBACKS(net.sf.cglib.proxy.Callback[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(net.sf.cglib.proxy.Callback[])");
    private static final Signature MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[], net.sf.cglib.proxy.Callback[])");
    private static final Signature SINGLE_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(net.sf.cglib.proxy.Callback)");
    private static final Signature COPY_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance()");
    private static final Signature COPY_MULTIARG_NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(Class[], Object[])");
    private static final Signature SET_CALLBACK = TypeUtils.parseSignature("void setCallback(int, net.sf.cglib.proxy.Callback)");
    private static final Signature GET_CALLBACK = TypeUtils.parseSignature("net.sf.cglib.proxy.Callback getCallback(int)");
    private static final Signature SET_CALLBACKS = TypeUtils.parseSignature("void setCallbacks(net.sf.cglib.proxy.Callback[])");
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private Class[] callbackTypes;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Factory;
    static /* synthetic */ Class array$Lnet$sf$cglib$proxy$Callback;

    public EnhancerEmitter(ClassVisitor v, String className, Class superclass, Class[] interfaces, CallbackFilter filter, Class[] callbackTypes, boolean useFactory) throws Exception {
        super(v);
        if (superclass == null) {
            superclass = class$java$lang$Object == null ? (class$java$lang$Object = EnhancerEmitter.class$("java.lang.Object")) : class$java$lang$Object;
        }
        this.callbackTypes = callbackTypes;
        this.begin_class(1, className, Type.getType(superclass), useFactory ? TypeUtils.add(TypeUtils.getTypes(interfaces), FACTORY) : TypeUtils.getTypes(interfaces), "<generated>");
        ArrayList clist = new ArrayList(Arrays.asList(superclass.getDeclaredConstructors()));
        CollectionUtils.filter(clist, (Predicate)new VisibilityPredicate(superclass, true));
        if (clist.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + superclass);
        }
        Constructor[] constructors = clist.toArray(new Constructor[clist.size()]);
        ArrayList methods = new ArrayList();
        ReflectUtils.addAllMethods(superclass, methods);
        ArrayList interfaceMethods = new ArrayList();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                if (interfaces[i] != (class$net$sf$cglib$proxy$Factory == null ? EnhancerEmitter.class$("net.sf.cglib.proxy.Factory") : class$net$sf$cglib$proxy$Factory)) {
                    ReflectUtils.addAllMethods(interfaces[i], interfaceMethods);
                }
                ++i;
            }
        }
        Set forcePublic = MethodWrapper.createSet(interfaceMethods);
        methods.addAll(interfaceMethods);
        CollectionUtils.filter(methods, (Predicate)new VisibilityPredicate(superclass, true));
        CollectionUtils.filter(methods, (Predicate)new DuplicatesPredicate());
        EnhancerEmitter.removeFinal(methods);
        HashMap<CallbackGenerator, ArrayList<Method>> groups = new HashMap<CallbackGenerator, ArrayList<Method>>();
        HashMap<Method, Integer> indexes = new HashMap<Method, Integer>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            int index = filter.accept(method);
            if (index >= callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            indexes.put(method, new Integer(index));
            CallbackGenerator gen = CallbackUtils.getGenerator(callbackTypes[index]);
            ArrayList<Method> group = (ArrayList<Method>)groups.get(gen);
            if (group == null) {
                group = new ArrayList<Method>(methods.size());
                groups.put(gen, group);
            }
            group.add(method);
        }
        this.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null, null);
        this.emitMethods(groups, indexes, forcePublic);
        this.emitConstructors(constructors);
        this.emitSetThreadCallbacks();
        if (useFactory) {
            int[] keys = this.getCallbackKeys();
            this.emitNewInstanceCallbacks();
            this.emitNewInstanceCallback();
            this.emitNewInstanceMultiarg(constructors);
            this.emitNewInstanceCopy();
            this.emitNewInstanceMultiargCopy(constructors);
            this.emitGetCallback(keys);
            this.emitSetCallback(keys);
            this.emitSetCallbacks();
        }
        this.end_class();
    }

    static void setThreadCallbacks(Class type, Callback[] callbacks) {
        try {
            Method setter = type.getDeclaredMethod(SET_THREAD_CALLBACKS_NAME, array$Lnet$sf$cglib$proxy$Callback == null ? (array$Lnet$sf$cglib$proxy$Callback = EnhancerEmitter.class$("[Lnet.sf.cglib.proxy.Callback;")) : array$Lnet$sf$cglib$proxy$Callback);
            setter.invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e);
        }
    }

    private void emitConstructors(Constructor[] constructors) {
        int i = 0;
        while (i < constructors.length) {
            Signature sig = ReflectUtils.getSignature(constructors[i]);
            CodeEmitter e = this.begin_method(1, sig, ReflectUtils.getExceptionTypes(constructors[i]), null);
            e.load_this();
            e.dup();
            e.load_args();
            e.super_invoke_constructor(sig);
            e.push(1);
            e.putfield(CONSTRUCTED_FIELD);
            int j = 0;
            while (j < this.callbackTypes.length) {
                e.load_this();
                e.dup();
                e.getfield(EnhancerEmitter.getThreadLocal(j));
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
                e.checkcast(Type.getType(this.callbackTypes[j]));
                e.putfield(EnhancerEmitter.getCallbackField(j));
                e.getfield(EnhancerEmitter.getThreadLocal(j));
                e.aconst_null();
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                ++j;
            }
            e.return_value();
            e.end_method();
            ++i;
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        int i = 0;
        while (i < this.callbackTypes.length) {
            keys[i] = i;
            ++i;
        }
        return keys;
    }

    private void emitGetCallback(int[] keys) {
        final CodeEmitter e = this.begin_method(1, GET_CALLBACK, null, null);
        e.load_this();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e.getfield(EnhancerEmitter.getCallbackField(key));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop();
                e.aconst_null();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallback(int[] keys) {
        final CodeEmitter e = this.begin_method(1, SET_CALLBACK, null, null);
        e.load_this();
        e.load_arg(1);
        e.dup();
        e.load_arg(0);
        e.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e.getfield(EnhancerEmitter.getThreadLocal(key));
                e.swap();
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                e.checkcast(Type.getType(EnhancerEmitter.this.callbackTypes[key]));
                e.putfield(EnhancerEmitter.getCallbackField(key));
                e.goTo(end);
            }

            public void processDefault() {
                e.pop2();
                e.pop();
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitSetCallbacks() {
        CodeEmitter e = this.begin_method(1, SET_CALLBACKS, null, null);
        this.emitSetThreadCallbacks(e);
        e.load_this();
        e.load_arg(0);
        int i = 0;
        while (i < this.callbackTypes.length) {
            e.dup2();
            e.aaload(i);
            e.checkcast(Type.getType(this.callbackTypes[i]));
            e.putfield(EnhancerEmitter.getCallbackField(i));
            ++i;
        }
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallbacks() {
        CodeEmitter e = this.begin_method(1, NEW_INSTANCE, null, null);
        e.load_arg(0);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceCopy() {
        CodeEmitter e = this.begin_method(1, COPY_NEW_INSTANCE, null, null);
        this.emitCopyCallbacks(e);
        this.emitCommonNewInstance(e);
    }

    private void emitCopyCallbacks(CodeEmitter e) {
        int i = 0;
        while (i < this.callbackTypes.length) {
            e.getfield(EnhancerEmitter.getThreadLocal(i));
            e.load_this();
            e.getfield(EnhancerEmitter.getCallbackField(i));
            e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
            ++i;
        }
    }

    private void emitCommonNewInstance(CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.invoke_constructor_this();
        e.return_value();
        e.end_method();
    }

    private void emitNewInstanceCallback() {
        CodeEmitter e = this.begin_method(1, SINGLE_NEW_INSTANCE, null, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e.getfield(EnhancerEmitter.getThreadLocal(0));
                e.load_arg(0);
                e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
                break;
            }
            default: {
                e.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(e);
    }

    private void emitNewInstanceMultiarg(Constructor[] constructors) {
        CodeEmitter e = this.begin_method(1, MULTIARG_NEW_INSTANCE, null, null);
        e.load_arg(2);
        e.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonMultiarg(constructors, e);
    }

    private void emitNewInstanceMultiargCopy(Constructor[] constructors) {
        CodeEmitter e = this.begin_method(1, COPY_MULTIARG_NEW_INSTANCE, null, null);
        this.emitCopyCallbacks(e);
        this.emitCommonMultiarg(constructors, e);
    }

    private void emitCommonMultiarg(Constructor[] constructors, final CodeEmitter e) {
        e.new_instance_this();
        e.dup();
        e.load_arg(0);
        EmitUtils.constructor_switch(e, constructors, new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                Constructor constructor = (Constructor)key;
                Type[] types = TypeUtils.getTypes(constructor.getParameterTypes());
                int i = 0;
                while (i < types.length) {
                    e.load_arg(1);
                    e.push(i);
                    e.aaload();
                    e.unbox(types[i]);
                    ++i;
                }
                e.invoke_constructor_this(ReflectUtils.getSignature(constructor));
                e.goTo(end);
            }

            public void processDefault() {
                e.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e.return_value();
        e.end_method();
    }

    private void emitMethods(Map groups, final Map indexes, final Set forcePublic) throws Exception {
        int i = 0;
        while (i < this.callbackTypes.length) {
            this.declare_field(2, EnhancerEmitter.getCallbackField(i), Type.getType(this.callbackTypes[i]), null, null);
            this.declare_field(26, EnhancerEmitter.getThreadLocal(i), THREAD_LOCAL, null, null);
            ++i;
        }
        HashSet<CallbackGenerator> seenGen = new HashSet<CallbackGenerator>();
        CodeEmitter e = this.begin_static();
        int i2 = 0;
        while (i2 < this.callbackTypes.length) {
            e.new_instance(THREAD_LOCAL);
            e.dup();
            e.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
            e.putfield(EnhancerEmitter.getThreadLocal(i2));
            CallbackGenerator gen = CallbackUtils.getGenerator(this.callbackTypes[i2]);
            if (!seenGen.contains(gen)) {
                seenGen.add(gen);
                final List fmethods = (List)groups.get(gen);
                CallbackGenerator.Context context = new CallbackGenerator.Context(){

                    public Iterator getMethods() {
                        return fmethods.iterator();
                    }

                    public int getIndex(Method method) {
                        return (Integer)indexes.get(method);
                    }

                    public void emitCallback(CodeEmitter e, int index) {
                        EnhancerEmitter.this.emitCurrentCallback(e, index);
                    }

                    public int getModifiers(Method method) {
                        int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                        if (forcePublic.contains(MethodWrapper.create(method))) {
                            modifiers = modifiers & 0xFFFFFFFB | 1;
                        }
                        return modifiers;
                    }

                    public String getUniqueName(Method method) {
                        return method.getName() + "_" + fmethods.indexOf(method);
                    }
                };
                gen.generate(this, context);
                gen.generateStatic(e, context);
            }
            ++i2;
        }
        e.return_value();
        e.end_method();
    }

    private void emitSetThreadCallbacks() {
        CodeEmitter e = this.begin_method(9, SET_THREAD_CALLBACKS, null, null);
        this.emitSetThreadCallbacks(e);
        e.return_value();
        e.end_method();
    }

    private void emitSetThreadCallbacks(CodeEmitter e) {
        int i = 0;
        while (i < this.callbackTypes.length) {
            e.getfield(EnhancerEmitter.getThreadLocal(i));
            e.load_arg(0);
            e.aaload(i);
            e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
            ++i;
        }
    }

    private void emitCurrentCallback(CodeEmitter e, int index) {
        e.load_this();
        e.getfield(EnhancerEmitter.getCallbackField(index));
        e.dup();
        Label end = e.make_label();
        e.ifnonnull(end);
        e.load_this();
        e.getfield(CONSTRUCTED_FIELD);
        e.if_jump(154, end);
        e.pop();
        e.getfield(EnhancerEmitter.getThreadLocal(index));
        e.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e.checkcast(Type.getType(this.callbackTypes[index]));
        e.mark(end);
    }

    private static String getCallbackField(int index) {
        return "CGLIB$CALLBACK_" + index;
    }

    private static String getThreadLocal(int index) {
        return "CGLIB$TL_CALLBACK_" + index;
    }

    private static void removeFinal(List list) {
        CollectionUtils.filter(list, new Predicate(){

            public boolean evaluate(Object arg) {
                return !Modifier.isFinal(((Method)arg).getModifiers());
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

