/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.AbstractJ2eeCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;

public abstract class MethodChecker {
    private final AbstractJ2eeCheck mCheck;

    public MethodChecker(AbstractJ2eeCheck aCheck) {
        this.mCheck = aCheck;
    }

    protected AbstractJ2eeCheck getCheck() {
        return this.mCheck;
    }

    public void checkMethods(DetailAST aAST) {
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 9) continue;
                this.checkMethod(child);
            }
        }
    }

    public abstract void checkMethod(DetailAST var1);

    public void checkMethod(DetailAST aMethodAST, boolean aAllowFinal) {
        if (!Utils.isPublic(aMethodAST)) {
            this.logName(aMethodAST, "nonpublicmethod.bean", new Object[0]);
        }
        if (!aAllowFinal && Utils.isFinal(aMethodAST)) {
            this.logName(aMethodAST, "illegalmodifiermethod.bean", new Object[]{"final"});
        }
        if (Utils.isStatic(aMethodAST)) {
            this.logName(aMethodAST, "illegalmodifiermethod.bean", new Object[]{"static"});
        }
    }

    protected void checkThrows(DetailAST aMethodAST, String aException) {
        if (!Utils.hasThrows(aMethodAST, aException)) {
            this.logName(aMethodAST, "missingthrows.bean", new Object[]{aException});
        }
    }

    protected void checkNotThrows(DetailAST aMethodAST, String aException) {
        if (Utils.hasThrows(aMethodAST, aException)) {
            this.logName(aMethodAST, "hasthrows.bean", new Object[]{aException});
        }
    }

    protected void log(DetailAST aMethodAST, String aKey, Object[] aArgs) {
        this.mCheck.log(aMethodAST, aKey, aArgs);
    }

    protected void logName(DetailAST aMethodAST, String aKey, Object[] aArgs) {
        this.mCheck.logName(aMethodAST, aKey, aArgs);
    }
}

