/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.checks.usage.AbstractUsageCheck;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabASTFactory;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymbolTableException;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.TableMaker;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ASTManager {
    private static final ASTManager INSTANCE = new ASTManager();
    private Map mMap = new HashMap();
    private SymTabAST mCompleteTree = null;
    private Map mTrees = new HashMap();
    private Map mCheckNodes = new HashMap();

    private ASTManager() {
    }

    public static ASTManager getInstance() {
        return INSTANCE;
    }

    public void addTree(String aFileName, AST aRoot) {
        this.clear();
        this.mTrees.put(aFileName, aRoot);
    }

    private void clear() {
        this.mCheckNodes.clear();
        this.mTrees.clear();
        this.mMap.clear();
        this.mCompleteTree = null;
    }

    private void buildTree() throws SymbolTableException {
        this.mCompleteTree = SymTabASTFactory.create(0, "AST Root");
        Set keys = this.mTrees.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String fileName = (String)it.next();
            File file = new File(fileName);
            AST rootAST = (AST)this.mTrees.get(fileName);
            this.addToCompleteTree(file, rootAST);
        }
        SymbolTable table = new TableMaker(this.mCompleteTree).getTable();
    }

    private void addToCompleteTree(File aFile, AST aAST) {
        SymTabAST fileNode = SymTabASTFactory.create(0, aFile.getAbsolutePath());
        fileNode.setFile(aFile);
        this.mCompleteTree.addChild((AST)fileNode);
        fileNode.setParent(this.mCompleteTree);
        SymTabAST child = SymTabASTFactory.create(aAST);
        child.setFile(aFile);
        fileNode.addChild((AST)child);
        child.setParent(fileNode);
        fileNode.finishDefinition(aFile, this.mCompleteTree);
    }

    public void registerCheckNode(AbstractUsageCheck aCheck, AST aNode) {
        HashSet<AST> nodeSet = (HashSet<AST>)this.mCheckNodes.get((Object)aCheck);
        if (nodeSet == null) {
            nodeSet = new HashSet<AST>();
            nodeSet.add(aNode);
            this.mCheckNodes.put(aCheck, nodeSet);
        } else {
            nodeSet.add(aNode);
        }
    }

    public Set getCheckNodes(AbstractUsageCheck aCheck) throws SymbolTableException {
        HashSet result;
        if (this.mCompleteTree == null) {
            this.buildTree();
        }
        if ((result = (HashSet)this.mCheckNodes.get((Object)aCheck)) == null) {
            result = new HashSet();
        }
        return result;
    }

    public void put(AST aAST, SymTabAST aSymTabAST) {
        this.mMap.put(aAST, aSymTabAST);
    }

    public SymTabAST get(AST aAST) {
        return (SymTabAST)((Object)this.mMap.get(aAST));
    }

    public void clearDetailsMap() {
        this.mMap.clear();
    }

    public boolean isEmptyDetailsMap() {
        return this.mMap.isEmpty();
    }

    public void removeCheck(AbstractUsageCheck aCheck) {
        this.mCheckNodes.remove((Object)aCheck);
        if (this.mCheckNodes.isEmpty()) {
            this.clear();
        }
    }
}

