/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BlockDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Definition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IPackage;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IVariable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.LabelDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Occurrence;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Reference;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.VariableDef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public abstract class Scope
extends Definition {
    private Vector unresolvedStuff = new Vector();
    protected SortedSet referencesInScope = new TreeSet();
    protected Hashtable elements = new Hashtable();
    protected Hashtable labels = new Hashtable();
    protected Hashtable classes = new Hashtable();

    public Scope(String name, Scope parentScope, SymTabAST node) {
        super(name, parentScope, node);
    }

    public void addDefinition(VariableDef def) {
        this.elements.put(def.getName(), def);
    }

    public void addDefinition(BlockDef def) {
        this.elements.put(def.getName(), def);
    }

    public void addDefinition(ClassDef def) {
        this.classes.put(def.getName(), def);
    }

    public void addDefinition(LabelDef def) {
        this.labels.put(def.getName(), def);
    }

    public abstract void addDefinition(IPackage var1);

    protected Enumeration getDefinitions() {
        Vector allElements = new Vector();
        allElements.addAll(this.elements.values());
        allElements.addAll(this.labels.values());
        allElements.addAll(this.classes.values());
        return allElements.elements();
    }

    protected Iterator getClasses() {
        return this.classes.values().iterator();
    }

    public abstract IMethod getMethodDefinition(String var1, ISignature var2);

    public abstract IVariable getVariableDefinition(String var1);

    public abstract LabelDef getLabelDefinition(String var1);

    public abstract IClass getClassDefinition(String var1);

    public Iterator getReferencesIn() {
        return this.referencesInScope.iterator();
    }

    public Reference getSymbol(String name, Occurrence location) {
        Reference result = null;
        Iterator it = this.getReferencesIn();
        while (it.hasNext()) {
            Reference reference = (Reference)it.next();
            if (reference.getLine() != location.getLine() || reference.getColumn() != location.getColumn()) continue;
            result = reference;
            break;
        }
        return result;
    }

    public void addReferenceInScope(Reference reference) {
        this.referencesInScope.add(reference);
    }
}

