/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

public class Span {
    private int _startLine;
    private int _startColumn;
    private int _endLine;
    private int _endColumn;

    public Span() {
    }

    public Span(int startLine, int startColumn, int endLine, int endColumn) {
        this.setStart(startLine, startColumn);
        this.setEnd(endLine, endColumn);
    }

    public Span(Span span) {
        this(span.getStartLine(), span.getStartColumn(), span.getEndLine(), span.getEndColumn());
    }

    public void setStart(int startLine, int startColumn) {
        this._startLine = startLine;
        this._startColumn = startColumn;
    }

    public void setEnd(int endLine, int endColumn) {
        this._endLine = endLine;
        this._endColumn = endColumn;
    }

    public int getStartLine() {
        return this._startLine;
    }

    public int getStartColumn() {
        return this._startColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public boolean contains(Span span) {
        return this.contains(span.getStartLine(), span.getStartColumn()) && this.contains(span.getEndLine(), span.getEndColumn());
    }

    public boolean contains(int line, int column) {
        boolean afterStart = false;
        boolean beforeEnd = false;
        if (this.getStartLine() < line) {
            afterStart = true;
        } else if (this.getStartLine() == line && this.getStartColumn() <= column) {
            afterStart = true;
        }
        if (this.getEndLine() > line) {
            beforeEnd = true;
        } else if (this.getEndLine() == line && this.getEndColumn() >= column) {
            beforeEnd = true;
        }
        return afterStart && beforeEnd;
    }

    protected boolean startsBefore(Span span) {
        boolean result = false;
        if (this.getStartLine() < span.getStartLine()) {
            result = true;
        } else if (this.getStartLine() == span.getStartLine() && this.getStartColumn() <= span.getStartColumn()) {
            result = true;
        }
        return result;
    }

    protected boolean endsAfter(Span span) {
        boolean result = false;
        if (this.getEndLine() > span.getEndLine()) {
            result = true;
        } else if (this.getEndLine() == span.getEndLine() && this.getEndColumn() >= span.getEndColumn()) {
            result = true;
        }
        return result;
    }

    public void compose(Span span) {
        if (span.startsBefore(this)) {
            this.setStart(span.getStartLine(), span.getStartColumn());
        }
        if (span.endsAfter(this)) {
            this.setEnd(span.getEndLine(), span.getEndColumn());
        }
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Span) {
            Span span = (Span)o;
            result = span.getStartLine() == this.getStartLine() && span.getStartColumn() == this.getStartColumn() && span.getEndLine() == this.getEndLine() && span.getEndColumn() == this.getEndColumn();
        }
        return result;
    }

    public String toString() {
        return "[" + this.getStartLine() + "," + this.getStartColumn() + ":" + this.getEndLine() + "," + this.getEndColumn() + "]";
    }
}

