/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.antlr;

import antlr.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.antlr.NoExitSecurityManager;

public class AntlrTag
extends TagSupport {
    private List grammars = new ArrayList(1);
    private File outputDir;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.outputDir == null) {
            throw new MissingAttributeException("outputDir");
        }
        this.invokeBody(output);
        Iterator grammarIter = this.grammars.iterator();
        String eachGrammar = null;
        String sourceDir = (String)this.getContext().getVariable("maven.antlr.src.dir");
        File grammar = null;
        while (grammarIter.hasNext()) {
            Object var11_10;
            eachGrammar = ((String)grammarIter.next()).trim();
            grammar = new File(sourceDir, eachGrammar);
            File generated = this.getGeneratedFile(grammar.getPath());
            if (generated.exists() && generated.lastModified() > grammar.lastModified()) {
                return;
            }
            if (!generated.getParentFile().exists()) {
                generated.getParentFile().mkdirs();
            }
            String[] args = new String[]{"-o", generated.getParentFile().getPath(), grammar.getPath()};
            SecurityManager oldSm = System.getSecurityManager();
            System.setSecurityManager(NoExitSecurityManager.INSTANCE);
            try {
                try {
                    Tool.main((String[])args);
                }
                catch (SecurityException e) {
                    if (!e.getMessage().equals("exitVM-0")) {
                        throw new JellyTagException((Throwable)e);
                    }
                    var11_10 = null;
                    System.setSecurityManager(oldSm);
                    continue;
                }
                var11_10 = null;
            }
            catch (Throwable throwable) {
                var11_10 = null;
                System.setSecurityManager(oldSm);
                throw throwable;
            }
            System.setSecurityManager(oldSm);
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    protected File getGeneratedFile(String grammar) throws JellyTagException {
        File grammarFile = new File(grammar);
        String generatedFileName = null;
        Object className = null;
        String packageName = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(grammar));
            while ((line = in.readLine()) != null) {
                void var7_8;
                line = var7_8.trim();
                int extendsIndex = line.indexOf(" extends ");
                if (line.startsWith("class ") && extendsIndex > -1) {
                    generatedFileName = line.substring(6, extendsIndex).trim();
                    break;
                }
                if (!line.startsWith("package")) continue;
                packageName = line.substring(8).trim();
            }
            in.close();
        }
        catch (Exception e) {
            throw new JellyTagException("Unable to determine generated class", (Throwable)e);
        }
        if (generatedFileName == null) {
            return null;
        }
        File genFile = null;
        if ("".equals(packageName)) {
            genFile = new File(this.getOutputDir(), generatedFileName + ".java");
        } else {
            String packagePath = packageName.replace('.', File.separatorChar);
            packagePath = packagePath.replace(';', File.separatorChar);
            genFile = new File(new File(this.getOutputDir(), packagePath), generatedFileName + ".java");
        }
        return genFile;
    }

    void addGrammar(String grammar) {
        this.grammars.add(grammar);
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }
}

