/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.velocity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jelly.JellyContext;
import org.apache.velocity.context.Context;

public class JellyContextAdapter
implements Context {
    private boolean readOnly = true;
    private JellyContext jellyContext;
    private HashMap privateContext = new HashMap();

    public JellyContextAdapter(JellyContext jellyContext) {
        this.jellyContext = jellyContext;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (this.readOnly && this.privateContext.containsKey(key)) {
            return true;
        }
        return this.jellyContext.getVariable(key.toString()) != null;
    }

    public Object get(String key) {
        if (key == null) {
            return null;
        }
        if (this.readOnly && this.privateContext.containsKey(key)) {
            return this.privateContext.get(key);
        }
        return this.jellyContext.getVariable(key);
    }

    public Object[] getKeys() {
        Set keys = this.jellyContext.getVariables().keySet();
        if (this.readOnly) {
            HashSet combinedKeys = new HashSet(keys);
            combinedKeys.addAll(this.privateContext.keySet());
            keys = combinedKeys;
        }
        return keys.toArray();
    }

    public Object put(String key, Object value) {
        Object oldValue;
        if (key == null || value == null) {
            return null;
        }
        if (this.readOnly) {
            oldValue = this.privateContext.put(key, value);
        } else {
            oldValue = this.jellyContext.getVariable(key);
            this.jellyContext.setVariable(key, value);
        }
        return oldValue;
    }

    public Object remove(Object key) {
        Object oldValue;
        if (key == null) {
            return null;
        }
        if (this.readOnly) {
            oldValue = this.privateContext.remove(key);
        } else {
            oldValue = this.jellyContext.getVariable(key.toString());
            this.jellyContext.removeVariable(key.toString());
        }
        return oldValue;
    }
}

