/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.velocity;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.velocity.JellyContextAdapter;
import org.apache.commons.jelly.tags.velocity.VelocityTagSupport;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class MergeTag
extends VelocityTagSupport {
    private static final String ENCODING = "ISO-8859-1";
    private String var;
    private String name;
    private String basedir;
    private String template;
    private String inputEncoding;
    private String outputEncoding;
    private boolean readOnly = true;

    public void doTag(XMLOutput output) throws JellyTagException {
        if (this.basedir == null || this.template == null) {
            throw new JellyTagException("This tag must define 'basedir' and 'template'");
        }
        if (this.name != null) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.name), this.outputEncoding == null ? ENCODING : this.outputEncoding);
                this.mergeTemplate(writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new JellyTagException((Throwable)e);
            }
        } else if (this.var != null) {
            StringWriter writer = new StringWriter();
            this.mergeTemplate(writer);
            this.context.setVariable(this.var, (Object)writer.toString());
        } else {
            throw new JellyTagException("This tag must define either 'name' or 'var'");
        }
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = encoding;
    }

    public void setInputEncoding(String encoding) {
        this.inputEncoding = encoding;
    }

    private void mergeTemplate(Writer writer) throws JellyTagException {
        JellyContextAdapter adapter = new JellyContextAdapter(this.getContext());
        adapter.setReadOnly(this.readOnly);
        try {
            this.getVelocityEngine(this.basedir).mergeTemplate(this.template, this.inputEncoding == null ? ENCODING : this.inputEncoding, (Context)adapter, writer);
        }
        catch (ResourceNotFoundException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (ParseErrorException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (MethodInvocationException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (Exception e) {
            throw new JellyTagException((Throwable)e);
        }
    }
}

