/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.dvsl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.dvsl.AntLogSystem;
import org.apache.tools.dvsl.DVSL;

public class DVSLTask
extends MatchingTask {
    public static final String INFILENAME = "infilename";
    public static final String OUTFILENAME = "outfilename";
    private DVSL dvsl;
    private File destDir = null;
    private File baseDir = null;
    private File stylesheet = null;
    private File inFile = null;
    private File outFile = null;
    private File logFile = null;
    private String targetExtension = ".html";
    private String outputEncoding = "UTF-8";
    private Path classpath = null;
    private ClassLoader classLoader = null;
    private boolean force = false;
    private Vector toolAttr = new Vector();
    private File toolboxFile = null;
    private Properties toolboxProps = null;
    private String velConfigClass = null;
    private Map velConfigMap = null;
    private Vector velConfigAttr = new Vector();
    private boolean validatingParser = false;
    static /* synthetic */ Class class$org$apache$tools$dvsl$DVSLTask;

    public DVSLTask() {
        this.classLoader = (class$org$apache$tools$dvsl$DVSLTask == null ? (class$org$apache$tools$dvsl$DVSLTask = DVSLTask.class$("org.apache.tools.dvsl.DVSLTask")) : class$org$apache$tools$dvsl$DVSLTask).getClassLoader();
    }

    public void execute() throws BuildException {
        Object p;
        Enumeration e;
        block24: {
            if (this.stylesheet == null) {
                throw new BuildException("no stylesheet specified", ((Task)this).location);
            }
            if (this.baseDir == null) {
                this.baseDir = ((ProjectComponent)this).project.resolveFile(".");
            }
            this.dvsl = new DVSL();
            this.dvsl.setValidatingParser(this.validatingParser);
            if (this.classpath != null) {
                this.classLoader = new AntClassLoader(((ProjectComponent)this).project, this.classpath);
                this.dvsl.setClassLoader(this.classLoader);
            }
            Object velConfigObj = null;
            if (this.velConfigClass != null) {
                try {
                    velConfigObj = Class.forName(this.velConfigClass, true, this.classLoader).newInstance();
                    if (velConfigObj instanceof Map) {
                        this.velConfigMap = velConfigObj;
                        break block24;
                    }
                    throw new BuildException("VelocityPropClass is not instanceof java.util.Map");
                }
                catch (Exception ex) {
                    throw new BuildException("Error instantiating VelocityPropClass : " + ex);
                }
            }
        }
        if (!this.velConfigAttr.isEmpty()) {
            if (this.velConfigMap == null) {
                this.velConfigMap = new HashMap();
            }
            e = this.velConfigAttr.elements();
            while (e.hasMoreElements()) {
                p = (VelocityConfig)e.nextElement();
                this.velConfigMap.put(((VelocityConfig)p).getName(), ((VelocityConfig)p).getValue());
            }
        }
        if (this.velConfigMap != null) {
            this.dvsl.setVelocityConfig(this.velConfigMap);
        }
        if (this.logFile != null) {
            this.dvsl.setLogFile(this.logFile);
        } else {
            this.dvsl.setLogSystem(new AntLogSystem((Task)this));
        }
        try {
            this.log("Loading stylesheet " + this.stylesheet, 2);
            this.dvsl.setStylesheet(this.stylesheet);
        }
        catch (Exception ex) {
            this.log("Failed to read stylesheet " + this.stylesheet, 2);
            throw new BuildException((Throwable)ex);
        }
        this.toolboxProps = new Properties();
        try {
            if (this.toolboxFile != null) {
                this.toolboxProps.load(new FileInputStream(this.toolboxFile));
            }
            e = this.toolAttr.elements();
            while (e.hasMoreElements()) {
                p = (Tool)e.nextElement();
                this.toolboxProps.setProperty(((Tool)p).getName(), ((Tool)p).getValue());
            }
            this.dvsl.setToolbox(this.toolboxProps);
        }
        catch (Exception ee) {
            throw new BuildException("Error loading the toolbox : " + ee);
        }
        if (this.inFile != null && this.outFile != null) {
            this.process(this.inFile, this.outFile, this.stylesheet);
            return;
        }
        if (this.destDir == null) {
            String msg = "destdir attributes must be set!";
            throw new BuildException(msg);
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.baseDir);
        this.log("Transforming into " + this.destDir, 2);
        String[] list = scanner.getIncludedFiles();
        int i = 0;
        while (i < list.length) {
            this.process(this.baseDir, list[i], this.destDir, this.stylesheet);
            ++i;
        }
        String[] dirs = scanner.getIncludedDirectories();
        int j = 0;
        while (j < dirs.length) {
            list = new File(this.baseDir, dirs[j]).list();
            int i2 = 0;
            while (i2 < list.length) {
                this.process(this.baseDir, list[i2], this.destDir, this.stylesheet);
                ++i2;
            }
            ++j;
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setExtension(String name) {
        this.targetExtension = name;
    }

    public void setStyle(File dvslFile) {
        this.stylesheet = dvslFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public void setToolbox(String toolboxFile) {
        this.log("DEPRECATED - use the toolboxfile attribute instead");
        this.toolboxFile = new File(toolboxFile);
    }

    public void setToolboxFile(File toolboxFile) {
        this.toolboxFile = toolboxFile;
    }

    public void setVelocityConfigClass(String classname) {
        this.velConfigClass = classname;
    }

    public void setOut(File outFile) {
        this.outFile = outFile;
    }

    public void setIn(File inFile) {
        this.inFile = inFile;
    }

    public void setOutputEncoding(String encoding) {
        if (encoding != null) {
            this.outputEncoding = encoding;
        }
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setValidatingParser(boolean validating) {
        if (validating) {
            this.log("Parser is validating.");
        }
        this.validatingParser = validating;
    }

    public void putAppValue(String name, Object o) {
        this.dvsl.putAppValue(name, o);
    }

    private void process(File baseDir, String xmlFile, File destDir, File stylesheet) throws BuildException {
        String fileExt = this.targetExtension;
        File outFile = null;
        File inFile = null;
        try {
            String outfilename;
            long styleSheetLastModified = stylesheet.lastModified();
            inFile = new File(baseDir, xmlFile);
            int dotPos = xmlFile.lastIndexOf(46);
            this.dvsl.putAppValue(INFILENAME, xmlFile);
            if (dotPos > 0) {
                outfilename = xmlFile.substring(0, xmlFile.lastIndexOf(46)) + fileExt;
                outFile = new File(destDir, outfilename);
            } else {
                outfilename = xmlFile + fileExt;
                outFile = new File(destDir, outfilename);
            }
            this.dvsl.putAppValue(OUTFILENAME, outfilename);
            if (this.force || inFile.lastModified() > outFile.lastModified() || styleSheetLastModified > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile, 2);
                long time = this.transform(inFile, outFile);
                this.log("Processed " + inFile + " in " + time + " ms.", 3);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void process(File inFile, File outFile, File stylesheet) throws BuildException {
        try {
            long styleSheetLastModified = stylesheet.lastModified();
            this.log("In file " + inFile + " time: " + inFile.lastModified(), 4);
            this.log("Out file " + outFile + " time: " + outFile.lastModified(), 4);
            this.log("Style file " + stylesheet + " time: " + styleSheetLastModified, 4);
            if (this.force || inFile.lastModified() > outFile.lastModified() || styleSheetLastModified > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing " + inFile + " to " + outFile, 2);
                long time = this.transform(inFile, outFile);
                this.log("Processed " + inFile + " in " + time + " ms.", 3);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private long transform(File inFile, File outFile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.outputEncoding));
        long time = this.dvsl.transform(inFile, (Writer)writer);
        writer.close();
        return time;
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    public Tool createTool() {
        Tool p = new Tool();
        this.toolAttr.addElement(p);
        return p;
    }

    public VelocityConfig createVelConfig() {
        VelocityConfig p = new VelocityConfig();
        this.velConfigAttr.addElement(p);
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class VelocityConfig {
        private String name = null;
        private String value = null;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() throws BuildException {
            if (this.value == null) {
                throw new BuildException("Value attribute is missing.");
            }
            return this.value;
        }
    }

    public class Tool {
        private String name = null;
        private String value = null;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() throws BuildException {
            if (this.value == null) {
                throw new BuildException("value for attribute for " + this.getName() + " is missing.");
            }
            return this.value;
        }
    }
}

