/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements Struct {
    StructDescriptor m_descriptor;
    Datum[] m_datumArray;
    Object[] m_objArray;
    boolean m_enableLocalCache = false;
    long m_imgOffset;
    long m_imgLength;
    static /* synthetic */ Class class$oracle$sql$STRUCT;
    static /* synthetic */ Class class$java$sql$Struct;

    public STRUCT(StructDescriptor structDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        DatumWithConnection.assertNotNull(connection);
        DatumWithConnection.assertNotNull(structDescriptor);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(OracleConnection.physicalConnectionWithin(connection))) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        structDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.m_descriptor = structDescriptor;
        if (!this.m_descriptor.isInstantiable()) {
            throw new SQLException("Cannot construct STRUCT instance for a non-instantiable object type");
        }
        this.m_datumArray = objectArray != null ? this.m_descriptor.toArray(objectArray) : new Datum[0];
    }

    public STRUCT(StructDescriptor structDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        DatumWithConnection.assertNotNull(connection);
        DatumWithConnection.assertNotNull(structDescriptor);
        if (!structDescriptor.getInternalConnection().isDescriptorSharable(OracleConnection.physicalConnectionWithin(connection))) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        structDescriptor.setConnection(connection);
        this.m_descriptor = structDescriptor;
        this.setPhysicalConnectionOf(connection);
        this.m_datumArray = null;
    }

    public synchronized String getSQLTypeName() throws SQLException {
        String string = this.m_descriptor.getName();
        return string;
    }

    public synchronized Object[] getAttributes() throws SQLException {
        Object[] objectArray = this.getAttributes(this.getMap());
        return objectArray;
    }

    public synchronized Object[] getAttributes(Map map) throws SQLException {
        Object[] objectArray = this.m_descriptor.toArray(this, map, this.m_enableLocalCache);
        return objectArray;
    }

    public synchronized StructDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public synchronized void setDescriptor(StructDescriptor structDescriptor) {
        this.m_descriptor = structDescriptor;
    }

    public synchronized Datum[] getOracleAttributes() throws SQLException {
        Datum[] datumArray = this.m_descriptor.toOracleArray(this, this.m_enableLocalCache);
        return datumArray;
    }

    public Map getMap() {
        Map map = null;
        try {
            map = this.getInternalConnection().getTypeMap();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return map;
    }

    public synchronized byte[] toBytes() throws SQLException {
        byte[] byArray = this.m_descriptor.toBytes(this, this.m_enableLocalCache);
        return byArray;
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray == null ? new Datum[]{} : datumArray;
    }

    public synchronized void setObjArray(Object[] objectArray) throws SQLException {
        this.m_objArray = objectArray == null ? new Object[]{} : objectArray;
    }

    public static STRUCT toSTRUCT(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        STRUCT sTRUCT = null;
        if (object != null) {
            if (object instanceof STRUCT) {
                sTRUCT = (STRUCT)object;
            } else if (object instanceof ORAData) {
                sTRUCT = (STRUCT)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof CustomDatum) {
                sTRUCT = (STRUCT)((CustomDatum)object).toDatum((OracleConnection)oracleConnection);
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), oracleConnection);
                SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
                sQLData.writeSQL(sQLOutput);
                sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
            } else {
                DBError.check_error(59, object);
            }
        }
        return sTRUCT;
    }

    public Object toJdbc() throws SQLException {
        Map map = this.getMap();
        Object object = this.toJdbc(map);
        return object;
    }

    public Object toJdbc(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.m_descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object toClass(Class clazz) throws SQLException {
        Object object = this.toClass(clazz, this.getMap());
        return object;
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        Object object = null;
        try {
            if (clazz == null || clazz == (class$oracle$sql$STRUCT == null ? (class$oracle$sql$STRUCT = STRUCT.class$("oracle.sql.STRUCT")) : class$oracle$sql$STRUCT) || clazz == (class$java$sql$Struct == null ? (class$java$sql$Struct = STRUCT.class$("java.sql.Struct")) : class$java$sql$Struct)) {
                object = this;
            } else {
                Object t = clazz.newInstance();
                if (t instanceof SQLData) {
                    ((SQLData)t).readSQL(this.m_descriptor.toJdbc2SQLInput(this, map), this.m_descriptor.getName());
                    object = t;
                } else if (t instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)t;
                    object = oRADataFactory.create(this, 2002);
                } else if (t instanceof CustomDatumFactory) {
                    CustomDatumFactory customDatumFactory = (CustomDatumFactory)t;
                    object = customDatumFactory.create(this, 2002);
                } else {
                    DBError.throwSqlException(49, this.m_descriptor.getName());
                }
            }
        }
        catch (InstantiationException instantiationException) {
            DBError.throwSqlException(49, "InstantiationException: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            DBError.throwSqlException(49, "IllegalAccessException: " + illegalAccessException.getMessage());
        }
        return object;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n) {
        return new Object[n];
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.m_enableLocalCache = bl;
    }

    public synchronized boolean getAutoBuffering() throws SQLException {
        return this.m_enableLocalCache;
    }

    public void setImage(byte[] byArray, long l, long l2) throws SQLException {
        this.setShareBytes(byArray);
        this.m_imgOffset = l;
        this.m_imgLength = l2;
    }

    public void setImageLength(long l) throws SQLException {
        this.m_imgLength = l;
    }

    public long getImageOffset() {
        return this.m_imgOffset;
    }

    public long getImageLength() {
        return this.m_imgLength;
    }

    public CustomDatumFactory getFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            throw new SQLException("Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
        }
        CustomDatumFactory customDatumFactory = (CustomDatumFactory)v;
        return customDatumFactory;
    }

    public ORADataFactory getORADataFactory(Hashtable hashtable, String string) throws SQLException {
        String string2 = this.getSQLTypeName();
        Object v = hashtable.get(string2);
        if (v == null) {
            throw new SQLException("Unable to convert a \"" + string2 + "\" to a \"" + string + "\" or a subclass of \"" + string + "\"");
        }
        ORADataFactory oRADataFactory = (ORADataFactory)v;
        return oRADataFactory;
    }

    public String debugString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        try {
            StructDescriptor structDescriptor = this.getDescriptor();
            stringWriter.write("name = " + structDescriptor.getName());
            int n = structDescriptor.getLength();
            stringWriter.write(" length = " + n);
            Object[] objectArray = this.getAttributes();
            int n2 = 0;
            while (n2 < n) {
                stringWriter.write(" attribute[" + n2 + "] = " + objectArray[n2]);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            string = "StructDescriptor missing or bad";
        }
        string = stringWriter.toString();
        return string;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        boolean bl = this.getDescriptor().isInHierarchyOf(string);
        return bl;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

