/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter12Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final int BELOW_CJK = 12287;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public int[] m_oraCharLevel1 = null;
    public int[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    static final short MAX_7BIT = 127;
    protected static int MAXLIMIT = 42000;

    public CharacterConverter12Byte() {
        this.m_groupId = 1;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        char[] cArray;
        Object object;
        int n5;
        int n6;
        Enumeration enumeration;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < 256) {
            this.m_oraCharLevel1[n9] = -1;
            ++n9;
        }
        int n10 = 0;
        while (n10 < 65535) {
            try {
                int n11 = this.toUnicode(n10);
                enumeration = (Enumeration)new int[2];
                enumeration[0] = n11;
                enumeration[1] = n10;
                vector.addElement(enumeration);
                this.storeMappingRange(n11, hashtable, hashtable2);
            }
            catch (SQLException sQLException) {}
            ++n10;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n6 = this.extraUnicodeToOracleMapping.length;
            int n12 = 0;
            while (n12 < n6) {
                n5 = this.extraUnicodeToOracleMapping[n12][0];
                this.storeMappingRange(n5, hashtable, hashtable2);
                ++n12;
            }
        }
        enumeration = hashtable.keys();
        int n13 = 0;
        int n14 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n13 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n14 += 256;
        }
        if (n13 != 0) {
            this.m_oraCharSurrogateLevel = new int[n13];
        }
        if (n14 != 0) {
            this.m_oraCharLevel2 = new char[n14];
        }
        int n15 = 0;
        while (n15 < n13) {
            this.m_oraCharSurrogateLevel[n15] = -1;
            ++n15;
        }
        int n16 = 0;
        while (n16 < n14) {
            this.m_oraCharLevel2[n16] = 65535;
            ++n16;
        }
        int n17 = 0;
        while (n17 < vector.size()) {
            int[] nArray = (int[])vector.elementAt(n17);
            n4 = nArray[0] >> 24 & 0xFF;
            n3 = nArray[0] >> 16 & 0xFF;
            n2 = nArray[0] >> 8 & 0xFF;
            n = nArray[0] & 0xFF;
            if (n4 >= 216 && n4 < 220) {
                if (this.m_oraCharLevel1[n4] == -1) {
                    this.m_oraCharLevel1[n4] = n8;
                    n8 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] = n8;
                    n8 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] = n7;
                    n7 += 256;
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] = (char)(nArray[1] & 0xFFFF);
                }
            } else {
                if (this.m_oraCharLevel1[n2] == -1) {
                    this.m_oraCharLevel1[n2] = n7;
                    n7 += 256;
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] = (char)(nArray[1] & 0xFFFF);
                }
            }
            ++n17;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n6 = this.extraUnicodeToOracleMapping.length;
            int n18 = 0;
            while (n18 < n6) {
                n5 = this.extraUnicodeToOracleMapping[n18][0];
                n4 = n5 >>> 24 & 0xFF;
                n3 = n5 >>> 16 & 0xFF;
                n2 = n5 >>> 8 & 0xFF;
                n = n5 & 0xFF;
                if (n4 >= 216 && n4 < 220) {
                    if (this.m_oraCharLevel1[n4] == -1) {
                        this.m_oraCharLevel1[n4] = n8;
                        n8 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] = n8;
                        n8 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] = n7;
                        n7 += 256;
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] = (char)(this.extraUnicodeToOracleMapping[n18][1] & 0xFFFF);
                } else {
                    if (this.m_oraCharLevel1[n2] == -1) {
                        this.m_oraCharLevel1[n2] = n7;
                        n7 += 256;
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] = (char)(this.extraUnicodeToOracleMapping[n18][1] & 0xFFFF);
                }
                ++n18;
            }
        }
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 65535;
        int n3 = n;
        while (n3 <= n2) {
            try {
                int[] nArray = new int[]{n3, this.toUnicode(n3)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n3;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n = 0;
        while (n < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n][0], this.extraUnicodeToOracleMapping[n][1]};
            vector.addElement(nArray);
            ++n;
        }
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    char toOracleCharacter(char c, char c2) throws SQLException {
        char c3 = '\uffff';
        if (c2 != '\u0000') {
            int n = c >>> 8 & 0xFF;
            int n2 = c & 0xFF;
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4];
            }
        } else {
            int n = c >>> 8 & 0xFF;
            int n5 = c & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5];
            }
        }
        if (c3 == '\uffff') {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return c3;
    }

    char toOracleCharacterWithReplacement(char c, char c2) {
        char c3 = '\uffff';
        if (c2 != '\u0000') {
            int n = c >>> 8 & 0xFF;
            int n2 = c & 0xFF;
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4];
            }
        } else {
            int n = c >>> 8 & 0xFF;
            int n5 = c & 0xFF;
            if (this.m_oraCharLevel1[n] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5] != '\uffff') {
                c3 = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n5];
            }
        }
        if (c3 == '\uffff') {
            if (c > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c;
            if (cArray[n3] >= '\ud800' && cArray[n3] < '\udc00') {
                if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c = this.toOracleCharacterWithReplacement(cArray[n3], cArray[n3 + 1]);
                ++n3;
            } else {
                c = this.toOracleCharacter(cArray[n3], '\u0000');
            }
            if (c >> 8 != 0) {
                byArray[n2++] = (byte)(c >> 8);
                byArray[n2++] = (byte)c;
            } else {
                byArray[n2++] = (byte)c;
            }
            ++n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 65535;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            block8: {
                block7: {
                    block5: {
                        block6: {
                            if (cArray[n4] < '\ud800' || cArray[n4] >= '\udc00') break block5;
                            if (n4 + 1 >= n || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') break block6;
                            n2 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                            ++n4;
                            break block7;
                        }
                        byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                        break block8;
                    }
                    n2 = this.toOracleCharacterWithReplacement(cArray[n4], '\u0000');
                }
                if (n2 >> 8 != 0) {
                    byArray[n3++] = (byte)(n2 >> 8);
                    byArray[n3++] = (byte)n2;
                } else {
                    byArray[n3++] = (byte)n2;
                }
            }
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    int toUnicode(int n) throws SQLException {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        if (this.m_ucsCharLevel1[n2] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] == -1) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n4 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3];
        return n4;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5;
            int n6 = byArray[n4] & 0xFF;
            if (n6 > 127) {
                if (n4 < n3 - 1) {
                    n6 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                    ++n4;
                } else {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
            }
            if (((long)(n5 = this.toUnicode(n6)) & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n5 >>> 16));
                stringBuffer.append((char)(n5 & 0xFFFF));
            } else {
                stringBuffer.append((char)n5);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5;
            int n6 = byArray[n4] & 0xFF;
            if (n6 > 127) {
                if (n3 - n4 < 2) break;
                n6 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                ++n4;
            }
            if (((long)(n5 = this.toUnicodeWithReplacement(n6)) & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n5 >>> 16));
                stringBuffer.append((char)(n5 & 0xFFFF));
            } else {
                stringBuffer.append((char)n5);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    int toUnicodeWithReplacement(int n) {
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = this.m_ucsCharLevel1[n2] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] : this.m_ucsCharReplacement;
        return n4;
    }
}

