/*
 * Decompiled with CFR 0.152.
 */
package de.prima.shire.anttex;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.FileSet;

public class LaTeX
extends Task {
    private String latexfile = null;
    private String bibtexfile = null;
    private File latexdir = null;
    private boolean verbose = true;
    private boolean bibtex = false;
    private boolean pdftex = false;
    private boolean clean = false;
    private Delete delete = null;
    private final String[] deletePatterns = new String[]{"*.aux", "*.log", "*.toc", "*.lof", "*.lot", "*.bbl", "*.blg", ".out"};

    public void init() {
        this.latexdir = this.project.getBaseDir();
        this.delete = this.createDefaultDelete();
    }

    public void setLatexfile(String string) {
        this.latexfile = string;
        this.bibtexfile = this.latexfile.substring(0, this.latexfile.lastIndexOf(".tex"));
    }

    public void setDirectory(File file) {
        this.latexdir = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setBibtex(boolean bl) {
        this.bibtex = bl;
    }

    public void setPdftex(boolean bl) {
        this.pdftex = bl;
    }

    public void setClean(boolean bl) {
        this.clean = bl;
    }

    public void execute() throws BuildException {
        if (this.verbose) {
            this.log("Running LaTeX now!");
            this.dump();
        }
        int n = 0;
        n = this.runLaTeX();
        if (this.bibtex) {
            this.runBIBTeX();
        }
        this.runLaTeX();
        this.runLaTeX();
        if (this.verbose) {
            this.log("run Delete");
        }
        this.delete.execute();
    }

    public Object createDelete() {
        this.log("Delete is created");
        this.delete = (Delete)this.project.createTask("delete");
        return this.delete;
    }

    private Delete createDefaultDelete() {
        Delete delete = null;
        this.log("Delete is not set: Use default-values!");
        delete = (Delete)this.project.createTask("delete");
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.latexdir);
        int n = 0;
        while (n < this.deletePatterns.length) {
            fileSet.createInclude().setName(this.deletePatterns[n]);
            ++n;
        }
        delete.addFileset(fileSet);
        delete.setVerbose(true);
        return delete;
    }

    private final int runLaTeX() throws BuildException {
        String string = "latex";
        if (this.pdftex) {
            string = "pdflatex";
        }
        String[] stringArray = new String[]{string, " &" + string + " \\nonstopmode\\input{" + this.latexfile + "}"};
        return this.runCommand(stringArray);
    }

    private final int runBIBTeX() throws BuildException {
        String[] stringArray = new String[]{"bibtex", this.bibtexfile};
        return this.runCommand(stringArray);
    }

    private final int runCommand(String[] stringArray) throws BuildException {
        String string;
        int n = 0;
        if (this.verbose) {
            string = "";
            int n2 = 0;
            while (n2 < stringArray.length) {
                string = string + stringArray[n2];
                ++n2;
            }
            this.log("running command: " + string);
        }
        try {
            string = null;
            string = this.verbose ? new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null) : new Execute((ExecuteStreamHandler)new SilentStreamHandler());
            string.setWorkingDirectory(this.latexdir);
            string.setCommandline(stringArray);
            string.setAntRun(this.project);
            n = string.execute();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        if (this.verbose) {
            this.log("command exitcode = " + n);
        }
        return n;
    }

    private void cleanIntermediateFiles() {
        String[] stringArray = new String[]{"aux", "log", "bbl", "blg", "toc", "lof", "lot"};
    }

    private void dump() {
        this.log("latexfile  = " + this.latexfile);
        this.log("bibtexfile = " + this.latexfile);
        this.log("latexdir   = " + this.latexdir);
        this.log("verbose    = " + this.verbose);
        this.log("bibtex     = " + this.bibtex);
        this.log("bibtex     = " + this.bibtex);
        this.log("clean      = " + this.clean);
        this.log("delete     = " + this.delete);
    }

    class SilentStreamHandler
    implements ExecuteStreamHandler {
        SilentStreamHandler() {
        }

        public void setProcessErrorStream(InputStream inputStream) {
        }

        public void setProcessInputStream(OutputStream outputStream) {
        }

        public void setProcessOutputStream(InputStream inputStream) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

