/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.fault;

import java.util.HashMap;

public class FaultDescription {
    private String id;
    private static HashMap table = new HashMap();
    public static final FaultDescription UNKNOWN_USER = new FaultDescription("The user name or password is invalid.");
    public static final FaultDescription QUERY = new FaultDescription("The supplied database logic failed.");
    public static final FaultDescription TRANSACTION_ID = new FaultDescription("A transaction Id could not be found.");
    public static final FaultDescription UNKNOWN_METHOD = new FaultDescription("The requested method is not supported.");
    public static final FaultDescription TOKEN_EXPIRED = new FaultDescription("The security token has expired.");
    public static final FaultDescription FILE_NOT_FOUND = new FaultDescription("The requested file could not be located.");
    public static final FaultDescription VALIDATION_FAILED = new FaultDescription("Validation error.");
    public static final FaultDescription SERVER_BUSY = new FaultDescription("The service is too busy to handle the request at this time.");
    public static final FaultDescription SERVICE_UNAVAILABLE = new FaultDescription("Service unavailable.");
    public static final FaultDescription VERSION_MISSMATCH = new FaultDescription("The request is a different version of the protocol.");
    public static final FaultDescription ACCESS_DENIED = new FaultDescription("The operation could not be performed due to lack of privilege.");
    public static final FaultDescription FEATURE_UNSUPPORTED = new FaultDescription("The requested feature is not supported.");
    public static final FaultDescription INVALID_TOKEN = new FaultDescription("Security token is invalid.");
    public static final FaultDescription ROW_ID_OUT_OF_RANGE = new FaultDescription("The rowID parameter is out of range.");
    public static final FaultDescription INVALID_FILE_NAME = new FaultDescription("The name element in the nodeDocument structure is invalid.");
    public static final FaultDescription INVALID_FILE_TYPE = new FaultDescription("The type element in the nodeDocument structure is invalid or not supported.");
    public static final FaultDescription INVALID_DATAFLOW = new FaultDescription("The dataflow element in the request message is not supported.");
    public static final FaultDescription INTERNAL_ERROR = new FaultDescription("An unrecoverable error occured during processing the request.");
    private static final FaultDescription[] faultDescriptions = new FaultDescription[]{UNKNOWN_USER, QUERY, TRANSACTION_ID, UNKNOWN_METHOD, TOKEN_EXPIRED, FILE_NOT_FOUND, VALIDATION_FAILED, SERVER_BUSY, SERVICE_UNAVAILABLE, VERSION_MISSMATCH, ACCESS_DENIED, FEATURE_UNSUPPORTED, INVALID_TOKEN, ROW_ID_OUT_OF_RANGE, INVALID_FILE_NAME, INVALID_FILE_TYPE, INVALID_DATAFLOW, INTERNAL_ERROR};

    public static FaultDescription[] getFaultDescriptions() {
        return faultDescriptions;
    }

    private FaultDescription(String anID) {
        this.id = anID;
        table.put(anID, this);
    }

    public static FaultDescription fromString(String value) {
        return (FaultDescription)table.get(value);
    }

    public String toString() {
        return this.id;
    }
}

