/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.fault;

import gov.epa.cdx.axis.fault.FaultDescription;
import gov.epa.cdx.axis.fault.FaultErrorCode;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FaultHandler {
    protected static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$fault$FaultHandler == null ? (class$gov$epa$cdx$axis$fault$FaultHandler = FaultHandler.class$("gov.epa.cdx.axis.fault.FaultHandler")) : class$gov$epa$cdx$axis$fault$FaultHandler).getName());
    private static final String FAULT_CODE = "soapenv:";
    private static final String FAULT_ACTOR = "cdx.wsdl";
    private static final String FAULT_DETAILS = "faultdetail";
    private static final String FAULT_ERROR_CODE = "errorcode";
    private static final String FAULT_DESCRIPTION = "description";
    private static Document document;
    private static HashMap errorsDescriptions;
    private static HashMap errorCodeMap;
    static /* synthetic */ Class class$gov$epa$cdx$axis$fault$FaultHandler;

    private static void createErrorsDescriptions() {
        errorsDescriptions = new HashMap();
        for (int i = 0; i < FaultErrorCode.getFaultErrorCodes().length; ++i) {
            FaultErrorCode faultErrorCode = FaultErrorCode.getFaultErrorCodes()[i];
            FaultDescription faultDescription = FaultDescription.getFaultDescriptions()[i];
            errorsDescriptions.put(faultErrorCode, faultDescription);
        }
    }

    private static void createErrorMap() {
        errorCodeMap = new HashMap();
        errorCodeMap.put(CDXErrorCode.INTERNAL_SERVER_ERROR, FaultErrorCode.INTERNAL_ERROR);
        errorCodeMap.put(CDXErrorCode.DATABASE_FAILURE, FaultErrorCode.QUERY);
        errorCodeMap.put(CDXErrorCode.VALIDATION_ERROR, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.VERSION_ERROR, FaultErrorCode.VERSION_MISSMATCH);
        errorCodeMap.put(CDXErrorCode.EXTERNAL_SERVER_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.RUNTIME_ERROR, FaultErrorCode.INTERNAL_ERROR);
        errorCodeMap.put(CDXErrorCode.PROPERTY_EXCEPTION, FaultErrorCode.INTERNAL_ERROR);
        errorCodeMap.put(CDXErrorCode.HTTP_CONNECTION_FAILURE, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.HTTP_URL_BIND_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.HTTP_URL_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR, FaultErrorCode.UNKNOWN_USER);
        errorCodeMap.put(CDXErrorCode.INVALID_USER_OR_PASSWORD, FaultErrorCode.UNKNOWN_USER);
        errorCodeMap.put(CDXErrorCode.INVALID_USER_OR_NOT_ADMINISTRATOR, FaultErrorCode.UNKNOWN_USER);
        errorCodeMap.put(CDXErrorCode.CONFIRM_PASSWORD_ERROR, FaultErrorCode.UNKNOWN_USER);
        errorCodeMap.put(CDXErrorCode.SECURITY_TOKEN_EXPIRED, FaultErrorCode.TOKEN_EXPIRED);
        errorCodeMap.put(CDXErrorCode.SECURITY_TOKEN_INVALID, FaultErrorCode.INVALID_TOKEN);
        errorCodeMap.put(CDXErrorCode.SECURITY_ACCESS_DENIED, FaultErrorCode.ACCESS_DENIED);
        errorCodeMap.put(CDXErrorCode.LACK_OF_PRIVILEGE, FaultErrorCode.ACCESS_DENIED);
        errorCodeMap.put(CDXErrorCode.SECURITY_WRONG_AUTH_METHOD, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.NO_STATE_AFFILIATION, FaultErrorCode.INVALID_FILE_NAME);
        errorCodeMap.put(CDXErrorCode.NO_LEGACY_ID, FaultErrorCode.UNKNOWN_USER);
        errorCodeMap.put(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT, FaultErrorCode.TRANSACTION_ID);
        errorCodeMap.put(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT_RETRIEVAL, FaultErrorCode.TRANSACTION_ID);
        errorCodeMap.put(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT_STORAGE, FaultErrorCode.TRANSACTION_ID);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_NAME_IS_NOT_SPECIFIED, FaultErrorCode.INVALID_FILE_NAME);
        errorCodeMap.put(CDXErrorCode.DUPLICATE_DOCUMENT_NAMES, FaultErrorCode.INVALID_FILE_NAME);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_NAME_INVALID, FaultErrorCode.INVALID_FILE_NAME);
        errorCodeMap.put(CDXErrorCode.DATA_FLOW_TYPE_MISSMATCH, FaultErrorCode.INVALID_DATAFLOW);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_TYPE_MISSMATCH, FaultErrorCode.INVALID_FILE_TYPE);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_TYPE_AND_DATA_FLOW_TYPE_MISSMATCH, FaultErrorCode.INVALID_FILE_TYPE);
        errorCodeMap.put(CDXErrorCode.INVALID_DOCUMENT_ID, FaultErrorCode.INVALID_FILE_NAME);
        errorCodeMap.put(CDXErrorCode.INVALID_DOCUMENT_TYPE, FaultErrorCode.INVALID_FILE_TYPE);
        errorCodeMap.put(CDXErrorCode.INVALID_DOCUMENT_SIZE, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_ZERO_BYTE_SIZE, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.INVALID_DOCUMENT_HEADER, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.INVALID_NUMBER_OF_DOCUMENTS, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.DOCUMENT_HEADER_IS_REQUIRED, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.INVLALID_NUMBER_OF_PAYLOADS, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.INVALID_PAYLOAD_OPERATION_TYPE, FaultErrorCode.VALIDATION_FAILED);
        errorCodeMap.put(CDXErrorCode.REQUESTOR_DOWNLOAD_SERVICE_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.REQUESTOR_QUERY_SERVICE_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.REQUESTOR_SUBMIT_SERVICE_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.REQUESTOR_NOTIFY_SERVICE_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.REQUESTOR_WRONG_TYPE_ERROR, FaultErrorCode.SERVICE_UNAVAILABLE);
        errorCodeMap.put(CDXErrorCode.INVALID_TRANSACTION_ID, FaultErrorCode.TRANSACTION_ID);
        errorCodeMap.put(CDXErrorCode.INVALID_SERVICE_REQUEST_NAME, FaultErrorCode.INTERNAL_ERROR);
        errorCodeMap.put(CDXErrorCode.FILE_TOO_LARGE_FOR_SYNCH_QUERY_ERROR, FaultErrorCode.INTERNAL_ERROR);
        errorCodeMap.put(CDXErrorCode.INVALID_QUERY_PARAMETERS_ERROR, FaultErrorCode.INTERNAL_ERROR);
        errorCodeMap.put(CDXErrorCode.FEATURE_UNSUPPORTED, FaultErrorCode.FEATURE_UNSUPPORTED);
    }

    private FaultHandler() {
    }

    public static FaultErrorCode CDXErrorCodeToFaultErrorCode(CDXErrorCode cdxErrorCode) {
        FaultErrorCode faultErrorCode = (FaultErrorCode)errorCodeMap.get(cdxErrorCode);
        if (faultErrorCode == null) {
            faultErrorCode = FaultErrorCode.INTERNAL_ERROR;
        }
        return faultErrorCode;
    }

    public static AxisFault exceptionToAxisFault(Exception exception) {
        AxisFault fault = null;
        if (exception instanceof CDXException) {
            CDXException cdxException = (CDXException)exception;
            CDXErrorCode cdxErrorCode = cdxException.getCDXErrorCode();
            FaultErrorCode faultErrorCode = FaultHandler.CDXErrorCodeToFaultErrorCode(cdxErrorCode);
            fault = FaultHandler.getFault("Client", cdxErrorCode.getErrorDescription(), faultErrorCode);
        } else {
            fault = FaultHandler.genericExceptionToAxisFault(exception);
        }
        return fault;
    }

    private static AxisFault genericExceptionToAxisFault(Exception exception) {
        FaultErrorCode faultErrorCode = FaultHandler.CDXErrorCodeToFaultErrorCode(CDXErrorCode.INTERNAL_SERVER_ERROR);
        AxisFault fault = FaultHandler.getFault("Server", exception.getMessage(), faultErrorCode);
        return fault;
    }

    public static AxisFault getFault(String faultCodeString, String faultString, FaultErrorCode faultErrorCode) {
        AxisFault fault = new AxisFault();
        StringBuffer faultCode = new StringBuffer(FAULT_CODE);
        faultCode.append(faultCodeString);
        QName qCode = new QName("", new String(faultCode));
        fault.setFaultCode(qCode);
        fault.setFaultString(faultString);
        fault.setFaultActor(FAULT_ACTOR);
        Element faultDetails = document.createElement(FAULT_DETAILS);
        Element errorCode = document.createElement(FAULT_ERROR_CODE);
        errorCode.appendChild(document.createTextNode(faultErrorCode.toString()));
        faultDetails.appendChild(errorCode);
        Element description = document.createElement(FAULT_DESCRIPTION);
        String descriptionString = ((FaultDescription)errorsDescriptions.get(faultErrorCode)).toString();
        description.appendChild(document.createTextNode(descriptionString));
        faultDetails.appendChild(description);
        Element[] elements = new Element[]{faultDetails};
        fault.setFaultDetail(elements);
        return fault;
    }

    public static FaultErrorCode getErrorCode(RemoteException exception) throws CDXException {
        FaultErrorCode faultErrorCode = null;
        AxisFault fault = AxisFault.makeFault((Exception)exception);
        Element[] details = fault.getFaultDetails();
        if (details == null) {
            throw new CDXValidationException(CDXErrorCode.INTERNAL_SERVER_ERROR);
        }
        NodeList nodes = details[0].getChildNodes();
        boolean found = false;
        for (int i = 0; i < nodes.getLength() && !found; ++i) {
            Text textNode;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (faultErrorCode = FaultErrorCode.fromString((textNode = (Text)node.getFirstChild()).getData())) == null) continue;
            found = true;
        }
        if (!found) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)new Exception("Invalid Error Code Passed by the Server"));
        }
        return faultErrorCode;
    }

    public static String getFaultCode(Exception exception) throws Exception {
        AxisFault fault = AxisFault.makeFault((Exception)exception);
        QName faultCode = fault.getFaultCode();
        if (faultCode == null) {
            throw new Exception("Fault Code is Not Passed By the Server");
        }
        return faultCode.toString();
    }

    public static String getFaultString(Exception exception) {
        AxisFault fault = AxisFault.makeFault((Exception)exception);
        String faultString = fault.getFaultString();
        return faultString;
    }

    public static String getFaultActor(Exception exception) throws Exception {
        AxisFault fault = AxisFault.makeFault((Exception)exception);
        String faultActor = fault.getFaultActor();
        if (faultActor == null) {
            throw new Exception("Fault Actor is Not Passed By the Server");
        }
        return faultActor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FaultHandler.createErrorsDescriptions();
        FaultHandler.createErrorMap();
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }
}

