/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.policymgr.client;

import gov.epa.cdx.axis.policymgr.client.AuthorizationPolicyLocator;
import gov.epa.cdx.axis.policymgr.client.NetworkPolicyBindingStub;
import gov.epa.cdx.axis.policymgr.enum.ActionType;
import gov.epa.cdx.axis.policymgr.enum.MethodName;
import gov.epa.cdx.axis.policymgr.enum.NodeId;
import gov.epa.cdx.axis.policymgr.vo.PasswordType;
import gov.epa.cdx.axis.policymgr.vo.PolicyInfo;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.RemoteException;

public class PolicymgrRequestor {
    private URL url;
    private static int TIMEOUT = 1200000;

    private PolicymgrRequestor() {
    }

    public PolicymgrRequestor(URL url) {
        this.url = url;
    }

    private NetworkPolicyBindingStub getStub() throws RemoteException {
        AuthorizationPolicyLocator locator = new AuthorizationPolicyLocator();
        NetworkPolicyBindingStub stub = new NetworkPolicyBindingStub(this.url, locator);
        stub.setTimeout(TIMEOUT);
        return stub;
    }

    public String setPolicy(String adminAccount, String adminPwd, String userEmail, String methodName, String serviceRequest, String serviceRequestParms, String authorizationAction) throws RemoteException {
        NetworkPolicyBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        String result = port.setPolicy(adminAccount, adminPassword, userEmail, MethodName.fromString(methodName), serviceRequest, serviceRequestParms, ActionType.fromString(authorizationAction));
        return result;
    }

    public String deletePolicy(String adminAccount, String adminPwd, String userEmail, String methodName, String serviceRequest, String serviceRequestParms) throws RemoteException {
        NetworkPolicyBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        String result = port.deletePolicy(adminAccount, adminPassword, userEmail, MethodName.fromString(methodName), serviceRequest, serviceRequestParms);
        return result;
    }

    public PolicyInfo[] getPolicyList(String adminAccount, String adminPwd, String userEmail, BigInteger rowId, BigInteger maxRows) throws RemoteException {
        NetworkPolicyBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        PolicyInfo[] result = null;
        if (CDXPropertyManager.getProperty((String)"TestOnly", (String)"internet_available", (String)"yes").toString().compareToIgnoreCase("no") == 0) {
            result = new PolicyInfo[3];
            result[0] = new PolicyInfo();
            result[0].setAction("Deny");
            result[0].setNode("CDX");
            result[0].setMethod("Submit");
            result[0].setParams("any");
            result[0].setPolicyId(BigInteger.valueOf(0L).toString());
            result[0].setRequest("any");
            result[0].setSubject(userEmail);
            result[1] = new PolicyInfo();
            result[1].setAction("Permit");
            result[1].setNode("CDX");
            result[1].setMethod("Download");
            result[1].setParams("any");
            result[1].setPolicyId(BigInteger.valueOf(1L).toString());
            result[1].setRequest("any");
            result[1].setSubject(userEmail);
            result[2] = new PolicyInfo();
            result[2].setAction("Permit");
            result[2].setNode("CDX");
            result[2].setMethod("GetServices");
            result[2].setParams("any");
            result[2].setPolicyId(BigInteger.valueOf(2L).toString());
            result[2].setRequest("any");
            result[2].setSubject(userEmail);
        } else {
            result = port.getPolicyList(adminAccount, adminPassword, userEmail, rowId, maxRows);
        }
        return result;
    }

    public PolicyInfo[] getListOfSecurityEvents(String adminAccount, String adminPwd, String userEmail, BigInteger rowId, BigInteger maxRows) throws RemoteException {
        NetworkPolicyBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        PolicyInfo[] result = port.getAuthEvents(adminAccount, adminPassword, userEmail, rowId, maxRows);
        return result;
    }

    public String verifyPolicy(String userEmail, String node, String methodName, String serviceRequest, String serviceRequestParms) throws RemoteException {
        NetworkPolicyBindingStub port = this.getStub();
        String result = port.verifyPolicy(userEmail, NodeId.fromString(node), MethodName.fromString(methodName), serviceRequest, serviceRequestParms);
        return result;
    }
}

