/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.trust.client;

import gov.epa.cdx.axis.trust.client.SecurityTokenBindingStub;
import gov.epa.cdx.axis.trust.client.SecurityTokenLocator;
import gov.epa.cdx.axis.trust.types.AuthMethod;
import gov.epa.cdx.axis.trust.types.PasswordType;
import gov.epa.cdx.axis.trust.types.TokenType;
import java.net.URL;
import java.rmi.RemoteException;

public class SecurityTokenRequestor {
    private URL url = null;

    public SecurityTokenRequestor() {
    }

    public SecurityTokenRequestor(URL url) {
        this.url = url;
    }

    private SecurityTokenBindingStub getStub() throws RemoteException {
        SecurityTokenLocator locator = new SecurityTokenLocator();
        SecurityTokenBindingStub stub = new SecurityTokenBindingStub(this.url, locator);
        return stub;
    }

    public String createSecurityToken(String trustee, String password, String tokenType, String issuer, String authMethod, String subject, String subjectData, String clientIP) throws RemoteException {
        SecurityTokenBindingStub port = this.getStub();
        PasswordType pwd = new PasswordType(password);
        AuthMethod am = AuthMethod.fromString(authMethod);
        TokenType tt = TokenType.fromString(tokenType);
        return port.createSecurityToken(trustee, pwd, tt, issuer, am, subject, subjectData, clientIP);
    }

    public String validate(String authToken, String clientHost, String resourceURI) throws RemoteException {
        SecurityTokenBindingStub port = this.getStub();
        return port.validate(authToken, clientHost, resourceURI);
    }
}

