/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.trust.test;

import gov.epa.cdx.axis.trust.client.SecurityTokenBindingStub;
import gov.epa.cdx.axis.trust.client.SecurityTokenLocator;
import gov.epa.cdx.axis.trust.types.AuthMethod;
import gov.epa.cdx.axis.trust.types.PasswordType;
import gov.epa.cdx.axis.trust.types.TokenType;
import javax.xml.rpc.ServiceException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class SecurityTokenTestCase
extends TestCase {
    public SecurityTokenTestCase(String name) {
        super(name);
    }

    public void test1SecurityTokenPortTypeCreateSecurityToken() throws Exception {
        SecurityTokenBindingStub binding;
        try {
            binding = (SecurityTokenBindingStub)new SecurityTokenLocator().getSecurityTokenPortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        SecurityTokenTestCase.assertNotNull((String)"binding is null", (Object)binding);
        binding.setTimeout(60000);
        String value = null;
        String trustee = "epacdxnode@csc.com";
        PasswordType pwd = new PasswordType("nodeone");
        String issuer = "CDX/Web";
        String subject = "dbroydo@csc.com";
        String subjectData = "role=operator,admin&name=Denis M Broydo";
        String ip = "20.4.58.32";
        value = binding.createSecurityToken(trustee, pwd, TokenType.csm, issuer, AuthMethod.password, subject, subjectData, ip);
        System.out.println("value = " + value);
        this.test2SecurityTokenPortTypeValidate(value, ip);
    }

    private void test2SecurityTokenPortTypeValidate(String sToken, String ip) throws Exception {
        SecurityTokenBindingStub binding;
        try {
            binding = (SecurityTokenBindingStub)new SecurityTokenLocator().getSecurityTokenPortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        SecurityTokenTestCase.assertNotNull((String)"binding is null", (Object)binding);
        binding.setTimeout(60000);
        String value = null;
        value = binding.validate(sToken, ip, new String());
        System.out.println("is valid = " + value);
    }
}

