/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.usermgr.client;

import gov.epa.cdx.axis.usermgr.client.UserMgrBindingStub;
import gov.epa.cdx.axis.usermgr.client.UsermgrLocator;
import gov.epa.cdx.axis.usermgr.enum.StateId;
import gov.epa.cdx.axis.usermgr.enum.UserType;
import gov.epa.cdx.axis.usermgr.vo.PasswordType;
import gov.epa.cdx.axis.usermgr.vo.UserInfo;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.RemoteException;

public class UsermgrRequestor {
    private URL url;
    private static int TIMEOUT = 1200000;

    private UsermgrRequestor() {
    }

    public UsermgrRequestor(URL url) {
        this.url = url;
    }

    private UserMgrBindingStub getStub() throws RemoteException {
        UsermgrLocator locator = new UsermgrLocator();
        UserMgrBindingStub stub = new UserMgrBindingStub(this.url, locator);
        stub.setTimeout(TIMEOUT);
        return stub;
    }

    public String addUser(String adminAccount, String adminPwd, String userEmail, String userType, String userPwd, String confirmUserPwd, String userState) throws RemoteException {
        UserMgrBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        PasswordType userPassword = new PasswordType(userPwd);
        PasswordType userConfirmedPassword = new PasswordType(confirmUserPwd);
        String result = port.addUser(adminAccount, adminPassword, userEmail, UserType.fromString(userType), userPassword, userConfirmedPassword, StateId.fromString(userState));
        return result;
    }

    public String updateUser(String adminAccount, String adminPwd, String userEmail, String userType, String userPwd, String userOwner, String userState) throws RemoteException {
        UserMgrBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        PasswordType userPassword = new PasswordType(userPwd);
        String result = port.updateUser(adminAccount, adminPassword, userEmail, UserType.fromString(userType), userPassword, userOwner, StateId.fromString(userState));
        return result;
    }

    public String deleteUser(String adminName, String adminPwd, String userEmail) throws RemoteException {
        UserMgrBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        String result = port.deleteUser(adminName, adminPassword, userEmail);
        return result;
    }

    public UserInfo[] getUserList(String adminName, String adminPwd, String userEmail, String userState, BigInteger rowId, BigInteger maxRows) throws RemoteException {
        UserMgrBindingStub port = this.getStub();
        PasswordType adminPassword = new PasswordType(adminPwd);
        UserInfo[] result = null;
        if (CDXPropertyManager.getProperty((String)"TestOnly", (String)"internet_available", (String)"yes").toString().compareToIgnoreCase("no") == 0) {
            result = new UserInfo[100];
            for (int i = 0; i < 100; ++i) {
                result[i] = new UserInfo();
                result[i].setAffiliate("MD");
                result[i].setNode("CDX");
                result[i].setOwner("epacdxnode@csc.com");
                result[i].setUserGroup("u");
                result[i].setUserId("gtamkin" + BigInteger.valueOf(i).toString() + "@csc.com");
            }
        } else {
            result = port.getUserList(adminName, adminPassword, userEmail, StateId.fromString(userState), rowId, maxRows);
        }
        return result;
    }

    public String changePwd(String userEmail, String pwd, String newPwd) throws RemoteException {
        UserMgrBindingStub port = this.getStub();
        PasswordType password = new PasswordType(pwd);
        PasswordType newPassword = new PasswordType(newPwd);
        String result = port.changePwd(userEmail, password, newPassword);
        return result;
    }
}

