/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.usermgr.client;

import gov.epa.cdx.axis.legacymgr.client.LegacymgrRequestor;
import gov.epa.cdx.axis.policymgr.client.PolicymgrRequestor;
import gov.epa.cdx.axis.policymgr.vo.PolicyInfo;
import gov.epa.cdx.axis.usermgr.client.UsermgrRequestor;
import gov.epa.cdx.axis.usermgr.vo.UserInfo;
import java.math.BigInteger;
import java.net.URL;
import junit.framework.TestCase;

public class UsermgrRequestorTest
extends TestCase {
    public static String userEmail = "gtamkin@test.com";
    public static String userPwd = "testpwd";
    public static String otherUserPwd = "otherpwd";
    public static String userType = "user";
    public static String userState = "MD";
    public static String otherUserState = "VA";
    public static String methodName = "Any";
    public static String serviceRequest = "";
    public static String serviceRequestParms = "";
    public static String action = "Permit";
    public static String node = "CDX";
    public static String adminAccount = "epacdxnode@csc.com";
    public static String adminAccountPwd = "nodeone";
    public static String userMgmtURL = "http://naas.epacdxnode.net/xml/usermgr.wsdl";
    public static UsermgrRequestor usermgrRequestor;
    public static String policyMgmtURL;
    public static PolicymgrRequestor policymgrRequestor;
    public static String legacyMgmtURL;
    public static LegacymgrRequestor legacymgrRequestor;
    public static final int LOWERLIMIT = 0;
    public static final int UPPERLIMIT = -1;

    public UsermgrRequestorTest(String name) {
        super(name);
    }

    public void testUserMgmt() {
        try {
            usermgrRequestor = new UsermgrRequestor(new URL(userMgmtURL));
            policymgrRequestor = new PolicymgrRequestor(new URL(policyMgmtURL));
            legacymgrRequestor = new LegacymgrRequestor(new URL(legacyMgmtURL));
            UsermgrRequestorTest.getUserList(userEmail, "");
            usermgrRequestor.addUser(adminAccount, adminAccountPwd, userEmail, userType, userPwd, userPwd, userState);
            UsermgrRequestorTest.getUserList(userEmail, userState);
            usermgrRequestor.changePwd(userEmail, userPwd, otherUserPwd);
            usermgrRequestor.updateUser(adminAccount, adminAccountPwd, userEmail, userType, otherUserPwd, adminAccount, otherUserState);
            UsermgrRequestorTest.getUserList(userEmail, otherUserState);
            policymgrRequestor.setPolicy(adminAccount, adminAccountPwd, userEmail, methodName, serviceRequest, serviceRequestParms, action);
            UsermgrRequestorTest.getPolicyList(userEmail);
            String policyVerified = policymgrRequestor.verifyPolicy(userEmail, node, methodName, serviceRequest, serviceRequestParms);
            System.out.println("policyVerified = " + policyVerified);
            PolicyInfo[] policyInfo = policymgrRequestor.getListOfSecurityEvents(adminAccount, adminAccountPwd, userEmail, BigInteger.valueOf(0L), BigInteger.valueOf(-1L));
            for (int i = 0; i < policyInfo.length; ++i) {
                if (policyInfo[i] == null) continue;
                System.out.println("PolicyInfo AuthEvents= " + policyInfo[i].toString());
            }
            policymgrRequestor.deletePolicy(adminAccount, adminAccountPwd, userEmail, methodName, serviceRequest, serviceRequestParms);
            UsermgrRequestorTest.getPolicyList(userEmail);
            String legacyId = legacymgrRequestor.getLegacyId(adminAccount, adminAccountPwd, userEmail);
            if (legacyId.length() > 0) {
                System.out.println("legacyId = " + legacyId);
            }
            usermgrRequestor.deleteUser(adminAccount, adminAccountPwd, userEmail);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getUserList(String userEmail, String userState) {
        try {
            UserInfo[] userList = usermgrRequestor.getUserList(adminAccount, adminAccountPwd, userEmail, userState, BigInteger.valueOf(0L), BigInteger.valueOf(-1L));
            for (int i = 0; i < userList.length; ++i) {
                System.out.println("Userlist = " + userList[i].toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getPolicyList(String userEmail) {
        try {
            PolicyInfo[] policyList = policymgrRequestor.getPolicyList(adminAccount, adminAccountPwd, userEmail, BigInteger.valueOf(0L), BigInteger.valueOf(-1L));
            for (int i = 0; i < policyList.length; ++i) {
                System.out.println("Policylist = " + policyList[i].toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        policyMgmtURL = "http://naas.epacdxnode.net/xml/policy.wsdl";
        legacyMgmtURL = "http://naas.epacdxnode.net/xml/LegacyId.wsdl";
    }
}

