/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.v10.client;

import gov.epa.cdx.axis.v10.client.NetworkNodeBindingStub;
import gov.epa.cdx.axis.v10.client.NetworkNodeLocator;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.holders.ArrayofDocHolder;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.RemoteException;

public class NodeRequestor {
    private static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$v10$client$NodeRequestor == null ? (class$gov$epa$cdx$axis$v10$client$NodeRequestor = NodeRequestor.class$("gov.epa.cdx.axis.v10.client.NodeRequestor")) : class$gov$epa$cdx$axis$v10$client$NodeRequestor).getName());
    private static int TIMEOUT = 1200000;
    private URL url;
    private String operationId;
    static /* synthetic */ Class class$gov$epa$cdx$axis$v10$client$NodeRequestor;

    private NodeRequestor() {
    }

    public NodeRequestor(URL nodeUrl) {
        this.url = nodeUrl;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    private NetworkNodeBindingStub getStub() throws RemoteException {
        NetworkNodeLocator locator = new NetworkNodeLocator();
        NetworkNodeBindingStub stub = new NetworkNodeBindingStub(this.url, locator);
        if (this.operationId != null) {
            stub._setProperty("operationId", this.operationId);
        }
        stub.setTimeout(TIMEOUT);
        return stub;
    }

    public String authenticate(String user, String password) throws RemoteException {
        String token = null;
        NetworkNodeBindingStub stub = this.getStub();
        token = stub.authenticate(user, password, "password");
        return token;
    }

    public String submit(String securityToken, String transactionId, String dataflowType, NodeDocument[] documents) throws RemoteException {
        String transactionIdToReturn = null;
        NetworkNodeBindingStub port = this.getStub();
        transactionIdToReturn = port.submit(securityToken, transactionId, dataflowType, documents);
        return transactionIdToReturn;
    }

    public String submit(String securityToken, String transactionId, String dataflowType, String documentName, String documentType, byte[] documentContent) throws RemoteException {
        String transactionIdToReturn = null;
        NetworkNodeBindingStub port = this.getStub();
        NodeDocument[] documents = new NodeDocument[1];
        NodeDocument document = new NodeDocument();
        document.setName(documentName);
        document.setType(documentType);
        document.putContent(documentContent, 1);
        documents[0] = document;
        transactionIdToReturn = port.submit(securityToken, transactionId, dataflowType, documents);
        return transactionIdToReturn;
    }

    public NodeDocument[] downloadAllDocumentsByTransaction(String securityToken, String transactionId, String dataflowType) throws RemoteException {
        NetworkNodeBindingStub port = this.getStub();
        NodeDocument[] documents = new NodeDocument[]{};
        ArrayofDocHolder array = new ArrayofDocHolder(documents);
        port.download(securityToken, transactionId, dataflowType, array);
        return array.value;
    }

    public NodeDocument[] download(String securityToken, String transactionId, String dataflowType, NodeDocument[] documents) throws RemoteException {
        NetworkNodeBindingStub port = this.getStub();
        ArrayofDocHolder array = new ArrayofDocHolder(documents);
        port.download(securityToken, transactionId, dataflowType, array);
        return array.value;
    }

    public byte[] download(String securityToken, String transactionId, String dataflowType, String documentName, String documentType) throws RemoteException {
        byte[] documentContent = null;
        NetworkNodeBindingStub port = this.getStub();
        NodeDocument[] documents = null;
        if (documentName != null) {
            documents = new NodeDocument[1];
            NodeDocument document = new NodeDocument();
            document.setName(documentName);
            document.setType(documentType);
            documents[0] = document;
        } else {
            documents = new NodeDocument[]{};
        }
        ArrayofDocHolder array = new ArrayofDocHolder(documents);
        port.download(securityToken, transactionId, dataflowType, array);
        try {
            documentContent = array.value[0].obtainContentBytes();
        }
        catch (Exception ex) {
            documentContent = null;
        }
        return documentContent;
    }

    public byte[] query(String securityToken, String serviceName, BigInteger startRow, BigInteger maxRow, String[] serviceParameterValues) throws RemoteException, CDXException {
        Object documentContent = null;
        NetworkNodeBindingStub port = this.getStub();
        String result = port.query(securityToken, serviceName, startRow, maxRow, serviceParameterValues);
        return result.getBytes();
    }

    public String solicit(String securityToken, String returnUrl, String serviceName, String[] serviceParameterValues) throws RemoteException {
        String transactionId = null;
        NetworkNodeBindingStub port = this.getStub();
        transactionId = port.solicit(securityToken, returnUrl, serviceName, serviceParameterValues);
        return transactionId;
    }

    public String notify(String securityToken, String nodeAddress, String dataflowType, NodeDocument[] documents) throws RemoteException {
        String transactionId = null;
        NetworkNodeBindingStub port = this.getStub();
        transactionId = port.notify(securityToken, nodeAddress, dataflowType, documents);
        return transactionId;
    }

    public String statusNotify(String securityToken, String transactionId, String status, byte[] message) throws RemoteException {
        NodeDocument[] documents = new NodeDocument[1];
        NodeDocument document = new NodeDocument();
        document.setName(transactionId);
        document.setType(status);
        document.putContent(message, 1);
        documents[0] = document;
        NetworkNodeBindingStub port = this.getStub();
        String notifyTransaction = port.notify(securityToken, null, "http://www.exchangenetwork.net/node/status", documents);
        return notifyTransaction;
    }

    public String eventNotify(String securityToken, String eventName, String eventType, byte[] message) throws RemoteException {
        NodeDocument[] documents = new NodeDocument[1];
        NodeDocument document = new NodeDocument();
        document.setName(eventName);
        document.setType(eventType);
        document.putContent(message, 1);
        documents[0] = document;
        NetworkNodeBindingStub port = this.getStub();
        String notifyTransaction = port.notify(securityToken, null, "http://www.exchangenetwork.net/node/event", documents);
        return notifyTransaction;
    }

    public String documentNotify(String securityToken, String nodeAddress, String dataflowType, String documentName, String documentType) throws RemoteException {
        String transactionId = null;
        NetworkNodeBindingStub port = this.getStub();
        NodeDocument[] documents = new NodeDocument[1];
        NodeDocument document = new NodeDocument();
        document.setName(documentName);
        document.setType(documentType);
        documents[0] = document;
        transactionId = port.notify(securityToken, nodeAddress, dataflowType, documents);
        return transactionId;
    }

    public String notify(String securityToken, String nodeAddress, String dataflowType, String documentName, String documentType) throws RemoteException {
        String transactionId = null;
        NetworkNodeBindingStub port = this.getStub();
        NodeDocument[] documents = new NodeDocument[1];
        NodeDocument document = new NodeDocument();
        document.setName(documentName);
        document.setType(documentType);
        documents[0] = document;
        transactionId = port.notify(securityToken, nodeAddress, dataflowType, documents);
        return transactionId;
    }

    public String nodePing(String hello) throws RemoteException {
        String response = null;
        NetworkNodeBindingStub port = this.getStub();
        response = port.nodePing(hello);
        return response;
    }

    public String[] getServices(String securityToken, String serviceType) throws RemoteException {
        String[] services = null;
        NetworkNodeBindingStub port = this.getStub();
        services = port.getServices(securityToken, serviceType);
        return services;
    }

    public String getStatus(String securityToken, String transactionId) throws RemoteException {
        String status = null;
        NetworkNodeBindingStub port = this.getStub();
        status = port.getStatus(securityToken, transactionId);
        return status;
    }

    public void setOperationId(String id) {
        this.operationId = id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

