/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.v10.impl;

import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentList;
import java.util.Iterator;

public class DocumentConverter {
    protected static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$v10$impl$DocumentConverter == null ? (class$gov$epa$cdx$axis$v10$impl$DocumentConverter = DocumentConverter.class$("gov.epa.cdx.axis.v10.impl.DocumentConverter")) : class$gov$epa$cdx$axis$v10$impl$DocumentConverter).getName());
    static /* synthetic */ Class class$gov$epa$cdx$axis$v10$impl$DocumentConverter;

    public static DocumentList CdxToDocumentList(NodeDocument[] cdxDocuments, String dataFlow) throws CDXException {
        log.debug((Object)"Enter DocumentConverter.CdxToDocumentList");
        DocumentList documentList = new DocumentList(new DataflowTypeVO(dataFlow));
        if (cdxDocuments != null) {
            for (int i = 0; i < cdxDocuments.length; ++i) {
                if (cdxDocuments[i].getContent() == null) {
                    documentList.addDocument(cdxDocuments[i].getName(), cdxDocuments[i].getType().toString(), dataFlow, null);
                    continue;
                }
                documentList.addDocument(cdxDocuments[i].getName(), cdxDocuments[i].getType().toString(), dataFlow, cdxDocuments[i].obtainContentBytes());
            }
        }
        log.debug((Object)"Exit DocumentConverter.CdxToDocumentList");
        return documentList;
    }

    public static void SetDataToCdxDocuments(DocumentList documentList, NodeDocument[] cdxDocuments, int contentType) throws CDXException {
        log.debug((Object)"Enter DocumentConverter.SetDataToCdxDocuments");
        for (int i = 0; i < cdxDocuments.length; ++i) {
            String documentName = cdxDocuments[i].getName();
            DocumentList.validateName((String)documentName);
            DocumentInterface document = documentList.getDocument(documentName);
            cdxDocuments[i].putContent(document.getData(), contentType);
        }
        log.debug((Object)"Enter DocumentConverter.SetDataToCdxDocuments");
    }

    public static NodeDocument[] DocumentListToCdx(DocumentList documentList, int contentType) {
        log.debug((Object)"Enter DocumentConverter.DocumentListToCdx");
        NodeDocument[] cdxDocuments = new NodeDocument[documentList.getDocuments().size()];
        int i = 0;
        Iterator iter = documentList.getDocuments().iterator();
        while (iter.hasNext()) {
            DocumentInterface document = (DocumentInterface)iter.next();
            NodeDocument cdxDocument = new NodeDocument();
            cdxDocument.setName(document.getName());
            cdxDocument.setType(document.getDocumentType().toString());
            if (document.getData() != null) {
                cdxDocument.putContent(document.getData(), contentType);
            }
            cdxDocuments[i] = cdxDocument;
            ++i;
        }
        log.debug((Object)"Exit DocumentConverter.DocumentListToCdx");
        return cdxDocuments;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

