/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.v10.test;

import gov.epa.cdx.axis.v10.NetworkNodePortType;
import gov.epa.cdx.axis.v10.client.NetworkNodeLocator;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.axis.v10.vo.holders.ArrayofDocHolder;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.DebugManager;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.rpc.ServiceException;

public class NetworkNodeTestCase {
    protected static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$v10$test$NetworkNodeTestCase == null ? (class$gov$epa$cdx$axis$v10$test$NetworkNodeTestCase = NetworkNodeTestCase.class$("gov.epa.cdx.axis.v10.test.NetworkNodeTestCase")) : class$gov$epa$cdx$axis$v10$test$NetworkNodeTestCase).getName());
    private static String token = "";
    private static String submitTrID = "";
    private static String notifyTrID = "";
    private static String invalidTrID = "";
    private static String solicitTrID = "";
    private static NodeDocument[] myDocs = null;
    String authToken = null;
    String clientHost = "20.4.58.154";
    String userId = "cdx";
    String password = "test";
    String authMethod = "password";
    static /* synthetic */ Class class$gov$epa$cdx$axis$v10$test$NetworkNodeTestCase;

    public void test1NetworkNodePortTypeAuth() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            System.out.println("userid: " + this.userId);
            value = binding.authenticate(this.userId, this.password, this.authMethod);
            System.out.println("Authorization successful for (" + this.userId + "," + this.password + ") AuthoToken:" + value);
            token = value;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test1NetworkNodePortTypeAuthInvalidLogin() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.authenticate("Nonexistent user", this.password, this.authMethod);
            DebugManager.logMessage((String)("Authorization successful for (" + this.userId + "," + this.password + ") AuthoToken:" + value));
            token = value;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test2NetworkNodePortTypeSubmit() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            NodeDocument[] docs = new NodeDocument[3];
            NodeDocument doc1 = new NodeDocument();
            doc1.setName("Den1");
            doc1.setType("XML");
            doc1.setContent(new DataHandler((Object)"Hello", "text/plain"));
            docs[0] = doc1;
            NodeDocument doc2 = new NodeDocument();
            doc2.setName("Den2");
            doc2.setType("BIN");
            try {
                doc2.setContent("Hello den2".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            docs[1] = doc2;
            NodeDocument doc3 = new NodeDocument();
            doc3.setName("Den3");
            doc3.setType("FLAT");
            docs[2] = doc3;
            System.setProperty("isSUBMIT2", "false");
            value = binding.submit(token, "", "TEST", docs);
            DebugManager.logMessage((String)("Transaction out of Submit: " + value));
            submitTrID = value;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test2NetworkNodePortTypeSubmit(NodeDocument[] docs) {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            if (docs != null) {
                NodeDocument doc = null;
                for (int i = 0; i < docs.length; ++i) {
                    doc = docs[i];
                    if (doc != null) {
                        doc.putContent(doc.obtainContentBytes(), 1);
                    }
                    docs[i] = doc;
                }
            }
            System.setProperty("isSUBMIT2", "false");
            value = binding.submit(token, null, "FRS", docs);
            System.out.println("Transaction out of Submit: " + value);
            submitTrID = value;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testNotifyFromFRS() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            NodeDocument[] docs = new NodeDocument[1];
            NodeDocument doc1 = new NodeDocument();
            doc1.setName("FRS Status Report");
            doc1.setType("XML");
            doc1.setContent(new DataHandler((Object)"ooooofailedToProcessDocument", "text/plain"));
            docs[0] = doc1;
            notifyTrID = value = binding.notify(token, "8ddb0adc-dbe9-4426-8990-2f0652ae57c1", "FRS_NOTIFY", docs);
            System.out.println("Transaction Out Of notify: " + value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testSubmitFromDataFlow() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            NodeDocument[] docs = new NodeDocument[1];
            NodeDocument doc1 = new NodeDocument();
            doc1.setName("Den1");
            doc1.setType("XML");
            doc1.setContent(new DataHandler((Object)"Hello Den1", "text/plain"));
            docs[0] = doc1;
            System.setProperty("isSUBMIT2", "false");
            value = binding.submit(token, "ARTY", "FRS_SUBMIT", docs);
            DebugManager.logMessage((String)("Transaction out of Submit: " + value));
            submitTrID = value;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testInvalidAuthNetworkNodePortTypeSubmit() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            NodeDocument[] docs = new NodeDocument[1];
            NodeDocument doc1 = new NodeDocument();
            doc1.setName("Den1");
            doc1.setType("XML");
            doc1.setContent(new DataHandler((Object)"Hello Den1", "text/plain"));
            docs[0] = doc1;
            System.setProperty("isSUBMIT2", "false");
            value = binding.submit("BOGUS", "1234", "TEST", docs);
            DebugManager.logMessage((String)("Transaction out of Submit: " + value));
            submitTrID = value;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testSubmitNetworkNodePortTypeGetStatus() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.getStatus(token, submitTrID);
            System.out.println("Status of transaction: " + value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testNotifyNetworkNodePortTypeGetStatus() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.getStatus(token, notifyTrID);
            DebugManager.logMessage((String)("Status of notify transaction: " + value));
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testInvalidNetworkNodePortTypeGetStatus() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.getStatus(token, "broken transaction");
            DebugManager.logMessage((String)("Status of bogus transaction: " + value));
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test4NetworkNodePortTypeNotify() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            NodeDocument[] docs = new NodeDocument[1];
            NodeDocument doc1 = new NodeDocument();
            doc1.setName("Den1");
            doc1.setType("XML");
            docs[0] = doc1;
            notifyTrID = value = binding.notify(token, "nodeAddress", "TEST", docs);
            System.out.println("Transaction Out Of notify: " + value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void testNetworkNodePortTypeDownloadNoDocuments() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            ArrayofDocHolder holder = new ArrayofDocHolder();
            binding.download(token, submitTrID, "TEST", holder);
            NodeDocument[] documents = holder.value;
            if (documents != null) {
                for (int i = 0; i < documents.length; ++i) {
                    NodeDocument docOut = documents[i];
                    DebugManager.logMessage((String)(" doc#" + i));
                    DebugManager.logMessage((String)(" docName:" + docOut.getName()));
                    DebugManager.logMessage((String)(" docType:" + docOut.getType()));
                    try {
                        DebugManager.logMessage((String)(" docBinary:" + docOut.getContent()));
                        DebugManager.logMessage((String)(" HashCode:" + docOut.hashCode()));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test5NetworkNodePortTypeDownload() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            NodeDocument[] docs = new NodeDocument[3];
            NodeDocument doc1 = new NodeDocument();
            doc1.setName("Den1");
            doc1.setType("XML");
            doc1.setContent(new DataHandler((Object)"Hello", "text/plain"));
            docs[0] = doc1;
            NodeDocument doc2 = new NodeDocument();
            doc2.setName("Den2");
            doc2.setType("BIN");
            try {
                doc2.setContent("Hello den2".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            docs[1] = doc2;
            NodeDocument doc3 = new NodeDocument();
            doc3.setName("Den3");
            doc3.setType("FLAT");
            doc3.setContent("Hello Den3".getBytes());
            docs[2] = doc3;
            ArrayofDocHolder holder = new ArrayofDocHolder(docs);
            binding.download(token, submitTrID, "TEST", new ArrayofDocHolder());
            NodeDocument[] documents = holder.value;
            if (documents != null) {
                for (int i = 0; i < documents.length; ++i) {
                    NodeDocument docOut = documents[i];
                    DebugManager.logMessage((String)(" doc#" + i));
                    DebugManager.logMessage((String)(" docName:" + docOut.getName()));
                    DebugManager.logMessage((String)(" docType:" + docOut.getType()));
                    try {
                        DebugManager.logMessage((String)(" docBinary:" + docOut.getContent()));
                        DebugManager.logMessage((String)(" HashCode:" + docOut.hashCode()));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test5NetworkNodePortTypeDownload(NodeDocument[] docs) {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            ArrayofDocHolder holder = new ArrayofDocHolder(docs);
            binding.download(token, submitTrID, "FRS", holder);
            NodeDocument[] documents = holder.value;
            this.saveDocs(documents);
            if (documents != null) {
                for (int i = 0; i < documents.length; ++i) {
                    NodeDocument docOut = documents[i];
                    DebugManager.logMessage((String)(" doc#" + i));
                    DebugManager.logMessage((String)(" docName:" + docOut.getName()));
                    DebugManager.logMessage((String)(" docType:" + docOut.getType()));
                    try {
                        DebugManager.logMessage((String)(" docBinary:" + docOut.getContent()));
                        DebugManager.logMessage((String)(" HashCode:" + docOut.hashCode()));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test6NetworkNodePortTypeSolicit() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            String[] param = new String[]{"2004-09-14", "NC"};
            solicitTrID = value = binding.solicit(token, null, "GetFacilityByChangeDate", param);
            System.out.println("transaction Id for solicit :" + value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test6NetworkNodePortTypeQuery() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            String[] param = new String[]{"NE", "stapleton"};
            value = binding.query(token, "GetFacilityByName", new BigInteger("0"), new BigInteger("200"), param);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test6NetworkNodePortTypeQueryNebraska() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            log.debug((Object)("Our token:" + token));
            value = binding.query(token, "GetFacilityByNameOrID", new BigInteger("0"), new BigInteger("0"), new String[]{"All%"});
        }
        catch (Exception re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test6NetworkNodePortTypeQueryInvalidToken() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.query("Bad Token", new String(), new BigInteger("0"), new BigInteger("0"), new String[0]);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test7NetworkNodePortTypeSQLExecute() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.execute(token, "This is a wrong SQL", new String[0]);
            DebugManager.logMessage((String)value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test7NetworkNodePortTypeSQLExecuteInvalidToken() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.execute("Bad Token", "This is a wrong SQL", new String[0]);
            DebugManager.logMessage((String)value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test8NetworkNodePortTypeNodePing() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String value = null;
            value = binding.nodePing(new String());
            DebugManager.logMessage((String)value);
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test9NetworkNodePortTypeGetServices() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String[] value = null;
            value = binding.getServices(token, "Streams");
            if (value != null) {
                for (int i = 0; i < value.length; ++i) {
                    DebugManager.logMessage((String)value[i]);
                }
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    public void test9NetworkNodePortTypeGetServicesInvalidAuthToken() {
        NetworkNodePortType binding;
        try {
            binding = new NetworkNodeLocator().getNetworkNodePortType();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new RuntimeException("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        try {
            String[] value = null;
            value = binding.getServices("BadToken", "SQLQuery");
            for (int i = 0; i < value.length; ++i) {
                DebugManager.logMessage((String)value[i]);
            }
        }
        catch (RemoteException re) {
            throw new RuntimeException("Remote Exception caught: " + re);
        }
    }

    private void saveDocs(NodeDocument[] docs) {
        System.out.println(" ***** Save Documents: ");
        FileOutputStream out = null;
        String fileName = "";
        if (docs != null) {
            for (int i = 0; i < docs.length; ++i) {
                NodeDocument doc = docs[i];
                System.out.println(" ***** Doc #: " + i);
                fileName = doc.getName() + "_" + System.currentTimeMillis() + "_" + doc.getType();
                System.out.println(" ***** FileName: " + fileName);
                try {
                    out = new FileOutputStream(fileName);
                    out.write(doc.obtainContentBytes());
                    out.close();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            System.out.println("### Array of cdxDocuments is NULL");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

