/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.validatormgr.client;

import gov.epa.cdx.axis.util.dime.DIMEManager;
import gov.epa.cdx.axis.validatormgr.DocumentFormat;
import gov.epa.cdx.axis.validatormgr.DocumentType;
import gov.epa.cdx.axis.validatormgr.PasswordType;
import gov.epa.cdx.axis.validatormgr.SchematronType;
import gov.epa.cdx.axis.validatormgr.client.ValidatorBindingStub;
import gov.epa.cdx.axis.validatormgr.client.ValidatorLocator;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.model.validation.DocumentValidationResultVO;
import gov.epa.cdx.model.validation.DocumentValidationStatus;
import gov.epa.cdx.model.validation.DocumentValidationVO;
import java.net.URL;
import java.rmi.RemoteException;
import javax.activation.DataHandler;

public class ValidatorRequestor {
    private static LogInterface log = LogFactory.getLog((String)(class$gov$epa$cdx$axis$validatormgr$client$ValidatorRequestor == null ? (class$gov$epa$cdx$axis$validatormgr$client$ValidatorRequestor = ValidatorRequestor.class$("gov.epa.cdx.axis.validatormgr.client.ValidatorRequestor")) : class$gov$epa$cdx$axis$validatormgr$client$ValidatorRequestor).getName());
    private static int TIMEOUT = 3600000;
    private URL url;
    private static final String SUCCESS_PREFIX = "Congratulations";
    private static final String SCHEMA_VALIDATION = "SchemaValidation";
    private static final String SCHEMATRON_VALIDATION = "SchematronValidation";
    private static final String SCHEMA_AND_SCHEMATRON_VALIDATION = "SchemanAndSchematronValidation";
    static /* synthetic */ Class class$gov$epa$cdx$axis$validatormgr$client$ValidatorRequestor;

    public ValidatorRequestor(URL url) {
        this.url = url;
    }

    private ValidatorBindingStub getStub() throws RemoteException {
        ValidatorLocator locator = new ValidatorLocator();
        ValidatorBindingStub stub = new ValidatorBindingStub(this.url, locator);
        stub.setTimeout(TIMEOUT);
        return stub;
    }

    public DocumentValidationResultVO schemaValidate(DocumentValidationVO info) throws RemoteException {
        return this.validate(info, SCHEMA_VALIDATION);
    }

    public DocumentValidationResultVO schematronValidate(DocumentValidationVO info) throws RemoteException {
        return this.validate(info, SCHEMATRON_VALIDATION);
    }

    public DocumentValidationResultVO schematronAndSchemaValidate(DocumentValidationVO info) throws RemoteException {
        return this.validate(info, SCHEMA_AND_SCHEMATRON_VALIDATION);
    }

    private DocumentValidationResultVO validate(DocumentValidationVO info, String validationType) throws RemoteException {
        DocumentValidationResultVO validationResult = new DocumentValidationResultVO(DocumentValidationStatus.VALIDATED);
        String result = null;
        try {
            ValidatorBindingStub port = this.getStub();
            PasswordType userPassword = new PasswordType(info.getPassword());
            DataHandler dimeAttachment = DIMEManager.convertToAttachment(info.getXmlDocument(), info.getFormat());
            result = validationType.equalsIgnoreCase(SCHEMA_VALIDATION) ? port.schemaValidate(info.getUserId(), userPassword, DocumentType.fromString(info.getSchema()), dimeAttachment, DocumentFormat.fromString(info.getFormat()), info.getSendResultTo()) : (validationType.equalsIgnoreCase(SCHEMATRON_VALIDATION) ? port.schematronValidate(info.getUserId(), userPassword, SchematronType.fromString(info.getSchema()), dimeAttachment, DocumentFormat.fromString(info.getFormat()), info.getSendResultTo()) : port.validateDocument(info.getUserId(), userPassword, DocumentType.fromString(info.getSchema()), dimeAttachment, DocumentFormat.fromString(info.getFormat()), info.getSendResultTo()));
            if (result.lastIndexOf(SUCCESS_PREFIX) == -1) {
                validationResult.setValidationStatus(DocumentValidationStatus.FAILED);
                validationResult.setErrorMessage(result);
            }
        }
        catch (IllegalStateException exI) {
            validationResult.setValidationStatus(DocumentValidationStatus.FAILED);
            validationResult.setErrorMessage("Unsupported schema [" + info.getSchema() + "] or invalid document format [" + info.getFormat() + "] specified.  Only xml or zip format is allowed.");
        }
        catch (RemoteException exR) {
            throw exR;
        }
        catch (Exception exE) {
            validationResult.setValidationStatus(DocumentValidationStatus.FAILED);
            validationResult.setErrorMessage("Validation failed " + exE.getMessage());
        }
        return validationResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

