/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.axis.validatormgr.test;

import gov.epa.cdx.axis.validatormgr.DocumentType;
import gov.epa.cdx.axis.validatormgr.client.ValidatorRequestor;
import gov.epa.cdx.model.validation.DocumentValidationResultVO;
import gov.epa.cdx.model.validation.DocumentValidationVO;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import junit.framework.TestCase;

public class ValidatorRequestorTest
extends TestCase {
    public static String userId = "cdx";
    public static String userPwd = "test";
    public static String schemaType = DocumentType.NEI_Point_v3_0.toString();
    public static String schematronType = "NEI_Point_v3_0".toString();
    public static String documentFormatXML = "xml";
    public static String documentFormatZIP = "zip";
    public static String validatorURL = "http://tools.epacdxnode.net/xml/validator.wsdl";
    public static ValidatorRequestor validatorRequestor;
    public static String file;

    public ValidatorRequestorTest(String name) {
        super(name);
    }

    public void testValidation() {
        DocumentValidationResultVO result = null;
        Object status = null;
        try {
            validatorRequestor = new ValidatorRequestor(new URL(validatorURL));
            byte[] fileContents = this.readFile(file);
            DocumentValidationVO info = new DocumentValidationVO(schematronType, fileContents, documentFormatXML);
            info.setUserId(userId);
            info.setPassword(userPwd);
            result = validatorRequestor.schematronValidate(info);
            System.out.println("Schematron results for []: \t" + result.toString());
            info.setSchema(schemaType);
            result = validatorRequestor.schemaValidate(info);
            System.out.println("Schema results for []: \t" + result.toString());
            result = validatorRequestor.schematronAndSchemaValidate(info);
            System.out.println("Combination results for []: \t" + result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] readFile(String file) {
        byte[] data = null;
        try {
            File f = new File(file);
            int filesize = (int)f.length();
            data = new byte[filesize];
            DataInputStream in = new DataInputStream(new FileInputStream(f));
            in.readFully(data);
            in.close();
        }
        catch (Exception e) {
            System.out.println("Validation failed ");
            e.printStackTrace();
        }
        return data;
    }

    static {
        file = "C:\\NEI\\inbound\\20040412_tests_Point_v3_0.xml";
    }
}

