/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jconfig.event.PropertyListener;
import org.jconfig.event.PropertyListenerEvent;

public class Configuration
implements Serializable {
    private String configName;
    private HashMap categories = new HashMap();
    private String mainCategory;
    private HashMap variables = new HashMap();
    private List propertyListener;

    public Configuration(String configName) {
        this.configName = configName;
        this.propertyListener = new Vector();
        this.setCategory("general", true);
    }

    public void setCategory(String name) {
        this.setCategory(name, false);
    }

    public void setCategory(String name, boolean main) {
        if (name != null && !this.categories.containsKey(name)) {
            Properties properties = new Properties();
            this.categories.put(name, properties);
            if (main) {
                this.mainCategory = name;
            }
        }
    }

    public String getMainCategoryName() {
        return this.mainCategory;
    }

    public String[] getCategoryNames() {
        Set allCategories = this.categories.keySet();
        return allCategories.toArray(new String[0]);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null, null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, defaultValue, null);
    }

    public String getProperty(String key, String defaultValue, String category) {
        Properties properties;
        String value;
        if (key == null) {
            return defaultValue;
        }
        if (!this.categories.containsKey(category)) {
            category = this.mainCategory;
        }
        if ((value = (properties = (Properties)this.categories.get(category)).getProperty(key)) == null) {
            properties = (Properties)this.categories.get(this.mainCategory);
            value = properties.getProperty(key);
            if (value != null) {
                return this.replaceVariables(value);
            }
            return defaultValue;
        }
        return this.replaceVariables(value);
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, value, null);
    }

    public void setProperty(String name, String value, String category) {
        if (name != null) {
            Properties properties;
            if (category == null) {
                category = this.mainCategory;
            }
            if ((properties = (Properties)this.categories.get(category)) != null) {
                properties.setProperty(name, value);
                this.raisePropertyEvent(category, name, value);
            }
        }
    }

    public void removeProperty(String name) {
        if (name != null) {
            this.removeProperty(name, null);
        }
    }

    public void removeProperty(String name, String category) {
        if (category == null) {
            category = this.mainCategory;
        }
        if (name != null && this.categories.containsKey(category)) {
            Properties properties = this.getProperties(category);
            ((Hashtable)properties).remove(name);
        }
    }

    public int getNumberOfCategories() {
        return this.categories.size();
    }

    public void removeCategory(String category) {
        if (this.categories.containsKey(category)) {
            this.categories.remove(category);
        }
    }

    private Properties getProperties(String category) {
        return (Properties)this.categories.get(category);
    }

    public String[] getPropertyNames(String category) {
        Properties properties = this.getProperties(category);
        if (properties != null) {
            Set keys = ((Hashtable)properties).keySet();
            return keys.toArray(new String[0]);
        }
        return null;
    }

    public void setVariable(String name, String value) {
        if (name != null && value != null) {
            this.variables.put(name, value);
        }
    }

    public HashMap getVariables() {
        return this.variables;
    }

    private String replaceVariables(String line) {
        if (this.variables.size() > 0) {
            Iterator it = this.variables.keySet().iterator();
            int pos = 0;
            while (it.hasNext()) {
                String currentKey = (String)it.next();
                String value = (String)this.variables.get(currentKey);
                currentKey = "${" + currentKey + "}";
                pos = line.indexOf(currentKey);
                while (pos != -1) {
                    String firstPart = line.substring(0, pos);
                    String secondPart = line.substring(pos + currentKey.length());
                    line = firstPart + value + secondPart;
                    pos = line.indexOf(currentKey);
                }
            }
        }
        return line;
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.getIntProperty(name, defaultValue, this.mainCategory);
    }

    public int getIntProperty(String name, int defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getBooleanProperty(name, defaultValue, this.mainCategory);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.getLongProperty(name, defaultValue, this.mainCategory);
    }

    public long getLongProperty(String name, long defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.getDoubleProperty(name, defaultValue, this.mainCategory);
    }

    public double getDoubleProperty(String name, double defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public char getCharProperty(String name, char defaultValue) {
        return this.getCharProperty(name, defaultValue, this.mainCategory);
    }

    public char getCharProperty(String name, char defaultValue, String category) {
        String value = this.getProperty(name, null, category);
        if (value == null) {
            return defaultValue;
        }
        if (value.length() == 1) {
            return value.charAt(0);
        }
        return defaultValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String[] cats = this.getCategoryNames();
        int i = 0;
        while (i < cats.length) {
            buffer.append("Category=");
            buffer.append(cats[i]);
            String[] propNames = this.getPropertyNames(cats[i]);
            if (propNames != null) {
                buffer.append("\n");
                int j = 0;
                while (j < propNames.length) {
                    String value = this.getProperty(propNames[j], "", cats[i]);
                    buffer.append("  ");
                    buffer.append(propNames[j]);
                    buffer.append("=");
                    buffer.append(this.replaceVariables(value));
                    buffer.append("\n");
                    ++j;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getXMLAsString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.variables.keySet().iterator();
        boolean vars = false;
        if (it.hasNext()) {
            buffer.append("  <variables>\n");
            vars = true;
        }
        while (it.hasNext()) {
            String varName = (String)it.next();
            String varText = (String)this.variables.get(varName);
            buffer.append("    <variable name=\"");
            buffer.append(varName);
            buffer.append("\" value=\"");
            buffer.append(varText);
            buffer.append("\"/>\n");
        }
        if (vars) {
            buffer.append("  </variables>\n");
        }
        String[] cats = this.getCategoryNames();
        int i = 0;
        while (i < cats.length) {
            buffer.append("  <category name=\"");
            buffer.append(cats[i]);
            buffer.append("\">\n");
            Properties props = this.getProperties(cats[i]);
            if (props != null) {
                Iterator nit = ((Hashtable)props).keySet().iterator();
                while (nit.hasNext()) {
                    String name = (String)nit.next();
                    String value = props.getProperty(name);
                    buffer.append("    <property name=\"");
                    buffer.append(name);
                    buffer.append("\" value=\"");
                    buffer.append(value);
                    buffer.append("\"/>\n");
                }
                buffer.append("  </category>\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    private void raisePropertyEvent(String categoryName, String propertyName, String propertyValue) {
        Iterator iterator = this.propertyListener.iterator();
        while (iterator.hasNext()) {
            PropertyListener listener = (PropertyListener)iterator.next();
            listener.propertyChanged(new PropertyListenerEvent(categoryName, propertyName, propertyValue));
        }
    }

    public void addPropertyListener(PropertyListener listener) {
        this.propertyListener.add(listener);
    }

    public String getConfigName() {
        return this.configName;
    }
}

