/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.File;
import java.util.HashMap;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.FileWatcher;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.handler.InputStreamHandler;

public class ConfigurationManager {
    private static ConfigurationManager cm = null;
    private static HashMap configurations = null;
    private FileWatcher watcher;
    private File configFile;
    private static HashMap handlerMapping;

    private ConfigurationManager() {
        configurations = new HashMap();
        handlerMapping = new HashMap();
    }

    public static synchronized ConfigurationManager getInstance() {
        if (cm == null) {
            cm = new ConfigurationManager();
        }
        return cm;
    }

    public static Configuration getConfiguration() {
        return ConfigurationManager.getConfiguration("default");
    }

    public static Configuration getConfiguration(String name) {
        ConfigurationManager.getInstance();
        if (configurations.containsKey(name)) {
            return (Configuration)configurations.get(name);
        }
        InputStreamHandler ish = new InputStreamHandler("config.xml");
        try {
            Configuration config = ish.load();
            configurations.put(name, config);
            handlerMapping.put(name, ish);
            return config;
        }
        catch (ConfigurationManagerException e) {
            return new Configuration(name);
        }
    }

    public void load(ConfigurationHandler configurationHandler, String configurationName) throws ConfigurationManagerException {
        Configuration config = configurationHandler.load();
        if (config != null) {
            configurations.put(configurationName, config);
            handlerMapping.put(configurationName, configurationHandler);
        }
    }

    public void save(ConfigurationHandler handler, Configuration config) throws ConfigurationManagerException {
        handler.store(config);
        configurations.put(config.getConfigName(), config);
        handlerMapping.put(config.getConfigName(), handler);
    }

    public void reload(String name) throws ConfigurationManagerException {
        ConfigurationHandler handler;
        Configuration cfg;
        if (configurations.containsKey(name)) {
            cfg = ConfigurationManager.getConfiguration(name);
            handler = (ConfigurationHandler)handlerMapping.get(name);
            if (handler == null) {
                throw new ConfigurationManagerException("There is no handler associated for this configuration");
            }
        } else {
            throw new ConfigurationManagerException("There is no configuration with this name");
        }
        cfg = handler.load();
        configurations.put(name, cfg);
    }
}

