/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jconfig.event.FileListener;
import org.jconfig.event.FileListenerEvent;

public class FileWatcher
extends Thread {
    private File file;
    private List fileListenerList;
    private volatile Thread watcher;
    private int interval = 10000;
    private long lastmodified;

    public FileWatcher(String filename) {
        this(new File(filename));
    }

    public FileWatcher(File file) {
        this.file = file;
        this.lastmodified = file.lastModified();
        this.fileListenerList = new Vector();
    }

    public void addFileListener(FileListener fileListener) {
        this.fileListenerList.add(fileListener);
    }

    public void setInterval(int seconds) {
        this.interval = seconds * 1000;
    }

    public void stopWatching() {
        this.watcher = null;
    }

    public void start() {
        this.watcher = new Thread(this);
        this.watcher.start();
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (thisThread == this.watcher) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                this.watcher = null;
            }
            this.checkFile();
        }
    }

    public FileListener[] getFileListeners() {
        return (FileListener[])this.fileListenerList.toArray();
    }

    public void setFile(File file) {
        this.file = file;
    }

    private void checkFile() {
        File newFile = this.file;
        if (newFile.lastModified() > this.lastmodified) {
            this.lastmodified = newFile.lastModified();
            Iterator iterator = this.fileListenerList.iterator();
            while (iterator.hasNext()) {
                FileListener listener = (FileListener)iterator.next();
                listener.fileChanged(new FileListenerEvent(newFile));
            }
        }
    }

    public static void main(String[] args) {
        new FileWatcher("config.xml").start();
    }
}

