/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.handler.XMLFileHandler;

public class JConfigFrame
extends JFrame {
    private static final int EXIT_ON_CLOSE = -107;
    private int returnCode = 0;

    public JConfigFrame(String label) {
        super(label);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(-107);
        final ConfigurationManager manager = ConfigurationManager.getInstance();
        final XMLFileHandler fileHandler = new XMLFileHandler(JConfigFrame.getSettingsFilename());
        try {
            manager.load(fileHandler, "jconfig");
        }
        catch (ConfigurationManagerException e) {
            Configuration config = new Configuration("jconfig");
            config.setCategory("dimension");
            config.setProperty("x_coord", "0", "dimension");
            config.setProperty("y_coord", "0", "dimension");
            config.setProperty("height", "200", "dimension");
            config.setProperty("width", "300", "dimension");
            try {
                manager.save(fileHandler, config);
            }
            catch (ConfigurationManagerException e1) {
                System.out.println("Cannot save configuration file. " + e1.getMessage());
            }
        }
        final Configuration config = ConfigurationManager.getConfiguration("jconfig");
        ((Component)this).setBounds(config.getIntProperty("x_coord", 0, "dimension"), config.getIntProperty("y_coord", 0, "dimension"), config.getIntProperty("width", 400, "dimension"), config.getIntProperty("height", 200, "dimension"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Rectangle bounds = JConfigFrame.this.getBounds();
                config.setProperty("x_coord", JConfigFrame.this.doubleToString(bounds.getX()), "dimension");
                config.setProperty("y_coord", JConfigFrame.this.doubleToString(bounds.getY()), "dimension");
                config.setProperty("height", JConfigFrame.this.doubleToString(bounds.getSize().getHeight()), "dimension");
                config.setProperty("width", JConfigFrame.this.doubleToString(bounds.getSize().getWidth()), "dimension");
                try {
                    manager.save(fileHandler, config);
                }
                catch (ConfigurationManagerException configurationManagerException) {
                    // empty catch block
                }
            }
        });
    }

    public void setReturnCode(int newValue) {
        this.returnCode = newValue;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        int defaultCloseOperation = this.getDefaultCloseOperation();
        if (windowEvent.getID() == 201 && defaultCloseOperation == -107) {
            System.exit(this.returnCode);
        }
    }

    protected String paramString() {
        String returnValue = "";
        int defaultCloseOperation = this.getDefaultCloseOperation();
        if (defaultCloseOperation == -107) {
            returnValue = ",EXIT_ON_CLOSE";
        }
        return super.paramString() + returnValue;
    }

    private String doubleToString(double d) {
        return new Integer(new Double(d).intValue()).toString();
    }

    private static String getSettingsFilename() {
        return System.getProperty("user.dir") + System.getProperty("file.separator") + "jconfig-gui-config.xml";
    }
}

