/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.File;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.FileWatcher;
import org.jconfig.event.FileListener;
import org.jconfig.event.FileListenerEvent;
import org.jconfig.handler.ConfigurationHandler;

public abstract class AbstractHandler
implements ConfigurationHandler,
FileListener {
    private FileWatcher watcher = null;

    public void fileChanged(FileListenerEvent event) {
        try {
            this.load();
        }
        catch (ConfigurationManagerException configurationManagerException) {
            // empty catch block
        }
    }

    public void addFileListener(FileListener fileListener) {
        this.watcher = new FileWatcher(this.getFile());
        this.watcher.addFileListener(fileListener);
    }

    public void fireFireChangedEvent(FileListenerEvent event) {
        if (this.watcher == null) {
            throw new IllegalStateException("FileWatcher has not been set");
        }
        FileListener[] listener = this.watcher.getFileListeners();
        int num = listener.length;
        int i = 0;
        while (i < num) {
            listener[i].fileChanged(event);
            ++i;
        }
    }

    public abstract File getFile();

    public abstract void store(Configuration var1) throws ConfigurationManagerException;

    public abstract Configuration load() throws ConfigurationManagerException;
}

