/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.utils.ConfigErrorHandler;
import org.jconfig.utils.XMLConfigParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class URLHandler
implements ConfigurationHandler {
    private boolean validate = false;
    private String url;

    public void setURL(String url) {
        this.url = url;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public synchronized Configuration load() throws ConfigurationManagerException {
        return this.load(this.url);
    }

    public synchronized Configuration load(String theURL) throws ConfigurationManagerException {
        URL jcfURL = null;
        InputStream is = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream jcf = cl.getResourceAsStream("jconfig.properties");
            if (jcf != null) {
                Properties jcfProperties = new Properties();
                jcfProperties.load(jcf);
                Properties prop = System.getProperties();
                if (jcfProperties.getProperty("http.proxyHost") != null) {
                    ((Hashtable)prop).put("http.proxyHost", jcfProperties.getProperty("http.proxyHost"));
                }
                if (jcfProperties.getProperty("http.proxyPort") != null) {
                    ((Hashtable)prop).put("http.proxyPort", jcfProperties.getProperty("http.proxyPort"));
                }
            }
            jcfURL = new URL(theURL);
            URLConnection con = jcfURL.openConnection();
            is = con.getInputStream();
        }
        catch (Exception e) {
            throw new ConfigurationManagerException("Problem with URL handling/connection/validating: " + e.getMessage());
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(this.validate);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigurationManagerException("The parser cannot create a new document builder: " + pce.getMessage());
        }
        if (this.validate) {
            try {
                OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                db.setErrorHandler(new ConfigErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            }
            catch (Exception e) {
                throw new ConfigurationManagerException("The parser cannot set up the error handler");
            }
        }
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (SAXException se) {
            throw new ConfigurationManagerException("The parser cannot parse the XML: " + se.getMessage());
        }
        catch (IOException ioe) {
            throw new ConfigurationManagerException("The parser cannot open the file: " + ioe.getMessage());
        }
        return XMLConfigParser.parse(doc);
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
    }
}

