/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.handler.BaseXMLHandler;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.utils.ConfigErrorHandler;
import org.jconfig.utils.XMLConfigParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLFileHandler
extends BaseXMLHandler
implements ConfigurationHandler {
    private boolean validate = false;
    private File file;

    public XMLFileHandler() {
    }

    public XMLFileHandler(String filename) {
        this.file = new File(filename);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public synchronized Configuration load() throws ConfigurationManagerException {
        return this.load(this.file);
    }

    public synchronized Configuration load(File file) throws ConfigurationManagerException {
        if (file == null) {
            throw new ConfigurationManagerException("The file is NULL");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(this.validate);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigurationManagerException("The parser cannot create a new document builder: " + pce.getMessage());
        }
        if (this.validate) {
            try {
                OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                db.setErrorHandler(new ConfigErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            }
            catch (Exception e) {
                throw new ConfigurationManagerException("The parser cannot set up the error handler");
            }
        }
        Document doc = null;
        try {
            doc = db.parse(file);
        }
        catch (SAXException se) {
            throw new ConfigurationManagerException("The parser cannot parse the file: " + se.getMessage());
        }
        catch (IOException ioe) {
            throw new ConfigurationManagerException("The parser cannot open the file: " + ioe.getMessage());
        }
        return XMLConfigParser.parse(doc);
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        this.store(this.file, configuration);
    }

    public File getFile() {
        return this.file;
    }
}

