/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResourceLocator
implements Serializable {
    private String name;
    private File file;
    private URL url;
    static /* synthetic */ Class class$org$jconfig$utils$ResourceLocator;

    public ResourceLocator(String name) throws IOException {
        this.name = name;
        SecurityException exception = null;
        try {
            if (this.tryClasspath(name)) {
                return;
            }
        }
        catch (SecurityException e) {
            exception = e;
        }
        try {
            if (this.tryLoader(name)) {
                return;
            }
        }
        catch (SecurityException e) {
            exception = e;
        }
        String msg = "";
        if (exception != null) {
            msg = ": " + exception;
        }
        throw new IOException("Resource '" + name + "' could not be found in " + "the CLASSPATH (" + System.getProperty("java.class.path") + "), nor could it be located by the classloader responsible for the " + "web application (WEB-INF/classes)" + msg);
    }

    public InputStream findResource(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        if (this.url != null) {
            return new BufferedInputStream(this.url.openStream());
        }
        return null;
    }

    public long lastModified() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        if (this.url != null) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                return Long.MAX_VALUE;
            }
        }
        return 0L;
    }

    public String getDirectory() {
        if (this.file != null) {
            return this.file.getParent();
        }
        if (this.url != null) {
            return null;
        }
        return null;
    }

    private boolean tryClasspath(String filename) {
        String classpath = System.getProperty("java.class.path");
        String[] paths = ResourceLocator.split(classpath, File.pathSeparator);
        this.file = ResourceLocator.searchDirectories(paths, filename);
        return this.file != null;
    }

    private static File searchDirectories(String[] paths, String filename) {
        SecurityException exception = null;
        int i = 0;
        while (i < paths.length) {
            try {
                File file = new File(paths[i], filename);
                if (file.exists() && !file.isDirectory()) {
                    return file;
                }
            }
            catch (SecurityException e) {
                exception = e;
            }
            ++i;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    private static String[] split(String str, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            v.addElement(tokenizer.nextToken());
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    private boolean tryLoader(String name) {
        URL res = (class$org$jconfig$utils$ResourceLocator == null ? (class$org$jconfig$utils$ResourceLocator = ResourceLocator.class$("org.jconfig.utils.ResourceLocator")) : class$org$jconfig$utils$ResourceLocator).getResource(name = "/" + name);
        if (res == null) {
            return false;
        }
        File resFile = ResourceLocator.urlToFile(res);
        if (resFile != null) {
            this.file = resFile;
        } else {
            this.url = res;
        }
        return true;
    }

    private static File urlToFile(URL res) {
        String externalForm = res.toExternalForm();
        if (externalForm.startsWith("file:")) {
            return new File(externalForm.substring(5));
        }
        return null;
    }

    public String toString() {
        return "[Resource: File: " + this.file + " URL: " + this.url + "]";
    }

    public File getFile() {
        return this.file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

