/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.utils;

import org.jconfig.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigParser {
    private XMLConfigParser() {
    }

    private static void getVariables(Document doc, Configuration config) {
        NodeList nl = doc.getElementsByTagName("variables");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            Node child = n.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals("variable")) {
                    NamedNodeMap myAtt = child.getAttributes();
                    Node myNode = myAtt.getNamedItem("name");
                    String name = myNode.getNodeValue();
                    myNode = myAtt.getNamedItem("value");
                    String value = myNode.getNodeValue();
                    if (name != null && value != null) {
                        config.setVariable(name, value);
                    }
                }
                child = child.getNextSibling();
            }
            ++i;
        }
    }

    public static Configuration parse(Document doc) {
        Configuration configuration = new Configuration(null);
        XMLConfigParser.getVariables(doc, configuration);
        NodeList nl = doc.getElementsByTagName("category");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentCategory = curNode.getNodeValue();
            configuration.setCategory(currentCategory);
            Node child = n.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals("property")) {
                    NamedNodeMap myAtt = child.getAttributes();
                    Node myNode = myAtt.getNamedItem("name");
                    String name = myNode.getNodeValue();
                    myNode = myAtt.getNamedItem("value");
                    String value = myNode.getNodeValue();
                    if (name != null && value != null) {
                        configuration.setProperty(name, value, currentCategory);
                    }
                }
                child = child.getNextSibling();
            }
            ++i;
        }
        return configuration;
    }
}

