/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.ant;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractQdoxTask
extends Task {
    private Vector filesets = new Vector();
    protected HashMap fileMap = new HashMap();
    protected ArrayList allSources = new ArrayList();
    protected ArrayList allClasses = new ArrayList();

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    protected void buildFileMap() {
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.buildFileMap(fileSet.getDir(this.getProject()), stringArray);
            ++n;
        }
    }

    protected void buildFileMap(File file, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            this.fileMap.put(file2.getAbsolutePath(), file2);
            ++n;
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.buildFileMap();
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
        this.mergeBuilderSources(javaDocBuilder);
        JavaSource[] javaSourceArray = javaDocBuilder.getSources();
        this.processSources(javaSourceArray);
    }

    private void mergeBuilderSources(JavaDocBuilder javaDocBuilder) {
        Iterator iterator = this.fileMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            javaDocBuilder.addSourceTree((File)this.fileMap.get(string));
        }
    }

    protected void processSources(JavaSource[] javaSourceArray) {
        int n = 0;
        while (n < javaSourceArray.length) {
            JavaSource javaSource = javaSourceArray[n];
            this.allSources.add(javaSource);
            JavaClass[] javaClassArray = javaSource.getClasses();
            this.processClasses(javaClassArray);
            ++n;
        }
    }

    protected void processClasses(JavaClass[] javaClassArray) {
        int n = 0;
        while (n < javaClassArray.length) {
            JavaClass javaClass = javaClassArray[n];
            this.allClasses.add(javaClass);
            ++n;
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source fileset.");
        }
    }
}

