/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.directorywalker;

import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class DirectoryScanner {
    private File _file;
    private Collection _filters = new HashSet();

    public DirectoryScanner(File file) {
        this._file = file;
    }

    public File[] scan() {
        final ArrayList arrayList = new ArrayList();
        this.walk(new FileVisitor(){

            public void visitFile(File file) {
                arrayList.add(file);
            }
        }, this._file);
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    private void walk(FileVisitor fileVisitor, File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.walk(fileVisitor, fileArray[n]);
                ++n;
            }
        } else {
            Iterator iterator = this._filters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                if (filter.filter(file)) continue;
                return;
            }
            fileVisitor.visitFile(file);
        }
    }

    public void addFilter(Filter filter) {
        this._filters.add(filter);
    }

    public void scan(FileVisitor fileVisitor) {
        this.walk(fileVisitor, this._file);
    }
}

