/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.IndentBuffer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractJavaEntity
implements Serializable {
    protected String name;
    protected List modifiers = new ArrayList();
    private String comment;
    private DocletTag[] tags = new DocletTag[0];

    public String getName() {
        return this.name;
    }

    public String[] getModifiers() {
        return this.modifiers.toArray(new String[this.modifiers.size()]);
    }

    public String getComment() {
        return this.comment;
    }

    public DocletTag[] getTags() {
        return this.tags;
    }

    public DocletTag[] getTagsByName(String string) {
        ArrayList<DocletTag> arrayList = new ArrayList<DocletTag>();
        int n = 0;
        while (n < this.tags.length) {
            DocletTag docletTag = this.tags[n];
            if (docletTag.getName().equals(string)) {
                arrayList.add(docletTag);
            }
            ++n;
        }
        return arrayList.toArray(new DocletTag[arrayList.size()]);
    }

    public DocletTag getTagByName(String string) {
        int n = 0;
        while (n < this.tags.length) {
            DocletTag docletTag = this.tags[n];
            if (docletTag.getName().equals(string)) {
                return docletTag;
            }
            ++n;
        }
        return null;
    }

    void commentHeader(IndentBuffer indentBuffer) {
        if (this.comment == null && (this.tags == null || this.tags.length == 0)) {
            return;
        }
        indentBuffer.write("/**");
        indentBuffer.newline();
        if (this.comment != null && this.comment.length() > 0) {
            indentBuffer.write(" * ");
            indentBuffer.write(this.comment);
            indentBuffer.newline();
        }
        if (this.tags != null && this.tags.length > 0) {
            if (this.comment != null && this.comment.length() > 0) {
                indentBuffer.write(" *");
                indentBuffer.newline();
            }
            int n = 0;
            while (n < this.tags.length) {
                DocletTag docletTag = this.tags[n];
                indentBuffer.write(" * @");
                indentBuffer.write(docletTag.getName());
                if (docletTag.getValue().length() > 0) {
                    indentBuffer.write(' ');
                    indentBuffer.write(docletTag.getValue());
                }
                indentBuffer.newline();
                ++n;
            }
        }
        indentBuffer.write(" */");
        indentBuffer.newline();
    }

    public String toString() {
        IndentBuffer indentBuffer = new IndentBuffer();
        this.write(indentBuffer);
        return indentBuffer.toString();
    }

    protected void write(IndentBuffer indentBuffer) {
        this.commentHeader(indentBuffer);
        this.writeBody(indentBuffer);
    }

    protected abstract void writeBody(IndentBuffer var1);

    public void setName(String string) {
        this.name = string;
    }

    public void setModifiers(String[] stringArray) {
        this.modifiers = Arrays.asList(stringArray);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setTags(List list) {
        this.tags = new DocletTag[list.size()];
        list.toArray(this.tags);
    }

    public boolean isAbstract() {
        return this.isModifierPresent("abstract");
    }

    public boolean isPublic() {
        return this.isModifierPresent("public");
    }

    public boolean isPrivate() {
        return this.isModifierPresent("private");
    }

    public boolean isProtected() {
        return this.isModifierPresent("protected");
    }

    public boolean isStatic() {
        return this.isModifierPresent("static");
    }

    public boolean isFinal() {
        return this.isModifierPresent("final");
    }

    public boolean isSynchronized() {
        return this.isModifierPresent("synchronized");
    }

    private boolean isModifierPresent(String string) {
        return this.modifiers.contains(string);
    }

    protected void writeNonAccessibilityModifiers(IndentBuffer indentBuffer) {
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("p")) continue;
            indentBuffer.write(string);
            indentBuffer.write(' ');
        }
    }

    protected void writeAccessibilityModifier(IndentBuffer indentBuffer) {
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("p")) continue;
            indentBuffer.write(string);
            indentBuffer.write(' ');
        }
    }

    protected void writeAllModifiers(IndentBuffer indentBuffer) {
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            indentBuffer.write(string);
            indentBuffer.write(' ');
        }
    }
}

