/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.parser.Builder;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ModelBuilder
implements Builder {
    private ClassLibrary classLibrary;
    private JavaSource source;
    private JavaClassParent currentParent;
    private JavaClass currentClass;
    private String lastComment;
    private List lastTagSet;

    public ModelBuilder() {
        this(new ClassLibrary(null));
    }

    public ModelBuilder(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
        this.source = new JavaSource();
        this.source.setClassLibrary(classLibrary);
        this.currentParent = this.source;
    }

    public void addPackage(String string) {
        this.source.setPackage(string);
    }

    public void addImport(String string) {
        this.source.addImport(string);
    }

    public void addJavaDoc(String string) {
        this.lastComment = string;
        this.lastTagSet = new LinkedList();
    }

    public void addJavaDocTag(String string, String string2) {
        this.lastTagSet.add(new DocletTag(string, string2));
    }

    public void beginClass(ClassDef classDef) {
        this.currentClass = new JavaClass();
        this.currentClass.setName(classDef.name);
        this.currentClass.setInterface(classDef.isInterface);
        if (classDef.isInterface) {
            this.currentClass.setSuperClass(null);
        } else {
            this.currentClass.setSuperClass(classDef.extendz.size() > 0 ? this.createType((String)classDef.extendz.toArray()[0], 0) : null);
        }
        String[] stringArray = classDef.isInterface ? classDef.extendz : classDef.implementz;
        Iterator iterator = stringArray.iterator();
        Type[] typeArray = new Type[stringArray.size()];
        int n = 0;
        while (n < typeArray.length && iterator.hasNext()) {
            typeArray[n] = this.createType((String)iterator.next(), 0);
            ++n;
        }
        this.currentClass.setImplementz(typeArray);
        stringArray = new String[classDef.modifiers.size()];
        classDef.modifiers.toArray(stringArray);
        this.currentClass.setModifiers(stringArray);
        this.addJavaDoc(this.currentClass);
        this.currentParent.addClass(this.currentClass);
        this.currentParent = this.currentClass;
        this.classLibrary.add(this.currentClass.getFullyQualifiedName());
    }

    public void endClass() {
        this.currentParent = this.currentClass.getParent();
        this.currentClass = this.currentParent instanceof JavaClass ? (JavaClass)this.currentParent : null;
    }

    private Type createType(String string, int n) {
        if (string == null || string.equals("")) {
            return null;
        }
        return new Type(string, n, this.source);
    }

    private void addJavaDoc(AbstractJavaEntity abstractJavaEntity) {
        if (this.lastComment != null) {
            abstractJavaEntity.setComment(this.lastComment);
            abstractJavaEntity.setTags(this.lastTagSet);
        }
        this.lastComment = null;
    }

    public void addMethod(MethodDef methodDef) {
        JavaMethod javaMethod = new JavaMethod();
        javaMethod.setName(methodDef.name);
        javaMethod.setReturns(this.createType(methodDef.returns, methodDef.dimensions));
        javaMethod.setConstructor(methodDef.constructor);
        Object[] objectArray = new JavaParameter[methodDef.params.size()];
        int n = 0;
        Iterator iterator = methodDef.params.iterator();
        while (iterator.hasNext()) {
            FieldDef fieldDef = (FieldDef)iterator.next();
            objectArray[n++] = new JavaParameter(this.createType(fieldDef.type, fieldDef.dimensions), fieldDef.name);
        }
        javaMethod.setParameters((JavaParameter[])objectArray);
        objectArray = new Type[methodDef.exceptions.size()];
        n = 0;
        iterator = methodDef.exceptions.iterator();
        while (iterator.hasNext()) {
            objectArray[n++] = this.createType((String)iterator.next(), 0);
        }
        javaMethod.setExceptions((Type[])objectArray);
        objectArray = new String[methodDef.modifiers.size()];
        methodDef.modifiers.toArray(objectArray);
        javaMethod.setModifiers((String[])objectArray);
        this.addJavaDoc(javaMethod);
        this.currentClass.addMethod(javaMethod);
    }

    public void addField(FieldDef fieldDef) {
        JavaField javaField = new JavaField();
        javaField.setName(fieldDef.name);
        javaField.setType(this.createType(fieldDef.type, fieldDef.dimensions));
        String[] stringArray = new String[fieldDef.modifiers.size()];
        fieldDef.modifiers.toArray(stringArray);
        javaField.setModifiers(stringArray);
        this.addJavaDoc(javaField);
        this.currentClass.addField(javaField);
    }

    public JavaSource getSource() {
        return this.source;
    }
}

