/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.template.TemplateTagHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class RelationTagsHandler
extends EjbTagsHandler {
    protected static Map relationMap = new HashMap();
    protected static RelationHolder currentRelation;
    static /* synthetic */ Class class$xdoclet$modules$ejb$dd$RelationTagsHandler;
    static /* synthetic */ Class class$xdoclet$modules$ejb$XDocletModulesEjbMessages;

    public void ifLeftCascadeDelete(String template) throws XDocletException {
        if (currentRelation.isLeftCascadeDelete()) {
            this.generate(template);
        }
    }

    public void ifRightCascadeDelete(String template) throws XDocletException {
        if (currentRelation.isRightCascadeDelete()) {
            this.generate(template);
        }
    }

    public String leftEJBName() throws XDocletException {
        if (currentRelation.getLeft() != null) {
            return EjbTagsHandler.getEjbNameFor(currentRelation.getLeft());
        }
        String name = XDocletTagSupport.getTagValue((int)1, (XDoc)currentRelation.getRightMethod().getDoc(), (String)"ejb:relation", (String)"target-ejb", null, null, (boolean)true, (!currentRelation.isBidirectional() ? 1 : 0) != 0);
        return name;
    }

    public String rightEJBName() throws XDocletException {
        if (currentRelation.getRight() != null) {
            return EjbTagsHandler.getEjbNameFor(currentRelation.getRight());
        }
        String name = XDocletTagSupport.getTagValue((int)1, (XDoc)currentRelation.getLeftMethod().getDoc(), (String)"ejb:relation", (String)"target-ejb", null, null, (boolean)true, (!currentRelation.isBidirectional() ? 1 : 0) != 0);
        return name;
    }

    public void ifHasRelationships(String template) throws XDocletException {
        Collection classes = TemplateTagHandler.getXJavaDoc().getSourceClasses();
        boolean hasRelationships = false;
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            XDocletTagSupport.setCurrentClass((XClass)clazz);
            List methods = clazz.getMethods();
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                XMethod method = (XMethod)j.next();
                XDocletTagSupport.setCurrentMethod((XMethod)method);
                XTag relation = method.getDoc().getTag("ejb:relation");
                if (relation == null) continue;
                hasRelationships = true;
                break;
            }
            if (hasRelationships) break;
        }
        if (hasRelationships) {
            this.generate(template);
        }
    }

    public String relationName() throws XDocletException {
        return currentRelation.getName();
    }

    public void forAllRelationships(String template) throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$ejb$dd$RelationTagsHandler == null ? (class$xdoclet$modules$ejb$dd$RelationTagsHandler = RelationTagsHandler.class$("xdoclet.modules.ejb.dd.RelationTagsHandler")) : class$xdoclet$modules$ejb$dd$RelationTagsHandler), (String)"forAllRelationships");
        Collection classes = TemplateTagHandler.getXJavaDoc().getSourceClasses();
        relationMap.clear();
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            XClass clazz = (XClass)i.next();
            XDocletTagSupport.setCurrentClass((XClass)clazz);
            List methods = clazz.getMethods();
            Iterator j = methods.iterator();
            while (j.hasNext()) {
                XMethod method = (XMethod)j.next();
                XDocletTagSupport.setCurrentMethod((XMethod)method);
                XTag relationTag = method.getDoc().getTag("ejb:relation");
                if (relationTag == null) continue;
                String relationName = relationTag.getAttributeValue("name");
                if (relationName == null) {
                    throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ejb$XDocletModulesEjbMessages == null ? (class$xdoclet$modules$ejb$XDocletModulesEjbMessages = RelationTagsHandler.class$("xdoclet.modules.ejb.XDocletModulesEjbMessages")) : class$xdoclet$modules$ejb$XDocletModulesEjbMessages), (String)"RELATION_MUST_HAVE_NAME", (String[])new String[]{XDocletTagSupport.getCurrentClass().getName()}));
                }
                RelationHolder relationHolder = (RelationHolder)relationMap.get(relationName);
                if (relationHolder != null && relationHolder.getLeft() != null && relationHolder.getRight() != null) {
                    String leftSignature = relationHolder.getLeftMethod().getContainingClass().getQualifiedName() + "." + relationHolder.getLeftMethod();
                    String rightSignature = relationHolder.getRightMethod().getContainingClass().getQualifiedName() + "." + relationHolder.getRightMethod();
                    String currentSignature = method.getContainingClass().getQualifiedName() + "." + method;
                    throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ejb$XDocletModulesEjbMessages == null ? (class$xdoclet$modules$ejb$XDocletModulesEjbMessages = RelationTagsHandler.class$("xdoclet.modules.ejb.XDocletModulesEjbMessages")) : class$xdoclet$modules$ejb$XDocletModulesEjbMessages), (String)"RELATION_TOO_MANY_NAMES", (String[])new String[]{relationName, leftSignature, rightSignature, currentSignature}));
                }
                if (relationHolder == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Created new relationship for " + clazz + "." + method));
                    }
                    relationHolder = new RelationHolder();
                    relationHolder.left = clazz;
                    relationHolder.leftMethod = method;
                    relationMap.put(relationName, relationHolder);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added " + clazz + " to relationship: " + relationHolder));
                }
                relationHolder.right = clazz;
                relationHolder.rightMethod = method;
            }
        }
        Iterator relations = relationMap.entrySet().iterator();
        while (relations.hasNext()) {
            Map.Entry entry = relations.next();
            RelationHolder relationHolder = (RelationHolder)entry.getValue();
            if (relationHolder.isLeftMany() && !relationHolder.isRightMany()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Swapping left -> right in attempt to make 1-n be 1-n (rather than n-1)");
                }
                relationHolder.swap();
            }
            if (relationHolder.isBidirectional() || !relationHolder.isOne2Many() || relationHolder.getLeftMethod() != null) continue;
            relationHolder.swap();
        }
        Iterator relationNameIterator = relationMap.keySet().iterator();
        while (relationNameIterator.hasNext()) {
            String relationName = (String)relationNameIterator.next();
            RelationHolder relationHolder = (RelationHolder)relationMap.get(relationName);
            XDocletTagSupport.setCurrentClass((XClass)relationHolder.getLeft());
            XDocletTagSupport.setCurrentMethod((XMethod)relationHolder.getLeftMethod());
            currentRelation = relationHolder;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generating template for Relation: " + currentRelation));
            }
            this.generate(template);
        }
    }

    public void ifIsLeftMany(String template) throws XDocletException {
        if (currentRelation.isLeftMany()) {
            this.generate(template);
        }
    }

    public void ifIsRightMany(String template) throws XDocletException {
        if (currentRelation.isRightMany()) {
            this.generate(template);
        }
    }

    public String leftFieldName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor((XMethod)currentRelation.getLeftMethod());
    }

    public String rightFieldName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor((XMethod)currentRelation.getRightMethod());
    }

    public String leftFieldType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor((XMethod)currentRelation.getLeftMethod());
    }

    public String rightFieldType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor((XMethod)currentRelation.getRightMethod());
    }

    public void ifIsNotACollection(String template) throws XDocletException {
        if (!this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor((XMethod)XDocletTagSupport.getCurrentMethod()))) {
            this.generate(template);
        }
    }

    public String relationComment() {
        return "<!-- " + currentRelation.toString() + " -->";
    }

    public void ifIsOne2One(String template) throws XDocletException {
        if (currentRelation.isOne2One()) {
            this.generate(template);
        }
    }

    public void ifNotIsOne2One(String template) throws XDocletException {
        if (!currentRelation.isOne2One()) {
            this.generate(template);
        }
    }

    public void ifIsOne2Many(String template) throws XDocletException {
        if (currentRelation.isOne2Many()) {
            this.generate(template);
        }
    }

    public void ifNotIsOne2Many(String template) throws XDocletException {
        if (!currentRelation.isOne2Many()) {
            this.generate(template);
        }
    }

    public void ifIsMany2Many(String template) throws XDocletException {
        if (currentRelation.isMany2Many()) {
            this.generate(template);
        }
    }

    public void ifNotIsMany2Many(String template) throws XDocletException {
        if (!currentRelation.isMany2Many()) {
            this.generate(template);
        }
    }

    public void ifIsBidirectional(String template) throws XDocletException {
        if (currentRelation.isBidirectional()) {
            this.generate(template);
        }
    }

    public void ifIsUnidirectional(String template) throws XDocletException {
        if (!currentRelation.isBidirectional()) {
            this.generate(template);
        }
    }

    public void ifHasLeftRoleName(String template) throws XDocletException {
        if (this.leftRoleName() != null) {
            this.generate(template);
        }
    }

    public void ifHasRightRoleName(String template) throws XDocletException {
        if (this.rightRoleName() != null) {
            this.generate(template);
        }
    }

    public void ifLeftNavigable(String template) throws XDocletException {
        if (currentRelation.isLeftNavigable()) {
            this.generate(template);
        }
    }

    public void ifRightNavigable(String template) throws XDocletException {
        if (currentRelation.isRightNavigable()) {
            this.generate(template);
        }
    }

    public String leftRoleName() throws XDocletException {
        return currentRelation.getLeftRoleName();
    }

    public String rightRoleName() throws XDocletException {
        return currentRelation.getRightRoleName();
    }

    public String leftMultiplicity() throws XDocletException {
        return currentRelation.getLeftMultiplicity();
    }

    public String rightMultiplicity() throws XDocletException {
        return currentRelation.getRightMultiplicity();
    }

    protected boolean isSetOrCollection(String type) {
        return type.equals("java.util.Collection") || type.equals("java.util.Set");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$400(int x0, XDoc x1, String x2, String x3, String x4, String x5, boolean x6, boolean x7) throws XDocletException {
        return XDocletTagSupport.getTagValue((int)x0, (XDoc)x1, (String)x2, (String)x3, (String)x4, (String)x5, (boolean)x6, (boolean)x7);
    }

    public class RelationHolder {
        private static final String ONE = "One";
        private static final String MANY = "Many";
        private XClass left;
        private XMethod leftMethod;
        private XClass right;
        private XMethod rightMethod;

        public boolean isBidirectional() {
            return this.getRightMethod() != null && this.getLeftMethod() != null;
        }

        public boolean isOne2One() throws XDocletException {
            return !this.isLeftMany() && !this.isRightMany();
        }

        public boolean isOne2Many() throws XDocletException {
            return !this.isLeftMany() && this.isRightMany();
        }

        public boolean isMany2Many() throws XDocletException {
            return this.isLeftMany() && this.isRightMany();
        }

        public String getLeftMultiplicity() throws XDocletException {
            return this.isLeftMany() ? MANY : ONE;
        }

        public String getRightMultiplicity() throws XDocletException {
            return this.isRightMany() ? MANY : ONE;
        }

        public XClass getLeft() {
            return this.left;
        }

        public XMethod getLeftMethod() {
            return this.leftMethod;
        }

        public XClass getRight() {
            return this.right;
        }

        public XMethod getRightMethod() {
            return this.rightMethod;
        }

        public boolean isRightNavigable() {
            return this.getRightMethod() != null;
        }

        public boolean isLeftNavigable() {
            return this.getLeftMethod() != null;
        }

        public String getLeftRoleName() throws XDocletException {
            String result = null;
            result = this.getLeftMethod() != null ? this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "role-name", false) : this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "target-role-name", false);
            return result;
        }

        public String getRightRoleName() throws XDocletException {
            String result = null;
            result = this.getRightMethod() != null ? this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "role-name", false) : this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "target-role-name", false);
            return result;
        }

        public boolean isLeftMany() throws XDocletException {
            boolean result;
            if (this.getLeftMethod() != null) {
                result = RelationTagsHandler.this.isSetOrCollection(this.getLeftMethod().getReturnType().getType().getQualifiedName());
            } else {
                String targetMultiple = this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "target-multiple", false);
                result = TypeConversionUtil.stringToBoolean((String)targetMultiple, (boolean)false);
            }
            return result;
        }

        public boolean isRightMany() throws XDocletException {
            boolean result;
            if (this.getRightMethod() != null) {
                result = RelationTagsHandler.this.isSetOrCollection(this.getRightMethod().getReturnType().getType().getQualifiedName());
            } else {
                String targetMultiple = this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "target-multiple", false);
                result = TypeConversionUtil.stringToBoolean((String)targetMultiple, (boolean)false);
            }
            return result;
        }

        public boolean isLeftCascadeDelete() throws XDocletException {
            boolean result = this.getLeftMethod() != null ? this.isCascadeDelete(this.getLeftMethod(), "cascade-delete") : this.isCascadeDelete(this.getRightMethod(), "target-cascade-delete");
            return result;
        }

        public boolean isRightCascadeDelete() throws XDocletException {
            boolean result = this.getRightMethod() != null ? this.isCascadeDelete(this.getRightMethod(), "cascade-delete") : this.isCascadeDelete(this.getLeftMethod(), "target-cascade-delete");
            return result;
        }

        public String getName() throws XDocletException {
            String result = null;
            result = this.getRightMethod() != null ? this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "name", false) : this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "name", false);
            return result;
        }

        public void swap() {
            XClass c = this.right;
            XMethod m = this.rightMethod;
            this.right = this.left;
            this.rightMethod = this.leftMethod;
            this.left = c;
            this.leftMethod = m;
        }

        public int hashCode() {
            int result = 17;
            if (this.getLeft() != null) {
                result = 37 * result + this.getLeft().hashCode();
            }
            if (this.getLeftMethod() != null) {
                result = 37 * result + this.getLeftMethod().hashCode();
            }
            if (this.getRight() != null) {
                result = 37 * result + this.getRight().hashCode();
            }
            if (this.getRightMethod() != null) {
                result = 37 * result + this.getRightMethod().hashCode();
            }
            return result;
        }

        public String toString() {
            return "RelationHolder left=" + this.getLeft() + '.' + this.getLeftMethod() + " right=" + this.getRight() + '.' + this.getRightMethod();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationHolder)) {
                return false;
            }
            RelationHolder other = (RelationHolder)o;
            return (this.getLeft() == null ? other.getLeft() == null : this.getLeft().equals(other.getLeft())) && (this.getLeftMethod() == null ? other.getLeftMethod() == null : this.getLeftMethod().equals(other.getLeftMethod())) && (this.getRight() == null ? other.getRight() == null : this.getRight().equals(other.getRight())) && (this.getRightMethod() == null ? other.getRightMethod() == null : this.getRightMethod().equals(other.getRightMethod()));
        }

        private boolean isCascadeDelete(XMethod method, String tag) throws XDocletException {
            String cd = null;
            cd = RelationTagsHandler.access$400(1, method.getDoc(), "ejb:relation", tag, "yes,no,true,false", "no", false, false);
            return TypeConversionUtil.stringToBoolean((String)cd, (boolean)false);
        }
    }
}

