/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.infrastructure.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.CLOB;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDAO {
    protected static Log log = LogFactory.getLog((String)(class$gov$epa$cdx$ws$infrastructure$dao$WSDAO == null ? (class$gov$epa$cdx$ws$infrastructure$dao$WSDAO = WSDAO.class$("gov.epa.cdx.ws.infrastructure.dao.WSDAO")) : class$gov$epa$cdx$ws$infrastructure$dao$WSDAO).getName());
    private static final String PASS_THROUGH = "{ call ws_prv.p_ap_cdx_node_passthrough(?,?,?,?)}";
    private static final String UTILITY = "WS";
    static /* synthetic */ Class class$gov$epa$cdx$ws$infrastructure$dao$WSDAO;

    public static String loadMonitorData(byte[] data) throws CDXException, IOException {
        log.debug((Object)"Starting Monitor Data load.");
        Connection conn = null;
        CallableStatement cSt = null;
        Object requestBlob = null;
        String outMsg = null;
        int err = 0;
        try {
            conn = BaseDAO.getConnection();
            cSt = conn.prepareCall(PASS_THROUGH);
            CLOB metadataClob = CLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
            BufferedWriter outClob = new BufferedWriter(metadataClob.getCharacterOutputStream());
            outClob.write(new String(data));
            outClob.close();
            cSt.setString(1, UTILITY);
            cSt.setClob(2, (Clob)metadataClob);
            cSt.registerOutParameter(3, 2005);
            cSt.registerOutParameter(4, 4);
            cSt.execute();
            log.debug((Object)"Monitor Data load stored procedure completed.");
            err = cSt.getInt(4);
            log.debug((Object)("From stored procedure, status int is: " + err));
            Clob dataOut = cSt.getClob(3);
            BufferedReader dataOutReader = new BufferedReader(dataOut.getCharacterStream());
            StringBuffer dataBuffer = new StringBuffer();
            String line = null;
            while ((line = dataOutReader.readLine()) != null) {
                dataBuffer.append(line);
            }
            dataOutReader.close();
            outMsg = dataBuffer.toString();
            log.debug((Object)("From stored procedure, outMsg is: " + outMsg));
            cSt.close();
            if (err == 0) {
                log.debug((Object)"No outMsg, means no errors.");
                outMsg = null;
            }
        }
        catch (CDXException e) {
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)"Database Failure.  Couldn't execute loadMonitorData.", (Throwable)e);
            throw new CDXDAOException(CDXErrorCode.DATABASE_FAILURE, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error creating CLOB.  Stored Procedure loadMonitorData not executed.", (Throwable)e);
            throw e;
        }
        finally {
            BaseDAO.closeConnection((Connection)conn);
        }
        return outMsg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

