/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.infrastructure.extractor;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.zip.ZipUtil;
import gov.epa.cdx.infrastructure.extractor.ExtractorParser;
import gov.epa.cdx.infrastructure.extractor.HeaderDigester;
import gov.epa.cdx.infrastructure.extractor.HeaderHandler;
import gov.epa.cdx.infrastructure.extractor.MultiPayloadHandler;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.header.HeaderVO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class ExtractorManager {
    private static final transient LogInterface logger = LogFactory.getLog((String)(class$gov$epa$cdx$ws$infrastructure$extractor$ExtractorManager == null ? (class$gov$epa$cdx$ws$infrastructure$extractor$ExtractorManager = ExtractorManager.class$("gov.epa.cdx.ws.infrastructure.extractor.ExtractorManager")) : class$gov$epa$cdx$ws$infrastructure$extractor$ExtractorManager).getName());
    static /* synthetic */ Class class$gov$epa$cdx$ws$infrastructure$extractor$ExtractorManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HeaderVO extractHeader(DocumentVO document) throws CDXException {
        HeaderVO headerVO;
        HeaderVO result = null;
        HeaderDigester digester = new HeaderDigester();
        FileReader fullXML = null;
        BufferedReader fullXMLBuffer = null;
        StringWriter headerXMLWriter = new StringWriter();
        StringReader headerXMLReader = null;
        File tempDirectory = null;
        if (!ExtractorManager.isValid(document)) {
            throw new CDXException(CDXErrorCode.INVALID_DOCUMENT_TYPE, (Throwable)new IllegalArgumentException("document is invalid for header extraction"));
        }
        try {
            try {
                tempDirectory = ExtractorManager.getTempDirectory(document.getID());
                FileUtils.forceMkdir((File)tempDirectory);
                File fullFile = ExtractorManager.writeFileToDisk(tempDirectory, document);
                fullXML = new FileReader(fullFile);
                fullXMLBuffer = new BufferedReader(fullXML);
                HeaderHandler handler = new HeaderHandler((Writer)headerXMLWriter);
                ExtractorParser.parse((Reader)fullXMLBuffer, (ContentHandler)handler, (ErrorHandler)handler);
                headerXMLReader = new StringReader(headerXMLWriter.toString());
                headerVO = result = digester.digest(new InputSource(headerXMLReader));
                Object var12_12 = null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            IOUtils.closeQuietly(fullXMLBuffer);
            IOUtils.closeQuietly(fullXML);
            IOUtils.closeQuietly(headerXMLReader);
            IOUtils.closeQuietly((Writer)headerXMLWriter);
            try {
                FileUtils.deleteDirectory((File)tempDirectory);
                throw throwable;
            }
            catch (IOException e2) {
                logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fullXMLBuffer);
        IOUtils.closeQuietly((Reader)fullXML);
        IOUtils.closeQuietly((Reader)headerXMLReader);
        IOUtils.closeQuietly((Writer)headerXMLWriter);
        try {}
        catch (IOException e2) {
            logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
            return headerVO;
        }
        FileUtils.deleteDirectory((File)tempDirectory);
        return headerVO;
    }

    public static DocumentVO extractPayload(DocumentVO document) throws CDXException {
        return (DocumentVO)ExtractorManager.extractPayloads(document).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List extractPayloads(DocumentVO document) throws CDXException {
        ArrayList<DocumentVO> arrayList;
        FileReader reader = null;
        BufferedReader buffer = null;
        File tempDirectory = null;
        if (!ExtractorManager.isValid(document)) {
            throw new CDXException(CDXErrorCode.INVALID_DOCUMENT_TYPE, (Throwable)new IllegalArgumentException("document is invalid for payload extraction"));
        }
        try {
            try {
                tempDirectory = ExtractorManager.getTempDirectory(document.getID());
                FileUtils.forceMkdir((File)tempDirectory);
                File fullFile = ExtractorManager.writeFileToDisk(tempDirectory, document);
                reader = new FileReader(fullFile);
                buffer = new BufferedReader(reader);
                MultiPayloadHandler handler = new MultiPayloadHandler(tempDirectory + "\\" + document.getID());
                ExtractorParser.parse((Reader)buffer, (ContentHandler)handler, (ErrorHandler)handler);
                ArrayList<DocumentVO> results = new ArrayList<DocumentVO>();
                for (int i = 0; i < handler.getFiles().size(); ++i) {
                    File temp = (File)handler.getFiles().get(i);
                    results.add(ExtractorManager.createDocument(temp, document, i));
                }
                arrayList = results;
                Object var10_11 = null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            IOUtils.closeQuietly(buffer);
            IOUtils.closeQuietly(reader);
            try {
                FileUtils.deleteDirectory((File)tempDirectory);
                throw throwable;
            }
            catch (IOException e2) {
                logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)buffer);
        IOUtils.closeQuietly((Reader)reader);
        try {}
        catch (IOException e2) {
            logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
            return arrayList;
        }
        FileUtils.deleteDirectory((File)tempDirectory);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentVO unzip(DocumentVO document) throws CDXException {
        DocumentVO documentVO;
        FileReader reader = null;
        BufferedReader buffer = null;
        File tempDirectory = null;
        int i = 1;
        if (!document.getDocumentType().equals((Object)DocumentType.ZIP)) {
            throw new CDXException(CDXErrorCode.INVALID_DOCUMENT_TYPE, (Throwable)new IllegalArgumentException("document is invalid for unzipping"));
        }
        try {
            try {
                DocumentVO unzippedDocument;
                tempDirectory = ExtractorManager.getTempDirectory(document.getID());
                FileUtils.forceMkdir((File)tempDirectory);
                File fullFile = ExtractorManager.writeFileToDisk(tempDirectory, document);
                reader = new FileReader(fullFile);
                buffer = new BufferedReader(reader);
                document.setDocumentType(DocumentType.XML);
                documentVO = unzippedDocument = ExtractorManager.createDocument(fullFile, document, i);
                Object var9_9 = null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            IOUtils.closeQuietly(buffer);
            IOUtils.closeQuietly(reader);
            try {
                FileUtils.deleteDirectory((File)tempDirectory);
                throw throwable;
            }
            catch (IOException e2) {
                logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)buffer);
        IOUtils.closeQuietly((Reader)reader);
        try {}
        catch (IOException e2) {
            logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
            return documentVO;
        }
        FileUtils.deleteDirectory((File)tempDirectory);
        return documentVO;
    }

    private static boolean isValid(DocumentVO document) {
        DocumentType type = document.getDocumentType();
        return document != null && document.getData() != null && document.getData().length > 0 && (type.equals((Object)DocumentType.ZIP) || type.equals((Object)DocumentType.XML));
    }

    private static File getTempDirectory(String documentId) throws CDXException {
        String tempDir = CDXPropertyManager.getProperty((String)"Extractor", (String)"TempDir");
        return new File(tempDir + "\\" + documentId);
    }

    private static File writeFileToDisk(File path, DocumentVO document) throws Exception {
        Object temp;
        FileOutputStream out = null;
        File file = new File(path + "\\" + document.getName());
        try {
            out = new FileOutputStream(file);
            CopyUtils.copy((byte[])document.getData(), (OutputStream)out);
            if (document.getDocumentType().equals((Object)DocumentType.ZIP)) {
                if (ZipUtil.zipEntries((File)file).size() != 1) {
                    throw new IllegalArgumentException("can not extract payload when zipfile has multiple entries");
                }
                temp = document.getID() + "-unzipped.xml";
                ZipUtil.unzip((File)file, (File)path, (String)temp);
                file = new File(path + "\\" + (String)temp);
            }
            temp = file;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return temp;
    }

    private static DocumentVO createDocument(File payloadFile, DocumentVO original, int count) throws Exception {
        DocumentVO documentVO;
        DocumentVO result = new DocumentVO();
        result.setDataFlowType(original.getDataflowTypeVO());
        result.setDocumentType(original.getDocumentType());
        FileInputStream fileIn = null;
        FileOutputStream fileOut = null;
        ZipOutputStream zipOut = null;
        try {
            File tempFile;
            if (original.getDocumentType().equals((Object)DocumentType.ZIP)) {
                tempFile = new File(payloadFile.getParent() + "\\" + original.getID() + "-payload" + count + ".zip");
                fileOut = new FileOutputStream(tempFile);
                zipOut = new ZipOutputStream(fileOut);
                ZipEntry entry = new ZipEntry(original.getID() + "-payload" + count + ".xml");
                zipOut.putNextEntry(entry);
                fileIn = new FileInputStream(payloadFile);
                CopyUtils.copy((InputStream)fileIn, (OutputStream)zipOut);
                IOUtils.closeQuietly((InputStream)fileIn);
                IOUtils.closeQuietly((OutputStream)zipOut);
                IOUtils.closeQuietly((OutputStream)fileOut);
            } else {
                tempFile = payloadFile;
            }
            fileIn = new FileInputStream(tempFile);
            byte[] data = IOUtils.toByteArray((InputStream)fileIn);
            result.setData(data);
            result.setName(tempFile.getName());
            documentVO = result;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipOut);
                IOUtils.closeQuietly(fileOut);
                IOUtils.closeQuietly(fileIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zipOut);
        IOUtils.closeQuietly(fileOut);
        IOUtils.closeQuietly((InputStream)fileIn);
        return documentVO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

