/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.ws.logic;

import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.ws.infrastructure.dao.WSDAO;
import gov.epa.cdx.ws.infrastructure.extractor.ExtractorManager;
import gov.epa.cdx.ws.logic.WSNodeManager;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSBackEndWorkerThread
implements Runnable {
    protected static Log log = LogFactory.getLog((String)(class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread == null ? (class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread = WSBackEndWorkerThread.class$("gov.epa.cdx.ws.logic.WSBackEndWorkerThread")) : class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread).getName());
    private static final String DB_ERROR = "Error with loading data to database.";
    private static final String LOOKUP_ERROR = "Error with loading ExtractorService class.";
    private static final String EXTRACT_ERROR = "Error with extracting (unzipping) file.";
    private DocumentList docs;
    static /* synthetic */ Class class$gov$epa$cdx$ws$logic$WSBackEndWorkerThread;

    public WSBackEndWorkerThread(DocumentList documents) {
        this.docs = documents;
    }

    public void run() {
        log.info((Object)("Begin asynchronous data loading for transaction " + this.docs.getTransaction().getTransactionID()));
        byte[] docFile = null;
        String returnMsg = null;
        boolean attemptLoad = true;
        DocumentVO onlyDoc = (DocumentVO)this.docs.getDocuments().iterator().next();
        DocumentVO unzippedDoc = null;
        try {
            unzippedDoc = ExtractorManager.unzip(onlyDoc);
            docFile = unzippedDoc.getData();
            log.debug((Object)"File unzipped Successfully.");
        }
        catch (CDXException e1) {
            log.error((Object)EXTRACT_ERROR, (Throwable)e1);
            returnMsg = EXTRACT_ERROR;
            attemptLoad = false;
        }
        if (attemptLoad) {
            try {
                log.debug((Object)"about to do loadMonitorData Method");
                returnMsg = WSDAO.loadMonitorData(docFile);
            }
            catch (CDXException e) {
                log.error((Object)DB_ERROR, (Throwable)e);
                returnMsg = DB_ERROR;
            }
            catch (IOException e) {
                log.error((Object)DB_ERROR, (Throwable)e);
                returnMsg = DB_ERROR;
            }
        }
        log.info((Object)("Finished asynchronous data loading for transaction " + this.docs.getTransaction().getTransactionID()));
        String transId = this.docs.getTransaction().getTransactionID();
        NodeDocument nodeDoc = new NodeDocument();
        byte[] content = null;
        content = this.getFileAsString(returnMsg).getBytes();
        nodeDoc.putContent(content, 0);
        nodeDoc.setName(transId);
        nodeDoc.setType("XML");
        WSNodeManager.sendNotification(transId, nodeDoc);
        log.info((Object)"Notification Sent to CDXNode");
    }

    private String getFileAsString(String retMsg) {
        String startFile = "<WS_Notify>\n";
        String notification = "<NotificationType>WS</NotificationType>\n";
        String endFile = "</WS_Notify>\n";
        String status = null;
        status = retMsg == null ? CDXPropertyManager.getProperty((String)"Notification", (String)"SuccessStatus") : CDXPropertyManager.getProperty((String)"Notification", (String)"FailedStatus");
        String statusLine = "<Status>" + status + "</Status>" + '\n';
        String msgLine = "<Message>" + retMsg + "</Message>" + '\n';
        String retValue = startFile + notification + statusLine + msgLine + endFile;
        return retValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

