/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.basedao;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.cfg.Configuration;

public class BaseManager {
    private static SessionFactory factory;
    protected static LogInterface log;
    static /* synthetic */ Class class$gov$epa$cdx$commons$basedao$BaseManager;

    public static SessionFactory getFactory() throws CDXException {
        try {
            if (factory == null) {
                factory = new Configuration().configure().buildSessionFactory();
            }
        }
        catch (HibernateException ex) {
            log.fatal("Error while configuring hibernate", ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
        return factory;
    }

    public static Session getSession() throws CDXException {
        try {
            return BaseManager.getFactory().openSession();
        }
        catch (HibernateException ex) {
            log.error("Error while obtaining hibernate session", ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
    }

    public static void closeSession(Session session) throws CDXException {
        try {
            session.close();
        }
        catch (HibernateException ex) {
            log.error("Error while closing hibernate session", ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
    }

    public static void rollback(Transaction tx) throws CDXException {
        try {
            tx.rollback();
        }
        catch (HibernateException ex) {
            log.error("Error while rolling back the transaction", ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
    }

    public static void save(Object object) throws CDXException {
        Session s = BaseManager.getSession();
        Transaction tx = null;
        try {
            tx = s.beginTransaction();
            s.save(object);
            tx.commit();
        }
        catch (HibernateException ex) {
            BaseManager.rollback(tx);
            log.error("Error while trying to save object " + object, ex);
            throw new CDXException(CDXErrorCode.DATA_FLOW_TYPE_MISSMATCH);
        }
        finally {
            BaseManager.closeSession(s);
        }
    }

    public static void update(Object object) throws CDXException {
        Session s = BaseManager.getSession();
        Transaction tx = null;
        try {
            tx = s.beginTransaction();
            s.update(object);
            tx.commit();
        }
        catch (HibernateException ex) {
            BaseManager.rollback(tx);
            log.error("Error while trying to update object " + object, ex);
            throw new CDXException(CDXErrorCode.DATA_FLOW_TYPE_MISSMATCH);
        }
        finally {
            BaseManager.closeSession(s);
        }
    }

    public static void delete(Object object) throws CDXException {
        Session s = BaseManager.getSession();
        Transaction tx = null;
        try {
            tx = s.beginTransaction();
            s.delete(object);
            tx.commit();
        }
        catch (HibernateException ex) {
            BaseManager.rollback(tx);
            log.error("Error while trying to delete object " + object, ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
        finally {
            BaseManager.closeSession(s);
        }
    }

    public static Object load(Class clazz, Serializable id, boolean initialize) throws CDXException {
        Session s = BaseManager.getSession();
        Transaction tx = null;
        Object obj = null;
        try {
            tx = s.beginTransaction();
            obj = s.get(clazz, id);
            if (initialize) {
                Hibernate.initialize((Object)obj);
            }
            tx.commit();
        }
        catch (HibernateException ex) {
            BaseManager.rollback(tx);
            log.error("Error while trying to load object for class " + clazz + " with id " + id, ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
        finally {
            BaseManager.closeSession(s);
        }
        return obj;
    }

    public static void delete(Class clazz, Serializable id) throws CDXException {
        Session s = BaseManager.getSession();
        Transaction tx = null;
        try {
            tx = s.beginTransaction();
            Object obj = s.get(clazz, id);
            s.delete(obj);
            tx.commit();
        }
        catch (HibernateException ex) {
            BaseManager.rollback(tx);
            log.error("Error while trying to delete object for class " + clazz + " with id " + id, ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR);
        }
        finally {
            BaseManager.closeSession(s);
        }
    }

    public static List performNamedQuery(String queryName) throws CDXException {
        return BaseManager.performNamedQuery(queryName, null);
    }

    public static List performNamedQuery(String queryName, Object bean) throws CDXException {
        List result;
        Session session = BaseManager.getSession();
        try {
            Query query = session.getNamedQuery(queryName);
            if (bean != null) {
                query.setProperties(bean);
            }
            result = query.list();
        }
        catch (HibernateException ex) {
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
        finally {
            BaseManager.closeSession(session);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((class$gov$epa$cdx$commons$basedao$BaseManager == null ? (class$gov$epa$cdx$commons$basedao$BaseManager = BaseManager.class$("gov.epa.cdx.commons.basedao.BaseManager")) : class$gov$epa$cdx$commons$basedao$BaseManager).getName());
    }
}

